/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbPreferences;

public class AutoupdateSettings {
    private static String tempIdeIdentity = null;
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services.AutoupdateSettings");
    private static final String PROP_IDE_IDENTITY = "ideIdentity";
    private static final String PROP_PERIOD = "period";
    private static final String PROP_LAST_CHECK = "lastCheckTime";
    public static final int EVERY_STARTUP = 0;
    public static final int EVERY_DAY = 1;
    public static final int EVERY_WEEK = 2;
    public static final int EVERY_2WEEKS = 3;
    public static final int EVERY_MONTH = 4;
    public static final int EVERY_NEVER = 5;

    private AutoupdateSettings() {
    }

    public static String getIdeIdentity() {
        if (tempIdeIdentity instanceof String) {
            return tempIdeIdentity;
        }
        String oldIdeIdentity = AutoupdateSettings.getPreferences().get(PROP_IDE_IDENTITY, null);
        String newIdeIdentity = null;
        newIdeIdentity = oldIdeIdentity == null ? AutoupdateSettings.modifyIdeIdentityIfNeeded(AutoupdateSettings.generateNewId()) : AutoupdateSettings.modifyIdeIdentityIfNeeded(oldIdeIdentity);
        tempIdeIdentity = newIdeIdentity;
        if (!newIdeIdentity.equals(oldIdeIdentity)) {
            err.log(Level.FINE, "Put new value of PROP_IDE_IDENTITY to " + newIdeIdentity);
            AutoupdateSettings.getPreferences().put(PROP_IDE_IDENTITY, newIdeIdentity);
        }
        return tempIdeIdentity;
    }

    public static int getPeriod() {
        return AutoupdateSettings.getPreferences().getInt(PROP_PERIOD, 2);
    }

    public static void setPeriod(int period) {
        AutoupdateSettings.getPreferences().putInt(PROP_PERIOD, period);
    }

    public static Date getLastCheck() {
        long t = AutoupdateSettings.getPreferences().getLong(PROP_LAST_CHECK, -1L);
        return t > 0L ? new Date(t) : null;
    }

    public static void setLastCheck(Date lastCheck) {
        err.log(Level.FINER, "Set the last check to " + lastCheck);
        if (lastCheck != null) {
            AutoupdateSettings.getPreferences().putLong(PROP_LAST_CHECK, lastCheck.getTime());
        } else {
            AutoupdateSettings.getPreferences().remove(PROP_LAST_CHECK);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String modifyIdeIdentityIfNeeded(String oldIdeIdentity) {
        String newPrefix;
        String oldPrefix;
        String id;
        block11: {
            int idx = oldIdeIdentity.indexOf(48);
            String[] ideIdentityArr = oldIdeIdentity.split("\\d");
            id = null;
            oldPrefix = null;
            if (ideIdentityArr.length == 0 || idx == 0) {
                id = oldIdeIdentity;
                oldPrefix = "";
            } else if (idx != -1 && oldIdeIdentity.substring(ideIdentityArr[0].length()).startsWith("0")) {
                oldPrefix = oldIdeIdentity.substring(0, idx);
                id = oldIdeIdentity.substring(oldPrefix.length());
            } else {
                oldPrefix = ideIdentityArr[0];
                id = oldIdeIdentity.substring(oldPrefix.length());
            }
            err.log(Level.FINER, "Old IDE Identity Prefix: " + oldPrefix);
            err.log(Level.FINER, "Old IDE Identity ID: " + id);
            newPrefix = "";
            try {
                FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("/productid");
                if (fo == null) break block11;
                InputStream is = fo.getInputStream();
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(is));
                    newPrefix = r.readLine().trim();
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ignore) {
                err.log(Level.FINER, ignore.getMessage(), ignore);
            }
        }
        if (!newPrefix.equals(oldPrefix)) {
            err.log(Level.FINER, "New IDE Identity Prefix: " + newPrefix);
        } else {
            err.log(Level.FINER, "No new prefix.");
        }
        return newPrefix + id;
    }

    private static String generateNewId() {
        return "0" + UUID.randomUUID().toString();
    }
}

