/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.services.UpdateUnitImpl;
import org.netbeans.modules.autoupdate.services.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationSupportImpl {
    private static final OperationSupportImpl FOR_INSTALL = new ForInstall();
    private static final OperationSupportImpl FOR_UPDATE = new ForUpdate();
    private static final OperationSupportImpl FOR_ENABLE = new ForEnable();
    private static final OperationSupportImpl FOR_DISABLE = new ForDisable();
    private static final OperationSupportImpl FOR_UNINSTALL = new ForUninstall();

    public static OperationSupportImpl forInstall() {
        return FOR_INSTALL;
    }

    public static OperationSupportImpl forUpdate() {
        return FOR_UPDATE;
    }

    public static OperationSupportImpl forUninstall() {
        return FOR_UNINSTALL;
    }

    public static OperationSupportImpl forEnable() {
        return FOR_ENABLE;
    }

    public static OperationSupportImpl forDisable() {
        return FOR_DISABLE;
    }

    public abstract void doOperation(ProgressHandle var1, OperationContainer<?> var2) throws OperationException;

    private OperationSupportImpl() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForDisable
    extends OperationSupportImpl {
        private ForDisable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            try {
                if (progress != null) {
                    progress.start();
                }
                HashSet<Module> modules = new HashSet<Module>();
                ModuleManager mm = null;
                List<OperationContainer.OperationInfo<?>> elements = container.listAll();
                for (OperationContainer.OperationInfo<?> operationInfo : elements) {
                    UpdateElement updateElement = operationInfo.getUpdateElement();
                    Module m = Utils.toModule(updateElement.getCodeName(), updateElement.getSpecificationVersion());
                    modules.add(m);
                    if (mm != null) continue;
                    mm = m.getManager();
                }
                assert (mm != null);
                mm.disable(modules);
            }
            finally {
                if (progress != null) {
                    progress.finish();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForEnable
    extends OperationSupportImpl {
        private ForEnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            try {
                if (progress != null) {
                    progress.start();
                }
                HashSet<Module> modules = new HashSet<Module>();
                ModuleManager mm = null;
                List<OperationContainer.OperationInfo<?>> elements = container.listAll();
                for (OperationContainer.OperationInfo<?> operationInfo : elements) {
                    UpdateElement updateElement = operationInfo.getUpdateElement();
                    Module m = Utils.toModule(updateElement.getCodeName(), updateElement.getSpecificationVersion());
                    modules.add(m);
                    if (mm != null) continue;
                    mm = m.getManager();
                }
                assert (mm != null);
                ForEnable.enable(mm, modules);
            }
            finally {
                if (progress != null) {
                    progress.finish();
                }
            }
        }

        private static boolean enable(ModuleManager mm, Set<Module> toRun) throws OperationException {
            boolean retval = false;
            try {
                mm.enable(toRun);
                retval = true;
            }
            catch (IllegalArgumentException ilae) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE);
            }
            catch (InvalidException ie) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE);
            }
            return retval;
        }
    }

    private static class ForInstall
    extends OperationSupportImpl {
        private ForInstall() {
        }

        public void doOperation(ProgressHandle progress, OperationContainer container) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForUninstall
    extends OperationSupportImpl {
        private ForUninstall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doOperation(ProgressHandle progress, OperationContainer<?> container) throws OperationException {
            try {
                UpdateUnit u;
                UpdateElement updateElement;
                if (progress != null) {
                    progress.start();
                }
                ModuleDeleterImpl deleter = new ModuleDeleterImpl();
                List<OperationContainer.OperationInfo<?>> elements = container.listAll();
                ArrayList<Module> modules = new ArrayList<Module>();
                for (OperationContainer.OperationInfo<?> operationInfo : elements) {
                    updateElement = operationInfo.getUpdateElement();
                    u = UpdateManagerImpl.getInstance().getUpdateUnit(updateElement.getCodeName());
                    modules.add(Utils.toModule(u));
                }
                try {
                    deleter.delete(modules.toArray(new Module[modules.size()]));
                }
                catch (IOException iex) {
                    throw new OperationException(OperationException.ERROR_TYPE.UNINSTALL);
                }
                for (OperationContainer.OperationInfo<?> operationInfo : elements) {
                    updateElement = operationInfo.getUpdateElement();
                    u = UpdateManagerImpl.getInstance().getUpdateUnit(updateElement.getCodeName());
                    assert (u.getInstalled() != null);
                    UpdateUnitImpl impl = Trampoline.API.impl(u);
                    impl.setAsUninstalled();
                }
            }
            finally {
                if (progress != null) {
                    progress.finish();
                }
            }
        }
    }

    private static class ForUpdate
    extends OperationSupportImpl {
        private ForUpdate() {
        }

        public void doOperation(ProgressHandle progress, OperationContainer container) throws OperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

