/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.Module;
import org.netbeans.ModuleManager;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.services.ModuleDeleterImpl;
import org.netbeans.modules.autoupdate.services.OperationContainerImpl;
import org.netbeans.modules.autoupdate.services.Utils;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OperationValidator {
    private static final OperationValidator FOR_INSTALL = new InstallValidator();
    private static final OperationValidator FOR_UNINSTALL = new UninstallValidator();
    private static final OperationValidator FOR_UPDATE = new UpdateValidator();
    private static final OperationValidator FOR_ENABLE = new EnableValidator();
    private static final OperationValidator FOR_DISABLE = new DisableValidator();
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.autoupdate.services.OperationValidator");

    private OperationValidator() {
    }

    static boolean isValidOperation(OperationContainerImpl.OperationType type, UpdateUnit updateUnit, UpdateElement updateElement) {
        boolean isValid = false;
        switch (type) {
            case INSTALL: {
                isValid = FOR_INSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case UNINSTALL: {
                isValid = FOR_UNINSTALL.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case UPDATE: {
                isValid = FOR_UPDATE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case ENABLE: {
                isValid = FOR_ENABLE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            case DISABLE: {
                isValid = FOR_DISABLE.isValidOperationImpl(updateUnit, updateElement);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return isValid;
    }

    static List<UpdateElement> getRequiredElements(OperationContainerImpl.OperationType type, UpdateElement updateElement, List<ModuleInfo> moduleInfos) {
        List<UpdateElement> retval = Collections.emptyList();
        switch (type) {
            case INSTALL: {
                retval = FOR_INSTALL.getRequiredElementsImpl(updateElement, moduleInfos);
                break;
            }
            case UNINSTALL: {
                retval = FOR_UNINSTALL.getRequiredElementsImpl(updateElement, moduleInfos);
                break;
            }
            case UPDATE: {
                retval = FOR_UPDATE.getRequiredElementsImpl(updateElement, moduleInfos);
                break;
            }
            case ENABLE: {
                retval = FOR_ENABLE.getRequiredElementsImpl(updateElement, moduleInfos);
                break;
            }
            case DISABLE: {
                retval = FOR_DISABLE.getRequiredElementsImpl(updateElement, moduleInfos);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return retval;
    }

    abstract boolean isValidOperationImpl(UpdateUnit var1, UpdateElement var2);

    abstract List<UpdateElement> getRequiredElementsImpl(UpdateElement var1, List<ModuleInfo> var2);

    private static boolean containsElement(UpdateElement el, UpdateUnit unit) {
        return unit.getAvailableUpdates().contains(el);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisableValidator
    extends OperationValidator {
        private DisableValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit unit, UpdateElement uElement) {
            Module m = Utils.toModule(unit.getCodeName(), uElement.getSpecificationVersion());
            return unit.getInstalled() != null && m != null && m.isEnabled() && !m.isFixed() && !m.isAutoload() && !m.isEager();
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement uElement, List<ModuleInfo> moduleInfos) {
            ModuleManager mm = null;
            LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
            for (ModuleInfo moduleInfo : moduleInfos) {
                Module m = Utils.toModule(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion().toString());
                modules.add(m);
                if (mm != null) continue;
                mm = m.getManager();
            }
            ArrayList<UpdateElement> retval = new ArrayList<UpdateElement>();
            if (mm != null) {
                List toDisable = mm.simulateDisable(modules);
                for (Module module : toDisable) {
                    if (modules.contains(module) || module.isAutoload() || module.isEager() || module.isFixed()) continue;
                    retval.add(Utils.toUpdateUnit(module).getInstalled());
                }
            }
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnableValidator
    extends OperationValidator {
        private EnableValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit unit, UpdateElement uElement) {
            Module m = Utils.toModule(unit.getCodeName(), uElement.getSpecificationVersion());
            return unit.getInstalled() != null && m != null && !m.isEnabled() && !m.isFixed() && !m.isAutoload() && !m.isEager();
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement uElement, List<ModuleInfo> moduleInfos) {
            ModuleManager mm = null;
            LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
            for (ModuleInfo moduleInfo : moduleInfos) {
                Module m = Utils.toModule(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion().toString());
                modules.add(m);
                if (mm != null) continue;
                mm = m.getManager();
            }
            ArrayList<UpdateElement> retval = new ArrayList<UpdateElement>();
            if (mm != null) {
                List toDisable = mm.simulateEnable(modules);
                for (Module module : toDisable) {
                    if (modules.contains(module) || module.isAutoload() || module.isEager() || module.isFixed()) continue;
                    retval.add(Utils.toUpdateUnit(module).getInstalled());
                }
            }
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstallValidator
    extends OperationValidator {
        private InstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit unit, UpdateElement uElement) {
            Module m = Utils.toModule(unit.getCodeName(), uElement.getSpecificationVersion());
            return m == null && unit.getInstalled() == null && OperationValidator.containsElement(uElement, unit);
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement uElement, List<ModuleInfo> moduleInfos) {
            return Utils.findRequiredModules(uElement, moduleInfos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UninstallValidator
    extends OperationValidator {
        private UninstallValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit unit, UpdateElement uElement) {
            Module m = Utils.toModule(unit.getCodeName(), uElement.getSpecificationVersion());
            return m != null && unit.getInstalled() != null && ModuleDeleterImpl.getInstance().canDelete(Utils.toModule(unit));
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement uElement, List<ModuleInfo> moduleInfos) {
            ModuleManager mm = null;
            LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
            for (ModuleInfo moduleInfo : moduleInfos) {
                Module m = Utils.toModule(moduleInfo.getCodeNameBase(), moduleInfo.getSpecificationVersion().toString());
                if (m.isEnabled()) {
                    modules.add(m);
                }
                if (mm != null) continue;
                mm = m.getManager();
            }
            ArrayList<UpdateElement> retval = new ArrayList<UpdateElement>();
            if (mm != null) {
                List<Module> toUninstall = UninstallValidator.requiredForUninstall(new ArrayList<Module>(), modules, mm.getEnabledModules(), mm);
                for (Module module : toUninstall) {
                    if (modules.contains(module) || module.isFixed()) continue;
                    retval.add(Utils.toUpdateUnit(module).getInstalled());
                }
            }
            return retval;
        }

        private static List<Module> requiredForUninstall(List<Module> resultToUninstall, Set<Module> requestedToUninstall, Set<Module> stillEnabled, ModuleManager mm) {
            resultToUninstall.addAll(requestedToUninstall);
            stillEnabled.removeAll(resultToUninstall);
            HashSet<Module> dependenciesToUninstall = new HashSet<Module>();
            for (Module m : requestedToUninstall) {
                for (Module other : stillEnabled) {
                    Dependency[] dependencies = other.getDependenciesArray();
                    boolean added = false;
                    for (int i = 0; !added && i < dependencies.length; ++i) {
                        Dependency dep = dependencies[i];
                        if (dep.getType() == 1) {
                            if (!dep.getName().equals(m.getCodeName())) continue;
                            added = true;
                            dependenciesToUninstall.add(other);
                            continue;
                        }
                        if (dep.getType() != 5 && dep.getType() != 6 && dep.getType() != 7 || !m.provides(dep.getName())) continue;
                        boolean foundOne = false;
                        for (Module third : mm.getEnabledModules()) {
                            if (!third.isEnabled() || resultToUninstall.contains(third) || dependenciesToUninstall.contains(third) || !third.provides(dep.getName())) continue;
                            foundOne = true;
                            break;
                        }
                        if (foundOne) continue;
                        added = true;
                        dependenciesToUninstall.add(other);
                    }
                }
            }
            if (dependenciesToUninstall.size() > 0) {
                UninstallValidator.requiredForUninstall(resultToUninstall, dependenciesToUninstall, stillEnabled, mm);
            }
            return resultToUninstall;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateValidator
    extends OperationValidator {
        private UpdateValidator() {
        }

        @Override
        boolean isValidOperationImpl(UpdateUnit unit, UpdateElement uElement) {
            Module m = Utils.toModule(unit.getCodeName(), uElement.getSpecificationVersion());
            return m == null && unit.getInstalled() != null && OperationValidator.containsElement(uElement, unit);
        }

        @Override
        List<UpdateElement> getRequiredElementsImpl(UpdateElement uElement, List<ModuleInfo> moduleInfos) {
            return FOR_INSTALL.getRequiredElementsImpl(uElement, moduleInfos);
        }
    }
}

