/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalog;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogFactory;
import org.netbeans.modules.autoupdate.updateprovider.LocalNBMsProvider;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UpdateUnitProviderImpl {
    private UpdateProvider provider;
    private static Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services.UpdateUnitProviderImpl");
    private static final String REMOVED_MASK = "_removed";

    public UpdateUnitProviderImpl(UpdateProvider provider) {
        this.provider = provider;
    }

    public String getName() {
        return this.getUpdateProvider().getName();
    }

    public String getDisplayName() {
        return UpdateUnitProviderImpl.loadDisplayName(this.getUpdateProvider());
    }

    public void setDisplayName(String name) {
        UpdateUnitProviderImpl.storeDisplayName(this.getUpdateProvider(), name);
    }

    public URL getProviderURL() {
        return UpdateUnitProviderImpl.loadUrl(this.getUpdateProvider());
    }

    public void setProviderURL(URL url) {
        UpdateUnitProviderImpl.storeUrl(this.getUpdateProvider(), url);
    }

    public List<UpdateUnit> getUpdateUnits() {
        return UpdateManagerImpl.getInstance().getUpdateUnits(this.getUpdateProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh(ProgressHandle handle, boolean force) throws IOException {
        boolean res = false;
        ProgressHandle ownHandle = null;
        if (handle == null) {
            ownHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(UpdateUnitProviderImpl.class, (String)"UpdateUnitProviderImpl_CheckingForUpdates"));
            ownHandle.setInitialDelay(0);
            ownHandle.start();
        }
        try {
            if (handle != null) {
                handle.progress(NbBundle.getMessage(UpdateUnitProviderImpl.class, (String)"UpdateUnitProviderImpl_FormatCheckingForUpdates", (Object)this.getDisplayName()));
            } else if (ownHandle != null) {
                ownHandle.progress(this.getDisplayName());
            }
            this.getUpdateProvider().refresh(force);
        }
        finally {
            if (ownHandle != null) {
                ownHandle.finish();
            }
        }
        UpdateManagerImpl.getInstance().cleanupUpdateUnits();
        return res;
    }

    public void setEnable(boolean state) {
        UpdateManagerImpl.getInstance().cleanupUpdateUnits();
        UpdateUnitProviderImpl.storeState(this.getUpdateProvider(), state);
    }

    public boolean isEnabled() {
        return UpdateUnitProviderImpl.loadState(this.getUpdateProvider().getName());
    }

    public UpdateProvider getUpdateProvider() {
        assert (this.provider != null) : "UpdateProvider found.";
        return this.provider;
    }

    public static void remove(UpdateUnitProvider unitProvider) {
        UpdateUnitProviderImpl impl = Trampoline.API.impl(unitProvider);
        impl.remove();
    }

    private void remove() {
        try {
            if (UpdateUnitProviderImpl.getPreferences().nodeExists(this.getName())) {
                UpdateUnitProviderImpl.getPreferences().node(this.getName()).removeNode();
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            } else {
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            }
        }
        catch (BackingStoreException bsx) {
            Exceptions.printStackTrace((Throwable)bsx);
        }
        UpdateManagerImpl.getInstance().cleanupUpdateUnits();
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String codeName, String displayName, URL url) {
        UpdateUnitProviderImpl.storeProvider(codeName, displayName, url);
        AutoupdateCatalog catalog = new AutoupdateCatalog(codeName, displayName, url);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(catalog));
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String name, File ... files) {
        LocalNBMsProvider provider = new LocalNBMsProvider(name, files);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(provider));
    }

    public static List<UpdateUnitProvider> getUpdateUnitProviders(boolean onlyEnabled) {
        Object p;
        FileObject auTypeFolder = Repository.getDefault().getDefaultFileSystem().findResource("Services/AutoupdateType");
        if (auTypeFolder != null) {
            FileObject[] auTypes = auTypeFolder.getChildren();
            for (int i = 0; i < auTypes.length; ++i) {
                try {
                    if (UpdateUnitProviderImpl.getPreferences().nodeExists(auTypes[i].getName())) continue;
                    try {
                        String bundle = (String)auTypes[i].getAttribute("SystemFileSystem.localizingBundle");
                        if (bundle != null) {
                            p = AutoupdateCatalogFactory.createUpdateProvider(auTypes[i]);
                            assert (p != null) : "UpdateProvider found for " + auTypes[i];
                            UpdateUnitProviderImpl.getPreferences().node(auTypes[i].getName()).putBoolean("loaded", Boolean.TRUE);
                            err.log(Level.FINEST, auTypes[i] + " loaded.");
                            continue;
                        }
                        err.log(Level.INFO, auTypes[i] + " cannot be loaded because doesn't contain SystemFileSystem.localizingBundle.");
                        UpdateUnitProviderImpl.getPreferences().node(auTypes[i].getName()).putBoolean("loaded", Boolean.FALSE);
                    }
                    catch (Exception x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                    continue;
                }
                catch (BackingStoreException bse) {
                    err.log(Level.INFO, bse.getMessage() + " while loading " + auTypes[i], bse);
                }
            }
        }
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(UpdateProvider.class));
        Collection col = result.allInstances();
        HashMap<String, UpdateProvider> providerMap = new HashMap<String, UpdateProvider>();
        for (UpdateProvider provider : col) {
            try {
                if (UpdateUnitProviderImpl.getPreferences().nodeExists(provider.getName() + REMOVED_MASK)) {
                    continue;
                }
            }
            catch (BackingStoreException bsx) {
                Exceptions.printStackTrace((Throwable)bsx);
            }
            providerMap.put(provider.getName(), provider);
        }
        try {
            p = UpdateUnitProviderImpl.getPreferences();
            String[] children = ((Preferences)p).childrenNames();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    UpdateProvider provider = UpdateUnitProviderImpl.loadProvider(children[i]);
                    if (provider != null && providerMap.containsKey(provider.getName())) {
                        err.log(Level.INFO, "Customized Provider " + provider.getName());
                    }
                    if (provider != null) {
                        providerMap.put(provider.getName(), provider);
                    }
                    boolean enabled = UpdateUnitProviderImpl.loadState(children[i]);
                    if (!onlyEnabled || enabled) continue;
                    providerMap.remove(children[i]);
                }
            }
        }
        catch (BackingStoreException bse) {
            err.log(Level.INFO, bse.getMessage(), bse);
        }
        ArrayList<UpdateUnitProvider> unitProviders = new ArrayList<UpdateUnitProvider>(providerMap.values().size());
        for (UpdateProvider p2 : providerMap.values()) {
            UpdateUnitProviderImpl impl = new UpdateUnitProviderImpl(p2);
            unitProviders.add(Trampoline.API.createUpdateUnitProvider(impl));
        }
        return unitProviders;
    }

    public static void refreshProviders(ProgressHandle handle, boolean force) throws IOException {
        List<UpdateUnitProvider> providers = UpdateUnitProviderImpl.getUpdateUnitProviders(true);
        for (UpdateUnitProvider p : providers) {
            p.refresh(handle, force);
        }
        if (force) {
            AutoupdateSettings.setLastCheck(new Date());
        }
        UpdateManagerImpl.getInstance().cleanupUpdateUnits();
    }

    private static void storeProvider(String codeName, String displayName, URL url) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(codeName);
        assert (providerPreferences != null) : "Preferences node " + codeName + " found.";
        providerPreferences.put("url", url.toString());
        providerPreferences.put("displayName", displayName);
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static UpdateProvider loadProvider(String codeName) {
        URL url;
        String displayName;
        block4: {
            Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(codeName);
            assert (providerPreferences != null) : "Preferences node " + codeName + " found.";
            String toUrl = providerPreferences.get("url", null);
            displayName = providerPreferences.get("displayName", codeName);
            if (toUrl == null) {
                return null;
            }
            url = null;
            try {
                url = new URL(toUrl);
            }
            catch (MalformedURLException mue) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)mue);
            }
        }
        return new AutoupdateCatalog(codeName, displayName, url);
    }

    private static boolean loadState(String codename) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(codename);
        assert (providerPreferences != null) : "Preferences node " + codename + " found.";
        String enabled = providerPreferences.get("enabled", null);
        return !Boolean.FALSE.toString().equals(enabled);
    }

    private static void storeState(UpdateProvider p, boolean isEnabled) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        providerPreferences.put("enabled", Boolean.valueOf(isEnabled).toString());
    }

    private static String loadDisplayName(UpdateProvider p) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        return providerPreferences.get("displayName", p.getDisplayName());
    }

    private static void storeDisplayName(UpdateProvider p, String displayName) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        if (displayName == null) {
            providerPreferences.remove("displayName");
        } else if (!displayName.equals(p.getDisplayName())) {
            providerPreferences.put("displayName", displayName);
        }
    }

    private static URL loadUrl(UpdateProvider p) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        String urlSpec = null;
        if (p instanceof AutoupdateCatalog) {
            urlSpec = ((AutoupdateCatalog)p).getUpdateCenterURL().toExternalForm();
        }
        if ((urlSpec = providerPreferences.get("url", urlSpec)) == null || urlSpec.length() == 0) {
            return null;
        }
        int idx = urlSpec.indexOf("?unique");
        if (idx != -1) {
            urlSpec = urlSpec.substring(0, idx);
        }
        err.log(Level.FINE, "Use urlSpec " + urlSpec + " for Provider " + p);
        URL url = null;
        try {
            url = new URL(urlSpec);
        }
        catch (MalformedURLException x) {
            err.log(Level.INFO, x.getMessage(), x);
        }
        return url;
    }

    private static void storeUrl(UpdateProvider p, URL url) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        if (url == null) {
            providerPreferences.remove("url");
        } else {
            URL orig = null;
            if (p instanceof AutoupdateCatalog) {
                orig = ((AutoupdateCatalog)p).getUpdateCenterURL();
            }
            if (!url.equals(orig)) {
                providerPreferences.put("url", url.toExternalForm());
                if (p instanceof AutoupdateCatalog) {
                    ((AutoupdateCatalog)p).setUpdateCenterURL(url);
                }
            }
        }
    }
}

