/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.services.AutoupdateCheckScheduler;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogCache;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogParser;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateCatalog
implements UpdateProvider {
    private URL updateCenter;
    private String codeName;
    private String displayName;
    private AutoupdateCatalogCache cache = AutoupdateCatalogCache.getDefault();
    private Logger log = Logger.getLogger("org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalog");

    public AutoupdateCatalog(String name, String displayName, URL updateCenter) {
        this.codeName = name;
        this.displayName = displayName;
        this.updateCenter = updateCenter;
    }

    @Override
    public String getName() {
        assert (this.codeName != null) : "UpdatesProvider must have a name.";
        return this.codeName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName == null ? this.codeName : this.displayName;
    }

    @Override
    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        URL toParse = this.cache.getCatalogURL(this.codeName);
        if (toParse == null) {
            this.log.log(Level.INFO, "No content in cache for " + this.codeName + " provider. Returns EMPTY_MAP");
            return Collections.emptyMap();
        }
        return AutoupdateCatalogParser.getUpdateItems(toParse, this.getUpdateCenterURL());
    }

    @Override
    public boolean refresh(boolean force) throws IOException {
        boolean res = false;
        this.log.log(Level.FINER, "Try write(force? " + force + ") to cache Update Provider " + this.codeName + " from " + this.getUpdateCenterURL());
        res = force ? this.cache.writeCatalogToCache(this.codeName, this.getUpdateCenterURL()) != null : (AutoupdateCheckScheduler.timeToCheck() ? this.cache.writeCatalogToCache(this.codeName, this.getUpdateCenterURL()) != null : true);
        return res;
    }

    public URL getUpdateCenterURL() {
        assert (this.updateCenter != null) : "XMLCatalogUpdatesProvider " + this.codeName + " must have a URL to Update Center";
        return this.updateCenter;
    }

    public void setUpdateCenterURL(URL newUpdateCenter) {
        assert (newUpdateCenter != null);
        this.updateCenter = newUpdateCenter;
    }

    public String toString() {
        return this.displayName + "[" + this.codeName + "] to " + this.updateCenter;
    }
}

