/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

public class AutoupdateCatalogCache {
    private static String GZIP_EXTENSION = ".gz";
    private File cacheDir;
    private static AutoupdateCatalogCache INSTANCE;
    private Logger err = Logger.getLogger(this.getClass().getName());

    public static AutoupdateCatalogCache getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new AutoupdateCatalogCache();
            INSTANCE.initCacheDirectory();
        }
        return INSTANCE;
    }

    public File getCatalogCache() {
        assert (this.cacheDir != null && this.cacheDir.exists());
        return this.cacheDir;
    }

    private void initCacheDirectory() {
        assert (this.cacheDir == null) : "Do initCacheDirectory only once!";
        String userDir = System.getProperty("netbeans.user");
        if (userDir != null) {
            this.cacheDir = new File(new File(new File(userDir, "var"), "cache"), "catalogcache");
        } else {
            File dir = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
            this.cacheDir = new File(dir, "catalogcache");
        }
        this.cacheDir.mkdirs();
        this.err.log(Level.FINE, "getCacheDirectory: " + this.cacheDir.getPath());
    }

    public URL writeCatalogToCache(String codeName, URL original) throws IOException {
        File cache;
        File dir;
        URL url;
        block4: {
            url = null;
            dir = this.getCatalogCache();
            assert (dir != null && dir.exists()) : "Cache directory must exist.";
            cache = new File(dir, codeName);
            this.copy(original, cache);
            try {
                url = cache.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)ex);
            }
        }
        assert (new File(dir, codeName).exists()) : "Cache " + cache + " exists.";
        this.err.log(Level.FINER, "Cache file " + cache + " was wrote from original URL " + original);
        return url;
    }

    public URL getCatalogURL(String codeName) {
        File dir = this.getCatalogCache();
        assert (dir != null && dir.exists()) : "Cache directory must exist.";
        File cache = new File(dir, codeName);
        if (cache != null && cache.exists()) {
            URL url;
            block4: {
                url = null;
                try {
                    url = cache.toURI().toURL();
                }
                catch (MalformedURLException ex) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)ex);
                }
            }
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(URL sourceUrl, File dest) throws IOException {
        this.err.log(Level.INFO, "Processing URL: " + sourceUrl);
        URL urlToGZip = null;
        BufferedInputStream is = null;
        try {
            String gzipFile = sourceUrl.getPath() + GZIP_EXTENSION;
            String query = sourceUrl.getQuery();
            if (query != null && query.trim().length() > 0) {
                gzipFile = gzipFile + '?' + query;
            }
            urlToGZip = new URL(sourceUrl.getProtocol(), sourceUrl.getHost(), sourceUrl.getPort(), gzipFile);
            is = new BufferedInputStream(new GZIPInputStream(urlToGZip.openStream()));
            this.err.log(Level.FINE, "Successfully read URL " + urlToGZip);
        }
        catch (IOException ioe) {
            try {
                this.err.log(Level.FINE, "Reading GZIP URL " + urlToGZip + " failed (" + ioe + "). Try read XML directly " + sourceUrl);
                is = new BufferedInputStream(sourceUrl.openStream());
                this.err.log(Level.FINE, "Successfully read URI " + sourceUrl);
            }
            catch (IOException ex) {
                this.err.log(Level.FINE, "Reading URL " + sourceUrl + " failed (" + ioe + ")");
                throw ex;
            }
        }
        FileOutputStream os = null;
        int read = 0;
        try {
            os = new FileOutputStream(dest);
            while ((read = is.read()) != -1) {
                os.write(read);
            }
        }
        catch (IOException ioe) {
            this.err.log(Level.INFO, "Writing content of URL " + sourceUrl + " failed.", ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.flush();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {
                this.err.log(Level.INFO, "Closing streams failed.", ioe);
            }
        }
    }
}

