/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalog;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class AutoupdateCatalogFactory {
    private static Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.updateproviders.AutoupdateCatalogFactory");
    private static final String UPDATE_VERSION_PROP = "netbeans.autoupdate.version";
    private static final String UPDATE_VERSION = "1.18";
    private static final String IDE_HASH_CODE = "netbeans.hash.code";
    private static final String SYSPROP_COUNTRY = "netbeans.autoupdate.country";
    private static final String SYSPROP_LANGUAGE = "netbeans.autoupdate.language";
    private static final String SYSPROP_VARIANT = "netbeans.autoupdate.variant";

    private AutoupdateCatalogFactory() {
    }

    public static UpdateProvider createUpdateProvider(FileObject fo) {
        String sKey = (String)fo.getAttribute("url_key");
        String remoteBundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
        assert (remoteBundleName != null) : "remoteBundleName should found in fo: " + fo;
        ResourceBundle bundle = NbBundle.getBundle((String)remoteBundleName);
        URL url = null;
        if (sKey != null) {
            String localizedValue = null;
            try {
                localizedValue = bundle.getString(sKey);
                url = new URL(localizedValue);
            }
            catch (MissingResourceException mre) {
                assert (false) : bundle + " should contain key " + sKey;
            }
            catch (MalformedURLException urlex) {
                assert (false) : "MalformedURLException when parsing name " + localizedValue;
            }
        } else {
            assert (false) : "url attrib ute is not supported.";
            Object o = fo.getAttribute("url");
            try {
                url = o instanceof String ? new URL((String)o) : (URL)o;
            }
            catch (MalformedURLException urlex) {
                err.log(Level.INFO, urlex.getMessage(), urlex);
            }
        }
        url = AutoupdateCatalogFactory.modifyURL(url);
        Boolean en = (Boolean)fo.getAttribute("enabled");
        AutoupdateCatalog au_catalog = new AutoupdateCatalog(sKey, AutoupdateCatalogFactory.displayName(fo), url);
        try {
            if (!AutoupdateCatalogFactory.getPreferences().nodeExists(sKey)) {
                Preferences providerPreferences = AutoupdateCatalogFactory.getPreferences().node(sKey);
                providerPreferences.put("url", url.toExternalForm());
                providerPreferences.put("displayName", au_catalog.getDisplayName());
                if (en != null) {
                    providerPreferences.put("enabled", en.toString());
                }
            }
        }
        catch (BackingStoreException bse) {
            err.log(Level.INFO, bse.getMessage(), bse);
        }
        return au_catalog;
    }

    private static String displayName(FileObject fo) {
        String displayName = null;
        if (fo != null) {
            try {
                FileSystem fs = fo.getFileSystem();
                FileSystem.Status s = fs.getStatus();
                String x = s.annotateName("", Collections.singleton(fo));
                if (!x.equals("")) {
                    displayName = x;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        if (displayName == null) {
            displayName = NbBundle.getBundle(AutoupdateCatalogFactory.class).getString("CTL_CatalogUpdatesProviderFactory_DefaultName");
        }
        return displayName;
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    private static URL modifyURL(URL original) {
        URL updateURL = null;
        if (System.getProperty(UPDATE_VERSION_PROP) == null) {
            System.setProperty(UPDATE_VERSION_PROP, UPDATE_VERSION);
        }
        if (System.getProperty(IDE_HASH_CODE) == null) {
            String id = AutoupdateCatalogFactory.getPreferences().get("ideIdentity", null);
            if (id == null) {
                Logger.getAnonymousLogger().warning("Property PROP_IDE_IDENTITY hasn't been initialized yet.");
                id = "";
            }
            String prefix = NbBundle.getBundle(AutoupdateCatalogFactory.class).getString("URL_Prefix_Hash_Code");
            System.setProperty(IDE_HASH_CODE, "".equals(id) ? prefix + "0" : prefix + id);
        }
        try {
            updateURL = new URL(AutoupdateCatalogFactory.encode(AutoupdateCatalogFactory.replace(original.toString())));
        }
        catch (MalformedURLException urlex) {
            err.log(Level.INFO, urlex.getMessage(), urlex);
        }
        return updateURL;
    }

    private static String encode(String stringURL) {
        String rval = stringURL;
        int q = stringURL.indexOf(63);
        if (q > 0) {
            StringBuffer buf = new StringBuffer(stringURL.substring(0, q + 1));
            StringTokenizer st = new StringTokenizer(stringURL.substring(q + 1), "&");
            while (st.hasMoreTokens()) {
                String a = st.nextToken();
                try {
                    int ei = a.indexOf(61);
                    if (ei < 0) {
                        buf.append(URLEncoder.encode(a, "UTF-8"));
                    } else {
                        buf.append(URLEncoder.encode(a.substring(0, ei), "UTF-8"));
                        buf.append('=');
                        String tna = a.substring(ei + 1);
                        int tni = tna.indexOf("%");
                        if (tni < 0) {
                            buf.append(URLEncoder.encode(tna, "UTF-8"));
                        } else {
                            buf.append(URLEncoder.encode(tna.substring(0, tni), "UTF-8"));
                            buf.append('%');
                            buf.append(URLEncoder.encode(tna.substring(tni + 1), "UTF-8"));
                        }
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.getAnonymousLogger().log(Level.INFO, ex.getMessage(), ex);
                }
                if (!st.hasMoreTokens()) continue;
                buf.append('&');
            }
            rval = buf.toString();
        }
        return rval;
    }

    private static String replace(String string) {
        AutoupdateCatalogFactory.setSystemProperties();
        if (string == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int prevIndex = 0;
        int index = 0;
        while ((index = string.indexOf("{", index)) != -1 && index < string.length() - 1) {
            if (string.charAt(index + 1) == '{' || string.charAt(index + 1) != '$') {
                ++index;
                continue;
            }
            sb.append(string.substring(prevIndex, index));
            int endBracketIndex = string.indexOf("}", index);
            if (endBracketIndex != -1) {
                String whatToReplace = string.substring(index + 2, endBracketIndex);
                sb.append(AutoupdateCatalogFactory.getReplacement(whatToReplace));
            }
            prevIndex = endBracketIndex == -1 ? index + 2 : endBracketIndex + 1;
            ++index;
        }
        if (prevIndex < string.length() - 1) {
            sb.append(string.substring(prevIndex));
        }
        return sb.toString();
    }

    private static void setSystemProperties() {
        if (System.getProperty(SYSPROP_COUNTRY, null) == null) {
            System.setProperty(SYSPROP_COUNTRY, Locale.getDefault().getCountry());
        }
        if (System.getProperty(SYSPROP_LANGUAGE, null) == null) {
            System.setProperty(SYSPROP_LANGUAGE, Locale.getDefault().getLanguage());
        }
        if (System.getProperty(SYSPROP_VARIANT, null) == null) {
            System.setProperty(SYSPROP_VARIANT, Locale.getDefault().getVariant());
        }
    }

    private static String getReplacement(String whatToReplace) {
        return System.getProperty(whatToReplace, "");
    }
}

