/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.autoupdate.updateprovider.SimpleItem;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateCatalogParser {
    public static final String TAG_MODULE_UPDATES = "module_updates";
    public static final String TAG_MODULE = "module";
    public static final String TAG_MODULE_GROUP = "module_group";
    public static final String TAG_FEATURE = "feature";
    public static final String TAG_LICENSE = "license";
    public static final String TAG_NOTIFICATION = "notification";
    public static final String ATTR_NOTIFICATION_URL = "url";
    public static final String TAG_ERROR = "error";
    public static final String TAG_AUTH_ERROR = "auth_error";
    public static final String TAG_OTHER_ERROR = "other_error";
    public static final String ATTR_MESSAGE_ERROR = "message";
    public static final String TAG_ELEMENT_L10N = "l10n";
    public static final String TAG_MANIFEST = "manifest";
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogParser");

    public static Map<String, UpdateItem> getUpdateItems(URL url, URL providerUrl) {
        HashMap<String, UpdateItem> items = new HashMap<String, UpdateItem>();
        Map<String, String> licenses = AutoupdateCatalogParser.getLicenses(url, providerUrl);
        try {
            List<SimpleItem> simpleItems = AutoupdateCatalogParser.createSimpleItems(AutoupdateCatalogParser.getDocument(url, providerUrl));
            for (SimpleItem simple : simpleItems) {
                if (simple instanceof SimpleItem.License) continue;
                UpdateItem update = simple.toUpdateItem(licenses);
                items.put(simple.getId(), update);
            }
        }
        catch (IOException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        return items;
    }

    static Map<String, String> getLicenses(URL url, URL providerUrl) {
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            List<SimpleItem> items = AutoupdateCatalogParser.createSimpleItems(AutoupdateCatalogParser.getDocument(url, providerUrl));
            for (SimpleItem item : items) {
                if (!(item instanceof SimpleItem.License)) continue;
                SimpleItem.License license = (SimpleItem.License)item;
                res.put(license.getLicenseId(), license.getLicenseContent());
            }
        }
        catch (IOException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        return res;
    }

    static Document getDocument(URL url, URL providerUrl) throws IOException, SAXException {
        Document doc = XMLUtil.parse((InputSource)new InputSource(url.toString()), (boolean)false, (boolean)false, null, (EntityResolver)AutoupdateCatalogParser.createAUResolver());
        if (providerUrl != null) {
            try {
                doc.setDocumentURI(providerUrl.toURI().toString());
            }
            catch (URISyntaxException ex) {
                ERR.log(Level.INFO, ex.getMessage(), ex);
            }
        }
        return doc;
    }

    static List<SimpleItem> createSimpleItems(Document xmlDocument) {
        NodeList moduleUpdatesList = xmlDocument.getElementsByTagName(TAG_MODULE_UPDATES);
        assert (moduleUpdatesList != null && moduleUpdatesList.getLength() == 1);
        NodeList moduleUpdatesChildren = moduleUpdatesList.item(0).getChildNodes();
        return AutoupdateCatalogParser.parseUpdateItems(moduleUpdatesChildren);
    }

    private static List<SimpleItem> parseUpdateItems(NodeList children) {
        ArrayList<SimpleItem> res = new ArrayList<SimpleItem>();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (1 != n.getNodeType()) continue;
            assert (n instanceof Element) : n + " is instanceof Element";
            String tagName = ((Element)n).getTagName();
            if (TAG_MODULE_GROUP.equals(tagName)) {
                res.addAll(AutoupdateCatalogParser.parseUpdateItems(n.getChildNodes()));
                continue;
            }
            if (TAG_MODULE.equals(tagName)) {
                NodeList l10nElements = ((Element)n).getElementsByTagName(TAG_ELEMENT_L10N);
                NodeList manifestElements = ((Element)n).getElementsByTagName(TAG_MANIFEST);
                if (l10nElements != null && l10nElements.getLength() > 0) {
                    res.add(new SimpleItem.Localization(n));
                    continue;
                }
                if (manifestElements != null && manifestElements.getLength() > 0) {
                    res.add(new SimpleItem.Module(n));
                    continue;
                }
                assert (false) : "Unknown element " + n;
                continue;
            }
            if (TAG_FEATURE.equals(tagName)) {
                res.add(new SimpleItem.Feature(n));
                continue;
            }
            if (TAG_LICENSE.equals(tagName)) {
                res.add(new SimpleItem.License(n));
                continue;
            }
            assert (false) : "Unknown element tag " + tagName;
        }
        return res;
    }

    private static String getAttribute(Node node, String attribute) {
        Node attr = node.getAttributes().getNamedItem(attribute);
        return attr == null ? null : attr.getNodeValue();
    }

    public static EntityResolver createAUResolver() {
        return new EntityResolver(){

            public InputSource resolveEntity(String publicID, String systemID) throws IOException, SAXException {
                if ("-//NetBeans//DTD Autoupdate Catalog 1.0//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-catalog-1_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 1.0//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-info-1_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.0//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-catalog-2_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.0//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-info-2_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.2//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-catalog-2_2.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.2//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-info-2_2.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.3//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-catalog-2_3.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.3//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-info-2_3.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 2.4//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-catalog-2_4.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 2.4//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-info-2_4.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Catalog 3.0//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-catalog-3_0.dtd").toString());
                }
                if ("-//NetBeans//DTD Autoupdate Module Info 3.0//EN".equals(publicID)) {
                    return new InputSource(AutoupdateCatalogParser.class.getResource("dtds/autoupdate-info-3_0.dtd").toString());
                }
                return null;
            }
        };
    }
}

