/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.updateprovider;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogParser;
import org.netbeans.modules.autoupdate.updateprovider.SimpleItem;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoupdateInfoParser {
    public static final String INFO_NAME = "info";
    public static final String INFO_EXT = ".xml";
    public static final String INFO_FILE = "info.xml";
    public static final String INFO_DIR = "Info";
    public static final String INFO_LOCALE = "locale";
    private static final Logger ERR = Logger.getLogger("org.netbeans.modules.autoupdate.updateprovider.AutoupdateInfoParser");

    public static Map<String, UpdateItem> getUpdateItems(File nbmFile) {
        HashMap<String, UpdateItem> items = new HashMap<String, UpdateItem>();
        try {
            Document doc = AutoupdateInfoParser.getAutoupdateInfo(nbmFile);
            SimpleItem simple = AutoupdateInfoParser.createSimpleItem(doc, false);
            assert (!(simple instanceof SimpleItem.License)) : simple + " is not instanceof License.";
            UpdateItem update = simple.toUpdateItem(AutoupdateInfoParser.getLicenses(nbmFile));
            items.put(simple.getId(), update);
        }
        catch (IOException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        return items;
    }

    public static Map<String, String> getLicenses(File nbmFile) {
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            Document doc = AutoupdateInfoParser.getAutoupdateInfo(nbmFile);
            SimpleItem simple = AutoupdateInfoParser.createSimpleItem(doc, true);
            assert (simple instanceof SimpleItem.License) : simple + " is instanceof License.";
            SimpleItem.License license = (SimpleItem.License)simple;
            res.put(license.getLicenseId(), license.getLicenseContent());
        }
        catch (IOException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            ERR.log(Level.INFO, ex.getMessage(), ex);
        }
        return res;
    }

    static SimpleItem createSimpleItem(Document xmlDocument, boolean onlyLicense) {
        assert (xmlDocument.getDocumentElement() != null) : xmlDocument + " contains DocumentElement.";
        NodeList moduleUpdatesChildren = xmlDocument.getChildNodes();
        return AutoupdateInfoParser.parseUpdateItem(moduleUpdatesChildren, onlyLicense);
    }

    static Document getAutoupdateInfo(File nbmFile) throws IOException, SAXException {
        JarFile jf = new JarFile(nbmFile);
        String locale = Locale.getDefault().toString();
        ZipEntry entry = jf.getEntry("Info/locale/info_" + locale + INFO_EXT);
        if (entry == null) {
            entry = jf.getEntry("Info/info.xml");
        }
        assert (entry != null) : "info.xml found in file " + nbmFile;
        InputSource xmlInputSource = new InputSource(jf.getInputStream(entry));
        Document retval = XMLUtil.parse((InputSource)xmlInputSource, (boolean)false, (boolean)false, null, (EntityResolver)AutoupdateCatalogParser.createAUResolver());
        if (retval != null) {
            jf.close();
            JarFileSystem jfs = new JarFileSystem();
            try {
                URL u;
                jfs.setJarFile(nbmFile);
                FileObject fo = jfs.findResource(entry.getName());
                URL uRL = u = fo != null ? URLMapper.findURL((FileObject)fo, (int)1) : null;
                if (u != null) {
                    retval.setDocumentURI(u.toURI().toString());
                }
            }
            catch (Exception iex) {
                Exceptions.printStackTrace((Throwable)iex);
            }
        }
        return retval;
    }

    private static SimpleItem parseUpdateItem(NodeList children, boolean onlyLicense) {
        SimpleItem res = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (1 != n.getNodeType()) continue;
            assert (n instanceof Element) : n + " is instanceof Element";
            String tagName = ((Element)n).getTagName();
            if ("module_group".equals(tagName)) {
                assert (false) : "module_group is not allowed in Info.xml";
                continue;
            }
            if ("module".equals(tagName)) {
                NodeList l10nElements = ((Element)n).getElementsByTagName("l10n");
                NodeList manifestElements = ((Element)n).getElementsByTagName("manifest");
                NodeList licenseElements = ((Element)n).getElementsByTagName("license");
                if (l10nElements != null && l10nElements.getLength() == 1) {
                    if (!onlyLicense) {
                        res = new SimpleItem.Localization(n);
                    }
                } else if (manifestElements != null && manifestElements.getLength() == 1 && !onlyLicense) {
                    res = new SimpleItem.Module(n);
                }
                if (licenseElements == null || licenseElements.getLength() != 1 || !onlyLicense) continue;
                res = new SimpleItem.License(licenseElements.item(0));
                continue;
            }
            if ("feature".equals(tagName)) {
                assert (false) : "feature is not allowed in Info.xml";
                continue;
            }
            if ("license".equals(tagName)) {
                if (!onlyLicense) continue;
                res = new SimpleItem.License(n);
                continue;
            }
            assert (false) : "Unknown element tag " + tagName;
        }
        return res;
    }
}

