/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PresentableFileEntry
extends FileEntry
implements Node.Cookie {
    static final long serialVersionUID = 3328227388376142699L;
    private transient Node nodeDelegate;
    private boolean modif = false;
    private transient PropertyChangeSupport changeSupport;
    private ChangeListener cookieL = new ChangeListener(){

        public void stateChanged(ChangeEvent ev) {
            PresentableFileEntry.this.firePropertyChange("cookie", null, null);
        }
    };
    private transient CookieSet cookieSet;
    private transient Object nodeDelegateMutex = new Object();

    public PresentableFileEntry(MultiDataObject obj, FileObject fo) {
        super(obj, fo);
    }

    protected abstract Node createNodeDelegate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Node getNodeDelegate() {
        Object object = this.nodeDelegateMutex;
        synchronized (object) {
            if (this.nodeDelegate == null) {
                this.nodeDelegate = this.createNodeDelegate();
            }
            return this.nodeDelegate;
        }
    }

    private static boolean setTemplate(FileObject fo, boolean newValue) throws IOException {
        Object old = fo.getAttribute("template");
        boolean oldValue = Boolean.TRUE.equals(old);
        if (newValue == oldValue) {
            return false;
        }
        fo.setAttribute("template", (Object)(newValue ? Boolean.TRUE : null));
        return true;
    }

    public final void setTemplate(boolean newValue) throws IOException {
        if (!PresentableFileEntry.setTemplate(this.getFile(), newValue)) {
            return;
        }
        this.firePropertyChange("template", !newValue, newValue);
    }

    public boolean isTemplate() {
        Object o = this.getFile().getAttribute("template");
        return Boolean.TRUE.equals(o);
    }

    public FileObject rename(String name) throws IOException {
        String oldName = this.getName();
        FileObject fo = super.rename(name);
        this.firePropertyChange("name", oldName, name);
        return fo;
    }

    public FileObject renameEntry(String name) throws IOException {
        return this.rename(name);
    }

    public void delete() throws IOException {
        super.delete();
        this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
    }

    public abstract boolean isDeleteAllowed();

    public abstract boolean isCopyAllowed();

    public abstract boolean isMoveAllowed();

    public boolean isShadowAllowed() {
        return true;
    }

    public abstract boolean isRenameAllowed();

    public boolean isModified() {
        return this.modif;
    }

    public void setModified(boolean modif) {
        if (this.modif != modif) {
            this.modif = modif;
            this.firePropertyChange("modified", !modif, modif);
        }
    }

    public abstract HelpCtx getHelpCtx();

    public String getName() {
        return this.getFile().getName();
    }

    public final DataFolder getFolder() {
        FileObject fo = this.getFile().getParent();
        return fo == null ? null : DataFolder.findFolder((FileObject)fo);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.getChangeSupport().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getChangeSupport().removePropertyChangeListener(l);
    }

    protected final void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.getChangeSupport().firePropertyChange(name, oldValue, newValue);
    }

    private final synchronized PropertyChangeSupport getChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.changeSupport;
    }

    protected final synchronized void setCookieSet(CookieSet s) {
        if (this.cookieSet != null) {
            this.cookieSet.removeChangeListener(this.cookieL);
        }
        s.addChangeListener(this.cookieL);
        this.cookieSet = s;
        this.firePropertyChange("cookie", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CookieSet getCookieSet() {
        CookieSet s = this.cookieSet;
        if (s != null) {
            return s;
        }
        PresentableFileEntry presentableFileEntry = this;
        synchronized (presentableFileEntry) {
            if (this.cookieSet != null) {
                return this.cookieSet;
            }
            this.setCookieSet(new CookieSet());
            return this.cookieSet;
        }
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        Node.Cookie cookie;
        CookieSet c = this.cookieSet;
        if (c != null && (cookie = c.getCookie(type)) != null) {
            return (T)cookie;
        }
        if (type.isInstance((Object)this)) {
            return (T)((Object)this);
        }
        return null;
    }
}

