/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.io.SafeException;

public final class PropertiesDataLoader
extends MultiFileLoader {
    static final String PROPERTIES_EXTENSION = "properties";
    public static final char PRB_SEPARATOR_CHAR = '_';
    static final long serialVersionUID = 4384899552891479449L;
    public static final String PROP_EXTENSIONS = "extensions";
    private Reference<PropertiesEncoding> encodingRef;

    public PropertiesDataLoader() {
        super("org.netbeans.modules.properties.PropertiesDataObject");
        ExtensionList extList = new ExtensionList();
        extList.addExtension(PROPERTIES_EXTENSION);
        extList.addExtension("impl");
        this.setExtensions(extList);
    }

    PropertiesEncoding getEncoding() {
        PropertiesEncoding encoding;
        if (this.encodingRef == null || (encoding = this.encodingRef.get()) == null) {
            encoding = new PropertiesEncoding();
            this.encodingRef = new SoftReference<PropertiesEncoding>(encoding);
        }
        return encoding;
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(PropertiesDataLoader.class, (String)"PROP_PropertiesLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/x-properties/Actions/";
    }

    protected MultiDataObject createMultiObject(FileObject fo) throws IOException {
        return new PropertiesDataObject(fo, this);
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        if (fo.getExt().equalsIgnoreCase(PROPERTIES_EXTENSION)) {
            String fName = fo.getName();
            int index = fName.indexOf(95);
            while (index != -1) {
                FileObject candidate = fo.getParent().getFileObject(fName.substring(0, index), fo.getExt());
                if (candidate != null) {
                    return candidate;
                }
                index = fName.indexOf(95, index + 1);
            }
            return fo;
        }
        return this.getExtensions().isRegistered(fo) ? fo : null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new PropertiesFileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        return new PropertiesFileEntry(obj, secondaryFile);
    }

    public void setExtensions(ExtensionList ext) {
        this.putProperty(PROP_EXTENSIONS, ext, true);
    }

    public ExtensionList getExtensions() {
        ExtensionList l = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (l == null) {
            l = new ExtensionList();
            this.putProperty(PROP_EXTENSIONS, l, false);
        }
        return l;
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.getProperty(PROP_EXTENSIONS));
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        SafeException se;
        try {
            super.readExternal(oi);
            se = null;
        }
        catch (SafeException se2) {
            se = se2;
        }
        this.setExtensions((ExtensionList)oi.readObject());
        if (se != null) {
            throw se;
        }
    }
}

