/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.properties.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PropertyPanel
extends JPanel {
    private Element.ItemElem element;
    private JLabel commentLabel;
    private JTextField commentText;
    private JLabel keyLabel;
    private JTextField keyText;
    private JLabel valueLabel;
    private JTextField valueText;

    public PropertyPanel(Element.ItemElem element) {
        this.element = element;
        this.initComponents();
        this.initAccessibility();
        this.keyText.setText(element.getKey());
        this.valueText.setText(element.getValue());
        this.commentText.setText(element.getComment());
        this.keyText.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        this.valueText.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        this.commentText.getKeymap().removeKeyStrokeBinding(KeyStroke.getKeyStroke(10, 0));
        HelpCtx.setHelpIDString((JComponent)this, (String)"propfiles.adding");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PropertyPanel.class).getString("ACS_PropertyPanel"));
        this.keyLabel.setLabelFor(this.keyText);
        this.valueLabel.setLabelFor(this.valueText);
        this.commentLabel.setLabelFor(this.commentText);
        this.keyText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PropertyPanel.class).getString("ACS_PropertyPanel"));
        this.valueText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PropertyPanel.class).getString("ACS_PropertyPanel"));
        this.commentText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PropertyPanel.class).getString("ACS_PropertyPanel"));
    }

    private void initComponents() {
        this.keyLabel = new JLabel();
        this.keyText = new JTextField(25);
        this.valueLabel = new JLabel();
        this.valueText = new JTextField(25);
        this.commentLabel = new JLabel();
        this.commentText = new JTextField(25);
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.keyLabel, (String)NbBundle.getBundle(PropertyPanel.class).getString("LBL_KeyLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.keyLabel, gridBagConstraints);
        this.keyText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.keyTextActionPerformed(evt);
            }
        });
        this.keyText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PropertyPanel.this.keyTextFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 7, 0, 11);
        this.add((Component)this.keyText, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)NbBundle.getBundle(PropertyPanel.class).getString("LBL_ValueLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        this.valueText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.valueTextActionPerformed(evt);
            }
        });
        this.valueText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PropertyPanel.this.valueTextFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 7, 0, 11);
        this.add((Component)this.valueText, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.commentLabel, (String)NbBundle.getBundle(PropertyPanel.class).getString("LBL_CommentLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 11, 0);
        this.add((Component)this.commentLabel, gridBagConstraints);
        this.commentText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.commentTextActionPerformed(evt);
            }
        });
        this.commentText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                PropertyPanel.this.commentTextFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 7, 11, 11);
        this.add((Component)this.commentText, gridBagConstraints);
    }

    private void valueTextFocusLost(FocusEvent evt) {
        this.valueTextHandler();
    }

    private void workaround11364(ActionEvent evt) {
        JButton defaultButton;
        JRootPane root = this.getRootPane();
        if (root != null && (defaultButton = root.getDefaultButton()) != null) {
            defaultButton.doClick();
        }
    }

    private void valueTextActionPerformed(ActionEvent evt) {
        this.valueTextHandler();
        this.workaround11364(evt);
    }

    private void valueTextHandler() {
        this.element.getValueElem().setValue(this.valueText.getText());
    }

    private void keyTextFocusLost(FocusEvent evt) {
        this.keyTextHandler();
    }

    private void keyTextActionPerformed(ActionEvent evt) {
        this.keyTextHandler();
        this.workaround11364(evt);
    }

    private void keyTextHandler() {
        this.element.getKeyElem().setValue(this.keyText.getText());
    }

    private void commentTextFocusLost(FocusEvent evt) {
        this.commentTextHandler();
    }

    private void commentTextActionPerformed(ActionEvent evt) {
        this.commentTextHandler();
        this.workaround11364(evt);
    }

    private void commentTextHandler() {
        this.element.getCommentElem().setValue(this.commentText.getText());
    }
}

