/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openidex.search.SearchInfo;

class CompoundSearchIterator
implements Iterator {
    private final SearchInfo[] elements;
    private int elementIndex;
    private Iterator elementIterator;
    private Object nextObject;
    private boolean upToDate;
    static final /* synthetic */ boolean $assertionsDisabled;

    CompoundSearchIterator(SearchInfo[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        if (elements.length == 0) {
            this.elements = null;
            this.elementIndex = 0;
            this.upToDate = true;
        } else {
            this.elements = elements;
            this.elementIndex = 0;
            this.elementIterator = elements[0].objectsToSearch();
            this.upToDate = false;
        }
    }

    public boolean hasNext() {
        if (!this.upToDate) {
            this.update();
        }
        return this.elements != null && this.elementIndex < this.elements.length;
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.upToDate = false;
        return this.nextObject;
    }

    private void update() {
        if (!$assertionsDisabled && this.upToDate) {
            throw new AssertionError();
        }
        while (!this.elementIterator.hasNext()) {
            this.elements[this.elementIndex] = null;
            if (++this.elementIndex == this.elements.length) break;
            this.elementIterator = this.elements[this.elementIndex].objectsToSearch();
        }
        if (this.elementIndex < this.elements.length) {
            this.nextObject = this.elementIterator.next();
        } else {
            this.elementIterator = null;
            this.nextObject = null;
        }
        this.upToDate = true;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        $assertionsDisabled = !CompoundSearchIterator.class.desiredAssertionStatus();
    }
}

