/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.GlobalContextAction;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public abstract class MainMenuAction
extends GlobalContextAction
implements Presenter.Menu,
ChangeListener {
    public static final Icon BLANK_ICON = new ImageIcon(org.openide.util.Utilities.loadImage((String)"org/netbeans/modules/editor/resources/empty.gif"));
    public boolean menuInitialized = false;
    private final Icon forcedIcon;
    private boolean forceIcon;

    public MainMenuAction() {
        this(true, null);
    }

    public MainMenuAction(boolean forceIcon, Icon forcedIcon) {
        Registry.addChangeListener((ChangeListener)this);
        this.forceIcon = forceIcon;
        this.forcedIcon = forcedIcon;
    }

    public void resultChanged(LookupEvent ev) {
        this.setMenu();
    }

    public void stateChanged(ChangeEvent e) {
        this.setMenu();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return this.getMenuItemText();
    }

    private static JTextComponent getComponent() {
        return Utilities.getFocusedComponent();
    }

    private static Action getActionByName(String actionName) {
        BaseKit bKit = MainMenuAction.getKit();
        if (bKit != null) {
            Action action = bKit.getActionByName(actionName);
            return action;
        }
        return null;
    }

    protected static void addAccelerators(Action a, JMenuItem item, JTextComponent target) {
        Keymap km;
        if (target == null || a == null || item == null) {
            return;
        }
        Action kitAction = MainMenuAction.getActionByName((String)a.getValue("Name"));
        if (kitAction != null) {
            a = kitAction;
        }
        if ((km = target.getKeymap()) != null) {
            KeyStroke[] keys = km.getKeyStrokesForAction(a);
            KeyStroke itemAccelerator = item.getAccelerator();
            if (keys != null && keys.length > 0) {
                if (itemAccelerator == null || !itemAccelerator.equals(keys[0])) {
                    item.setAccelerator(keys[0]);
                }
            } else if (itemAccelerator != null && kitAction != null) {
                item.setAccelerator(null);
            }
        }
    }

    private static BaseKit getKit() {
        JTextComponent component = MainMenuAction.getComponent();
        return component == null ? null : Utilities.getKit((JTextComponent)component);
    }

    public boolean isEnabled() {
        return false;
    }

    private static Object getSettingValue(BaseKit kit, String settingName) {
        return Settings.getValue(kit.getClass(), (String)settingName);
    }

    private static boolean getSettingBoolean(BaseKit kit, String settingName) {
        Boolean val = (Boolean)MainMenuAction.getSettingValue(kit, settingName);
        return val != null ? val : false;
    }

    protected Action getGlobalKitAction() {
        return null;
    }

    protected void setMenu() {
        JMenuItem presenter;
        Action presenterAction;
        ActionMap am = this.getContextActionMap();
        Action action = null;
        if (am != null) {
            action = am.get(this.getActionName());
        }
        if (action == null) {
            action = this.getGlobalKitAction();
        }
        if ((presenterAction = (presenter = this.getMenuPresenter()).getAction()) == null) {
            if (action != null) {
                presenter.setAction(action);
                presenter.setToolTipText(null);
                this.menuInitialized = false;
            }
        } else if (action != null && !action.equals(presenterAction)) {
            presenter.setAction(action);
            presenter.setToolTipText(null);
            this.menuInitialized = false;
        }
        if (!this.menuInitialized) {
            Mnemonics.setLocalizedText((AbstractButton)presenter, (String)this.getMenuItemText());
            this.menuInitialized = true;
        }
        presenter.setEnabled(action != null);
        JTextComponent comp = Utilities.getFocusedComponent();
        if (comp != null && comp instanceof JEditorPane) {
            MainMenuAction.addAccelerators(action, presenter, comp);
        } else {
            presenter.setAccelerator(this.getDefaultAccelerator());
        }
        if (this.forceIcon) {
            presenter.setIcon(this.forcedIcon);
        }
    }

    protected abstract String getMenuItemText();

    protected abstract String getActionName();

    protected KeyStroke getDefaultAccelerator() {
        List lst;
        Lookup ml = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java"));
        KeyBindingSettings kbs = (KeyBindingSettings)ml.lookup(KeyBindingSettings.class);
        if (kbs != null && (lst = kbs.getKeyBindings()) != null) {
            for (int i = 0; i < lst.size(); ++i) {
                MultiKeyBinding mkb = (MultiKeyBinding)lst.get(i);
                String an = mkb.getActionName();
                if (an == null || !an.equals(this.getActionName()) || mkb.getKeyStrokeCount() != 1) continue;
                return mkb.getKeyStroke(0);
            }
        }
        return null;
    }

    public static final class CommentAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public CommentAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(CommentAction.class).getString("comment_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "comment";
        }
    }

    public static final class FindNextAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindNextAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(FindNextAction.class).getString("find_next_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-next";
        }
    }

    public static final class FindPreviousAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindPreviousAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(FindNextAction.class).getString("find_previous_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-previous";
        }
    }

    public static final class FindSelectionAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public FindSelectionAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(FindNextAction.class).getString("find_selection_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "find-selection";
        }
    }

    public static final class FormatAction
    extends MainMenuAction {
        private JMenuItem formatMenuItem = new JMenuItem(this.getMenuItemText());

        public FormatAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(FormatAction.class).getString("format_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.formatMenuItem;
        }

        protected String getActionName() {
            return "format";
        }
    }

    public static class GoToDeclarationAction
    extends MainMenuAction {
        private JMenuItem GOTO_DECL_MENU = new JMenuItem(this.getMenuItemText());

        public GoToDeclarationAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("goto_declaration_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_DECL_MENU;
        }

        protected String getActionName() {
            return "goto-declaration";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(71, 8);
        }
    }

    public static class GoToSourceAction
    extends MainMenuAction {
        private JMenuItem GOTO_SOURCE_MENU = new JMenuItem(this.getMenuItemText());

        public GoToSourceAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("goto_source_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_SOURCE_MENU;
        }

        protected String getActionName() {
            return "goto-source";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(79, 8);
        }
    }

    public static class GoToSuperAction
    extends MainMenuAction {
        private JMenuItem GOTO_SUPER_MENU = new JMenuItem(this.getMenuItemText());

        public GoToSuperAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("goto_super_implementation_main_menu_edit_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.GOTO_SUPER_MENU;
        }

        protected String getActionName() {
            return "goto-super-implementation";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(66, 2);
        }
    }

    public static final class JumpBackAction
    extends MainMenuAction {
        private JMenuItem jumpBackMenuItem = new JMenuItem(this.getMenuItemText());

        public JumpBackAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(JumpBackAction.class).getString("jump_back_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.jumpBackMenuItem;
        }

        protected String getActionName() {
            return "jump-list-prev";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(75, 8);
        }
    }

    public static final class JumpForwardAction
    extends MainMenuAction {
        private JMenuItem jumpForwardMenuItem = new JMenuItem(this.getMenuItemText());

        public JumpForwardAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(JumpForwardAction.class).getString("jump_forward_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.jumpForwardMenuItem;
        }

        protected String getActionName() {
            return "jump-list-next";
        }

        protected KeyStroke getDefaultAccelerator() {
            return KeyStroke.getKeyStroke(76, 8);
        }
    }

    public static final class PasteFormattedAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public PasteFormattedAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(PasteFormattedAction.class).getString("paste_formatted_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "paste-formated";
        }
    }

    public static final class RemoveTrailingSpacesAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public RemoveTrailingSpacesAction() {
            super(true, null);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(RemoveTrailingSpacesAction.class).getString("remove_trailing_spaces_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "remove-trailing-spaces";
        }
    }

    public static final class ShiftLineLeftAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public ShiftLineLeftAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(ShiftLineLeftAction.class).getString("shift_line_left_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "shift-line-left";
        }
    }

    public static final class ShiftLineRightAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public ShiftLineRightAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(ShiftLineRightAction.class).getString("shift_line_right_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "shift-line-right";
        }
    }

    public static class ShowLineNumbersAction
    extends MainMenuAction {
        private JCheckBoxMenuItem SHOW_LINE_MENU = new JCheckBoxMenuItem(this.getMenuItemText());
        private Action delegate = null;

        public ShowLineNumbersAction() {
            super(false, null);
            this.setMenu();
        }

        protected void setMenu() {
            super.setMenu();
            boolean visible = AllOptionsFolder.getDefault().getLineNumberVisible();
            this.SHOW_LINE_MENU.setState(visible);
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("show_line_numbers_main_menu_view_item");
        }

        public String getName() {
            return this.getMenuItemText();
        }

        public JMenuItem getMenuPresenter() {
            return this.SHOW_LINE_MENU;
        }

        protected String getActionName() {
            return "toggle-line-numbers";
        }

        protected Action getGlobalKitAction() {
            if (this.delegate == null) {
                this.delegate = new NbEditorKit.NbToggleLineNumbersAction();
            }
            return this.delegate;
        }
    }

    public static class ShowToolBarAction
    extends MainMenuAction {
        private static JCheckBoxMenuItem SHOW_TOOLBAR_MENU;
        private Action delegate = null;

        public ShowToolBarAction() {
            super(false, null);
            SHOW_TOOLBAR_MENU = new JCheckBoxMenuItem(this.getMenuItemText());
            this.setMenu();
        }

        protected void setMenu() {
            super.setMenu();
            boolean visible = AllOptionsFolder.getDefault().isToolbarVisible();
            SHOW_TOOLBAR_MENU.setState(visible);
        }

        public JMenuItem getMenuPresenter() {
            return SHOW_TOOLBAR_MENU;
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(MainMenuAction.class).getString("show_editor_toolbar_main_menu_view_item");
        }

        protected String getActionName() {
            return "toggle-toolbar";
        }

        protected Action getGlobalKitAction() {
            if (this.delegate == null) {
                this.delegate = new NbEditorKit.ToggleToolbarAction();
            }
            return this.delegate;
        }
    }

    public static final class StartMacroRecordingAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public StartMacroRecordingAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(StartMacroRecordingAction.class).getString("start_macro_recording_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "start-macro-recording";
        }
    }

    public static final class StopMacroRecordingAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public StopMacroRecordingAction() {
            super(true, BLANK_ICON);
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(StopMacroRecordingAction.class).getString("stop_macro_recording_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "stop-macro-recording";
        }
    }

    public static final class UncommentAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public UncommentAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(UncommentAction.class).getString("uncomment_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "uncomment";
        }
    }

    public static final class WordMatchNextAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public WordMatchNextAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(WordMatchNextAction.class).getString("word_match_next_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "word-match-next";
        }
    }

    public static final class WordMatchPrevAction
    extends MainMenuAction {
        private JMenuItem menuItem = new JMenuItem(this.getMenuItemText());

        public WordMatchPrevAction() {
            this.setMenu();
        }

        protected String getMenuItemText() {
            return NbBundle.getBundle(WordMatchPrevAction.class).getString("word_match_previous_main_menu_item");
        }

        public JMenuItem getMenuPresenter() {
            return this.menuItem;
        }

        protected String getActionName() {
            return "word-match-prev";
        }
    }
}

