/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseSettingsInitializer;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.ext.ExtSettingsInitializer;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.impl.KitsTracker;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.BasePrintOptions;
import org.netbeans.modules.editor.options.OptionUtilities;
import org.openide.util.Utilities;

public class NbEditorSettingsInitializer
extends Settings.AbstractInitializer {
    private static final Logger LOG = Logger.getLogger(NbEditorSettingsInitializer.class.getName());
    public static final String NAME = "nb-editor-settings-initializer";
    private static boolean mainInitDone;

    public static void init() {
        if (!mainInitDone) {
            mainInitDone = true;
            Settings.addInitializer((Settings.Initializer)new BaseSettingsInitializer(), (int)0);
            Settings.addInitializer((Settings.Initializer)new ExtSettingsInitializer(), (int)0);
            Settings.addInitializer((Settings.Initializer)new NbEditorSettingsInitializer());
            Settings.reset();
            BasePrintOptions bpo = (BasePrintOptions)BasePrintOptions.findObject(BasePrintOptions.class, (boolean)true);
            bpo.init();
        }
    }

    public NbEditorSettingsInitializer() {
        super(NAME);
    }

    public void updateSettingsMap(Class kitClass, Map settingsMap) {
        if (kitClass == BaseKit.class) {
            settingsMap.put("toolbarVisible", Boolean.TRUE);
            settingsMap.put("lineNumberVisible", SettingsDefaults.defaultLineNumberVisible);
            int activationMask = Utilities.isMac() ? 4 : 128;
            settingsMap.put("hyperlink-activation-modifiers", activationMask);
        }
        if (kitClass == NbEditorKit.class && AllOptionsFolder.getDefault().baseInitialized()) {
            settingsMap.put("popup-menu-action-name-list", OptionUtilities.getPopupStrings(OptionUtilities.getGlobalPopupMenuItems()));
        }
        List mimeTypes = KitsTracker.getInstance().getMimeTypesForKitClass(kitClass);
        for (String mimeType : mimeTypes) {
            MimePath mimePath;
            BaseOptions bo;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Initializing settings for '" + mimeType + "', " + kitClass);
            }
            if ((bo = (BaseOptions)((Object)MimeLookup.getLookup((MimePath)(mimePath = MimePath.parse((String)mimeType))).lookup(BaseOptions.class))) != null || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("Top level mime type '" + mimeType + "' with no BaseOptions.");
        }
    }
}

