/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.modules.editor.NbEditorToolBar;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.impl.CustomizableSideBar;
import org.netbeans.modules.editor.options.AllOptionsFolder;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class NbEditorUI
extends ExtEditorUI {
    private FocusListener focusL = new FocusAdapter(){

        public void focusGained(FocusEvent evt) {
            FileObject fo;
            DataObject dob;
            BaseDocument doc = NbEditorUI.this.getDocument();
            if (doc != null && (dob = NbEditorUtilities.getDataObject((Document)doc)) != null && (fo = dob.getPrimaryFile()) != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        fo.refresh();
                    }
                });
            }
        }
    };
    private boolean attached = false;
    private ChangeListener listener;
    private FontColorSettings fontColorSettings;
    private LookupListener weakLookupListener;
    private Lookup.Result result;
    private LookupListener lookupListener;
    private static final Map mime2Coloring = new HashMap(5);

    protected SystemActionUpdater createSystemActionUpdater(String editorActionName, boolean updatePerformer, boolean syncEnabling) {
        return new SystemActionUpdater(editorActionName, updatePerformer, syncEnabling);
    }

    private static Lookup getContextLookup(Component component) {
        Lookup lookup = null;
        for (Component c = component; !(c == null || c instanceof Lookup.Provider && (lookup = ((Lookup.Provider)c).getLookup()) != null); c = c.getParent()) {
        }
        return lookup;
    }

    protected void attachSystemActionPerformer(String editorActionName) {
        new SystemActionPerformer(editorActionName);
    }

    private String getDocumentContentType() {
        JTextComponent c = this.getComponent();
        if (c == null) {
            return null;
        }
        Document doc = c.getDocument();
        String mimeType = (String)doc.getProperty("mimeType");
        if (mimeType == null) {
            return null;
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontColorSettings getFontColorSettings() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (this.fontColorSettings == null) {
                String mimeType = this.getDocumentContentType();
                if (mimeType == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType));
                this.result = lookup.lookup(new Lookup.Template(FontColorSettings.class));
                Collection inst = this.result.allInstances();
                this.lookupListener = new MyLookupListener(mimeType);
                this.weakLookupListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, (Object)this.result);
                this.result.addLookupListener(this.weakLookupListener);
                if (inst.size() > 0) {
                    this.fontColorSettings = (FontColorSettings)inst.iterator().next();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fontColorSettings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map createColoringMap() {
        FontColorSettings fcs = this.getFontColorSettings();
        String mimeType = this.getDocumentContentType();
        if (fcs == null || mimeType == null) {
            return super.createColoringMap();
        }
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            HashMap<String, Coloring> cm = (HashMap<String, Coloring>)mime2Coloring.get(mimeType);
            if (cm != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return cm;
            }
            cm = new HashMap<String, Coloring>();
            cm.putAll(super.createColoringMap());
            for (Object nameObj : cm.keySet()) {
                String name;
                AttributeSet as;
                if (!(nameObj instanceof String) || (as = fcs.getTokenFontColors(name = (String)nameObj)) == null && (as = fcs.getFontColors(name)) == null) continue;
                cm.put(name, Coloring.fromAttributeSet((AttributeSet)as));
            }
            mime2Coloring.put(mimeType, cm);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cm;
        }
    }

    protected void installUI(JTextComponent c) {
        super.installUI(c);
        if (!this.attached) {
            this.attachSystemActionPerformer("find");
            this.attachSystemActionPerformer("replace");
            this.attachSystemActionPerformer("goto");
            this.attachSystemActionPerformer("show-popup-menu");
            this.attached = true;
        }
        c.addFocusListener(this.focusL);
    }

    protected void uninstallUI(JTextComponent c) {
        super.uninstallUI(c);
        c.removeFocusListener(this.focusL);
    }

    protected JComponent createExtComponent() {
        final JTextComponent component = this.getComponent();
        final JPanel ec = new JPanel(new BorderLayout());
        ec.putClientProperty(JTextComponent.class, component);
        final JScrollPane scroller = new JScrollPane(component);
        scroller.getViewport().setMinimumSize(new Dimension(4, 4));
        Border empty = BorderFactory.createEmptyBorder();
        scroller.setBorder(empty);
        scroller.setViewportBorder(empty);
        String mimeType = NbEditorUtilities.getMimeType(component);
        Map<CustomizableSideBar.SideBarPosition, JComponent> sideBars = CustomizableSideBar.getSideBars(component);
        if (this.listener == null) {
            this.listener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (Utilities.getEditorUI((JTextComponent)component) == null) {
                        return;
                    }
                    Map<CustomizableSideBar.SideBarPosition, JComponent> newMap = CustomizableSideBar.getSideBars(component);
                    NbEditorUI.this.processSideBars(newMap, scroller, ec);
                    ec.revalidate();
                    ec.repaint();
                }
            };
            CustomizableSideBar.addChangeListener(mimeType, this.listener);
        }
        this.processSideBars(sideBars, scroller, ec);
        this.initGlyphCorner(scroller);
        ec.add(scroller);
        return ec;
    }

    public boolean isLineNumberEnabled() {
        return AllOptionsFolder.getDefault().getLineNumberVisible();
    }

    public void setLineNumberEnabled(boolean lineNumberEnabled) {
        AllOptionsFolder.getDefault().setLineNumberVisible(lineNumberEnabled);
    }

    private void processSideBars(Map sideBars, JScrollPane scroller, JComponent ec) {
        ec.removeAll();
        scroller.setRowHeader(null);
        scroller.setColumnHeaderView(null);
        for (Map.Entry entry : sideBars.entrySet()) {
            CustomizableSideBar.SideBarPosition position = (CustomizableSideBar.SideBarPosition)entry.getKey();
            JComponent sideBar = (JComponent)entry.getValue();
            if (position.isScrollable()) {
                if (position.getPosition() == 1) {
                    scroller.setRowHeaderView(sideBar);
                    continue;
                }
                if (position.getPosition() == 2) {
                    scroller.setColumnHeaderView(sideBar);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported side bar position, scrollable = true, position=" + position.getBorderLayoutPosition());
            }
            ec.add((Component)sideBar, position.getBorderLayoutPosition());
        }
        ec.add(scroller);
    }

    protected JToolBar createToolBarComponent() {
        return new NbEditorToolBar(this.getComponent());
    }

    public Map getColoringMap() {
        return this.createColoringMap();
    }

    static class EnabledPropertySyncListener
    implements PropertyChangeListener {
        Action action;

        EnabledPropertySyncListener(Action actionToBeSynced) {
            this.action = actionToBeSynced;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                this.action.setEnabled((Boolean)evt.getNewValue());
            }
        }
    }

    private class MyLookupListener
    implements LookupListener {
        private String mimeType;

        public MyLookupListener(String mimeType) {
            this.mimeType = mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            Class<Settings> clazz = Settings.class;
            synchronized (Settings.class) {
                mime2Coloring.remove(this.mimeType);
                Lookup.Result result = (Lookup.Result)ev.getSource();
                Collection newInstances = result.allInstances();
                if (newInstances.size() > 0) {
                    NbEditorUI.this.fontColorSettings = (FontColorSettings)newInstances.iterator().next();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                NbEditorUI.this.settingsChangeImpl(null);
                return;
            }
        }
    }

    private class SystemActionPerformer
    implements PropertyChangeListener {
        private String editorActionName;
        private Action editorAction;
        private Action systemAction;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SystemActionPerformer(String editorActionName) {
            this.editorActionName = editorActionName;
            Object object = NbEditorUI.this.getComponentLock();
            synchronized (object) {
                JTextComponent component = NbEditorUI.this.getComponent();
                if (component != null) {
                    this.propertyChange(new PropertyChangeEvent((Object)NbEditorUI.this, "component", null, component));
                }
                NbEditorUI.this.addPropertyChangeListener(this);
            }
        }

        private void attachSystemActionPerformer(JTextComponent c) {
            if (c == null) {
                return;
            }
            Action editorAction = this.getEditorAction(c);
            if (editorAction == null) {
                return;
            }
            Action globalSystemAction = this.getSystemAction(c);
            if (globalSystemAction == null) {
                return;
            }
            if (globalSystemAction instanceof CallbackSystemAction) {
                Object key = ((CallbackSystemAction)globalSystemAction).getActionMapKey();
                c.getActionMap().put(key, editorAction);
            }
        }

        private void detachSystemActionPerformer(JTextComponent c) {
            if (c == null) {
                return;
            }
            Action editorAction = this.getEditorAction(c);
            if (editorAction == null) {
                return;
            }
            Action globalSystemAction = this.getSystemAction(c);
            if (globalSystemAction == null) {
                return;
            }
            if (globalSystemAction instanceof CallbackSystemAction) {
                Action ea;
                Object key = ((CallbackSystemAction)globalSystemAction).getActionMapKey();
                ActionMap am = c.getActionMap();
                if (am != null && editorAction.equals(ea = am.get(key))) {
                    am.remove(key);
                }
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("component".equals(propName)) {
                JTextComponent component = (JTextComponent)evt.getNewValue();
                if (component != null) {
                    component.addPropertyChangeListener(this);
                    this.attachSystemActionPerformer(component);
                } else {
                    component = (JTextComponent)evt.getOldValue();
                    component.removePropertyChangeListener(this);
                    this.detachSystemActionPerformer(component);
                }
            }
        }

        private synchronized Action getEditorAction(JTextComponent component) {
            BaseKit kit;
            if (this.editorAction == null && (kit = Utilities.getKit((JTextComponent)component)) != null) {
                this.editorAction = kit.getActionByName(this.editorActionName);
            }
            return this.editorAction;
        }

        private Action getSystemAction(JTextComponent c) {
            String saClassName;
            Action ea;
            if (this.systemAction == null && (ea = this.getEditorAction(c)) != null && (saClassName = (String)ea.getValue("systemActionClassName")) != null) {
                Class<?> saClass;
                try {
                    saClass = Class.forName(saClassName);
                }
                catch (Throwable t) {
                    saClass = null;
                }
                if (saClass != null) {
                    Lookup lookup;
                    this.systemAction = SystemAction.get(saClass);
                    if (this.systemAction instanceof ContextAwareAction && (lookup = NbEditorUI.getContextLookup(c)) != null) {
                        this.systemAction = ((ContextAwareAction)this.systemAction).createContextAwareInstance(lookup);
                    }
                }
            }
            return this.systemAction;
        }
    }

    public final class SystemActionUpdater
    implements PropertyChangeListener,
    ActionPerformer {
        private String editorActionName;
        private boolean updatePerformer;
        private boolean syncEnabling;
        private Action editorAction;
        private Action systemAction;
        private PropertyChangeListener enabledPropertySyncL;
        private boolean listeningOnTCRegistry;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SystemActionUpdater(String editorActionName, boolean updatePerformer, boolean syncEnabling) {
            this.editorActionName = editorActionName;
            this.updatePerformer = updatePerformer;
            this.syncEnabling = syncEnabling;
            Object object = NbEditorUI.this.getComponentLock();
            synchronized (object) {
                JTextComponent component = NbEditorUI.this.getComponent();
                if (component != null) {
                    this.propertyChange(new PropertyChangeEvent((Object)NbEditorUI.this, "component", null, component));
                }
                NbEditorUI.this.addPropertyChangeListener(this);
            }
        }

        public void editorActivated() {
            Action ea = this.getEditorAction();
            Action sa = this.getSystemAction();
            if (ea != null && sa != null) {
                if (this.updatePerformer && ea.isEnabled() && sa instanceof CallbackSystemAction) {
                    ((CallbackSystemAction)sa).setActionPerformer((ActionPerformer)this);
                }
                if (this.syncEnabling) {
                    if (this.enabledPropertySyncL == null) {
                        this.enabledPropertySyncL = new EnabledPropertySyncListener(sa);
                    }
                    ea.addPropertyChangeListener(this.enabledPropertySyncL);
                }
            }
        }

        public void editorDeactivated() {
            Action ea = this.getEditorAction();
            Action sa = this.getSystemAction();
            if (ea != null && sa != null && this.syncEnabling && this.enabledPropertySyncL != null) {
                ea.removePropertyChangeListener(this.enabledPropertySyncL);
            }
        }

        private void reset() {
            if (this.enabledPropertySyncL != null) {
                this.editorAction.removePropertyChangeListener(this.enabledPropertySyncL);
            }
            this.editorAction = null;
            this.systemAction = null;
            this.enabledPropertySyncL = null;
        }

        public void performAction(SystemAction action) {
            JTextComponent component = NbEditorUI.this.getComponent();
            Action ea = this.getEditorAction();
            if (component != null && ea != null) {
                ea.actionPerformed(new ActionEvent(component, 0, ""));
            }
        }

        private void startTCRegistryListening() {
            if (!this.listeningOnTCRegistry) {
                this.listeningOnTCRegistry = true;
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private void stopTCRegistryListening() {
            if (this.listeningOnTCRegistry) {
                this.listeningOnTCRegistry = false;
                TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("activated".equals(propName)) {
                TopComponent activated = (TopComponent)evt.getNewValue();
                if (activated instanceof CloneableEditorSupport.Pane) {
                    this.editorActivated();
                } else {
                    this.editorDeactivated();
                }
            } else if ("component".equals(propName)) {
                JTextComponent component = (JTextComponent)evt.getNewValue();
                if (component != null) {
                    component.addPropertyChangeListener(this);
                    if (component.isDisplayable()) {
                        this.startTCRegistryListening();
                    }
                } else {
                    component = (JTextComponent)evt.getOldValue();
                    component.removePropertyChangeListener(this);
                    this.stopTCRegistryListening();
                }
                this.reset();
            } else if ("editorKit".equals(propName)) {
                this.reset();
            } else if ("ancestor".equals(propName)) {
                if (((Component)evt.getSource()).isDisplayable()) {
                    this.startTCRegistryListening();
                } else {
                    this.stopTCRegistryListening();
                }
            }
        }

        private synchronized Action getEditorAction() {
            BaseKit kit;
            if (this.editorAction == null && (kit = Utilities.getKit((JTextComponent)NbEditorUI.this.getComponent())) != null) {
                this.editorAction = kit.getActionByName(this.editorActionName);
            }
            return this.editorAction;
        }

        private Action getSystemAction() {
            String saClassName;
            Action ea;
            if (this.systemAction == null && (ea = this.getEditorAction()) != null && (saClassName = (String)ea.getValue("systemActionClassName")) != null) {
                Class<?> saClass;
                try {
                    saClass = Class.forName(saClassName);
                }
                catch (Throwable t) {
                    saClass = null;
                }
                if (saClass != null) {
                    this.systemAction = SystemAction.get(saClass);
                }
            }
            return this.systemAction;
        }

        protected void finalize() throws Throwable {
            this.reset();
        }
    }
}

