/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public class NbToolTip
extends FileChangeAdapter {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.tooltip");
    private static final HashMap mime2tip = new HashMap();
    private static int lastRequestId;
    private String mimeType;
    private Annotation[] tipAnnotations;
    private RequestProcessor toolTipRP = new RequestProcessor("ToolTip-Evaluator", 1);

    static synchronized void buildToolTip(JTextComponent target) {
        String mimeType = NbEditorUtilities.getMimeType(target.getDocument());
        NbToolTip tip = NbToolTip.getTip(mimeType);
        tip.buildTip(target);
    }

    private static int newRequestId() {
        return ++lastRequestId;
    }

    private static int getLastRequestId() {
        return lastRequestId;
    }

    private NbToolTip(String mimeType) {
        this.mimeType = mimeType;
    }

    private static NbToolTip getTip(String mimeType) {
        NbToolTip tip = (NbToolTip)((Object)mime2tip.get(mimeType));
        if (tip == null) {
            tip = new NbToolTip(mimeType);
            mime2tip.put(mimeType, tip);
        }
        return tip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Annotation[] getTipAnnotations() {
        Class<NbToolTip> clazz = NbToolTip.class;
        synchronized (NbToolTip.class) {
            Annotation[] annos = this.tipAnnotations;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (annos != null) return annos;
            if (debug) {
                System.err.println("Searching for tooltip annotations for mimeType=" + this.mimeType);
            }
            FileObject annoFolder = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + this.mimeType + "/ToolTips");
            if (debug) {
                System.err.println("tooltip annotation folder=" + annoFolder);
            }
            if (annoFolder == null) return annos;
            ArrayList<Object> al = new ArrayList<Object>();
            Enumeration en = annoFolder.getChildren(false);
            while (en.hasMoreElements()) {
                FileObject fo = (FileObject)en.nextElement();
                if (debug) {
                    System.err.println("tooltip annotation fileobject=" + fo);
                }
                try {
                    DataObject dob = DataObject.find((FileObject)fo);
                    InstanceCookie ic = (InstanceCookie)dob.getCookie(InstanceCookie.class);
                    if (debug) {
                        System.err.println("tooltip annotation instanceCookie=" + ic);
                    }
                    if (ic == null) continue;
                    Object a = ic.instanceCreate();
                    if (debug) {
                        System.err.println("tooltip annotation instance=" + a);
                    }
                    if (!(a instanceof Annotation)) continue;
                    if (debug) {
                        System.err.println("Found tooltip annotation=" + a + ", class " + a.getClass() + " for mimeType=" + this.mimeType);
                    }
                    al.add(a);
                }
                catch (DataObjectNotFoundException e) {
                }
                catch (IOException e) {
                }
                catch (ClassNotFoundException e) {}
            }
            annos = al.toArray(new Annotation[al.size()]);
            Class<NbToolTip> clazz2 = NbToolTip.class;
            synchronized (NbToolTip.class) {
                this.tipAnnotations = annos;
                // ** MonitorExit[var5_6] (shouldn't be in output)
                annoFolder.addFileChangeListener((FileChangeListener)this);
                return annos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTip(JTextComponent target) {
        block13: {
            EditorCookie ec;
            DataObject dob;
            BaseDocument doc;
            ExtEditorUI ui;
            ExtEditorUI editorUI;
            ToolTipSupport tts;
            BaseTextUI btui;
            String toolTipText;
            TextUI textUI = target.getUI();
            if (textUI != null && textUI instanceof BaseTextUI && (toolTipText = (btui = (BaseTextUI)textUI).getToolTipText(target, (tts = (editorUI = (ExtEditorUI)btui.getEditorUI()).getToolTipSupport()).getLastMouseEvent().getPoint())) != null) {
                return;
            }
            Annotation[] annos = this.getTipAnnotations();
            if (annos != null && (ui = ExtUtilities.getExtEditorUI((JTextComponent)target)) != null && (tts = ui.getToolTipSupport()) != null && (doc = Utilities.getDocument((JTextComponent)target)) != null && (dob = NbEditorUtilities.getDataObject((Document)doc)) != null && dob.isValid() && (ec = (EditorCookie)dob.getCookie(EditorCookie.class)) != null) {
                StyledDocument openedDoc;
                try {
                    openedDoc = ec.openDocument();
                }
                catch (IOException e) {
                    openedDoc = null;
                }
                if (openedDoc != doc) {
                    return;
                }
                doc.readLock();
                try {
                    int offset = target.viewToModel(tts.getLastMouseEvent().getPoint());
                    if (offset < 0) break block13;
                    try {
                        Line.Part lp;
                        Line l;
                        int line = Utilities.getLineOffset((BaseDocument)doc, (int)offset);
                        int col = offset - Utilities.getRowStart((JTextComponent)target, (int)offset);
                        Line.Set ls = ec.getLineSet();
                        if (ls != null && (l = ls.getCurrent(line)) != null && (lp = l.createPart(col, 0)) != null) {
                            BaseKit kit;
                            AnnotationDesc annoDesc = doc.getAnnotations().getActiveAnnotation(line);
                            if (annoDesc != null && (offset < annoDesc.getOffset() || offset >= annoDesc.getOffset() + annoDesc.getLength())) {
                                annoDesc = null;
                            }
                            if ((kit = Utilities.getKit((JTextComponent)target)) instanceof NbEditorKit) {
                                int requestId = NbToolTip.newRequestId();
                                this.toolTipRP.post((Runnable)new Request(annoDesc, annos, lp, tts, (AbstractDocument)doc, (NbEditorKit)kit, requestId));
                            }
                        }
                    }
                    catch (BadLocationException e) {
                        // empty catch block
                    }
                }
                finally {
                    doc.readUnlock();
                }
            }
        }
    }

    private static class Request
    implements Runnable,
    PropertyChangeListener,
    DocumentListener {
        private ToolTipSupport tts;
        private Annotation[] annos;
        private AnnotationDesc annoDesc;
        private Line.Part linePart;
        private AbstractDocument doc;
        private NbEditorKit kit;
        private int requestId;
        private boolean documentModified;

        Request(AnnotationDesc annoDesc, Annotation[] annos, Line.Part lp, ToolTipSupport tts, AbstractDocument doc, NbEditorKit kit, int requestId) {
            this.annoDesc = annoDesc;
            this.annos = annos;
            this.linePart = lp;
            this.tts = tts;
            this.doc = doc;
            this.kit = kit;
            this.requestId = requestId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.tts == null) {
                return;
            }
            if (this.tts == null || this.tts.getStatus() == 0) {
                return;
            }
            if (!this.isRequestValid()) {
                return;
            }
            if (this.tts != null) {
                this.tts.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.kit.toolTipAnnotationsLock(this.doc);
            try {
                this.doc.readLock();
                try {
                    int i;
                    if (!this.isRequestValid()) {
                        return;
                    }
                    for (i = 0; i < this.annos.length; ++i) {
                        this.annos[i].attach((Annotatable)this.linePart);
                    }
                    if (this.annoDesc != null && this.tts != null) {
                        this.tts.setToolTipText(this.annoDesc.getShortDescription());
                        this.annoDesc.addPropertyChangeListener((PropertyChangeListener)this);
                    } else {
                        for (i = 0; i < this.annos.length; ++i) {
                            String desc = this.annos[i].getShortDescription();
                            if (desc != null && this.tts != null) {
                                this.tts.setToolTipText(desc);
                            }
                            this.annos[i].addPropertyChangeListener((PropertyChangeListener)this);
                        }
                    }
                }
                finally {
                    this.doc.readUnlock();
                }
            }
            finally {
                this.kit.toolTipAnnotationsUnlock(this.doc);
            }
        }

        private boolean isRequestValid() {
            return NbToolTip.getLastRequestId() == this.requestId && !this.documentModified && this.isDocumentValid();
        }

        private boolean isDocumentValid() {
            EditorCookie ec;
            DataObject dob = NbEditorUtilities.getDataObject(this.doc);
            if (dob != null && (ec = (EditorCookie)dob.getCookie(EditorCookie.class)) != null) {
                StyledDocument openedDoc;
                try {
                    openedDoc = ec.openDocument();
                }
                catch (IOException e) {
                    openedDoc = null;
                }
                return openedDoc == this.doc;
            }
            return false;
        }

        private void dismiss() {
            if (this.tts != null) {
                this.tts.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.tts = null;
            if (this.annoDesc != null) {
                this.annoDesc.removePropertyChangeListener((PropertyChangeListener)this);
            } else {
                for (int i = 0; i < this.annos.length; ++i) {
                    this.annos[i].removePropertyChangeListener((PropertyChangeListener)this);
                    this.annos[i].detach();
                }
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("shortDescription".equals(propName) || "shortDescription".equals(propName)) {
                if (evt.getNewValue() != null) {
                    final String tipText = (String)evt.getNewValue();
                    Utilities.runInEventDispatchThread((Runnable)new Runnable(){

                        public void run() {
                            if (Request.this.tts != null) {
                                Request.this.tts.setToolTipText(tipText);
                            }
                        }
                    });
                }
            } else if ("status".equals(propName) && (Integer)evt.getNewValue() == 0) {
                this.dismiss();
            }
        }

        public void insertUpdate(DocumentEvent evt) {
            this.documentModified = true;
        }

        public void removeUpdate(DocumentEvent evt) {
            this.documentModified = true;
        }

        public void changedUpdate(DocumentEvent evt) {
        }
    }
}

