/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.SideBarFactory;
import org.netbeans.editor.WeakEventListenerList;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.impl.SideBarFactoriesProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizableSideBar {
    private static final Logger LOG = Logger.getLogger(CustomizableSideBar.class.getName());
    private static final Map<JTextComponent, Map<SideBarPosition, Reference<JPanel>>> CACHE = new WeakHashMap<JTextComponent, Map<SideBarPosition, Reference<JPanel>>>(5);
    private static final Map<String, WeakEventListenerList> LISTENERS = new HashMap<String, WeakEventListenerList>(5);
    private static final Map<MimePath, Lookup.Result<SideBarFactoriesProvider>> LR = new WeakHashMap<MimePath, Lookup.Result<SideBarFactoriesProvider>>(5);
    private static final Map<Lookup.Result<SideBarFactoriesProvider>, LookupListener> LL = new WeakHashMap<Lookup.Result<SideBarFactoriesProvider>, LookupListener>(5);

    private CustomizableSideBar() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChangeListener(String mimeType, ChangeListener l) {
        Map<String, WeakEventListenerList> map = LISTENERS;
        synchronized (map) {
            WeakEventListenerList listenerList = LISTENERS.get(mimeType);
            if (listenerList == null) {
                listenerList = new WeakEventListenerList();
                LISTENERS.put(mimeType, listenerList);
            }
            listenerList.add(ChangeListener.class, (EventListener)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChangeListener(String mimeType, ChangeListener l) {
        Map<String, WeakEventListenerList> map = LISTENERS;
        synchronized (map) {
            WeakEventListenerList listenerList = LISTENERS.get(mimeType);
            if (listenerList != null) {
                listenerList.remove(ChangeListener.class, (EventListener)l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChange(String mimeType) {
        ChangeListener[] listeners = null;
        Map<String, WeakEventListenerList> map = LISTENERS;
        synchronized (map) {
            WeakEventListenerList listenerList = LISTENERS.get(mimeType);
            if (listenerList != null) {
                listeners = (ChangeListener[])listenerList.getListeners(ChangeListener.class);
            }
        }
        if (listeners != null && listeners.length > 0) {
            ChangeEvent evt = new ChangeEvent(CustomizableSideBar.class);
            for (ChangeListener l : listeners) {
                l.stateChanged(evt);
            }
        }
    }

    public static Map<SideBarPosition, JComponent> getSideBars(final JTextComponent target) {
        final Object[] map = new Object[1];
        if (SwingUtilities.isEventDispatchThread()) {
            CustomizableSideBar.getSideBarsInternal(target, map);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        CustomizableSideBar.getSideBarsInternal(target, map);
                    }
                });
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, null, e);
                map[0] = Collections.emptyMap();
            }
        }
        Map resultMap = (Map)map[0];
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getSideBarsInternal(JTextComponent target, Object[] resultMap) {
        Map<JTextComponent, Map<SideBarPosition, Reference<JPanel>>> map = CACHE;
        synchronized (map) {
            Map<SideBarPosition, Reference<JPanel>> panelsMap = CACHE.get(target);
            if (panelsMap != null) {
                HashMap<SideBarPosition, JPanel> map2 = new HashMap<SideBarPosition, JPanel>();
                for (SideBarPosition pos : panelsMap.keySet()) {
                    Reference<JPanel> ref = panelsMap.get(pos);
                    if (ref == null) continue;
                    JPanel panel = ref.get();
                    if (panel == null) break;
                    map2.put(pos, panel);
                }
                if (map2.size() == panelsMap.size()) {
                    resultMap[0] = map2;
                    return;
                }
            }
            Map<SideBarPosition, List<JComponent>> sideBarsMap = CustomizableSideBar.createSideBarsMap(target);
            panelsMap = new HashMap<SideBarPosition, Reference<JPanel>>();
            HashMap<SideBarPosition, JPanel> map3 = new HashMap<SideBarPosition, JPanel>();
            for (SideBarPosition pos : sideBarsMap.keySet()) {
                List<JComponent> sideBars = sideBarsMap.get(pos);
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, pos.getAxis()));
                for (JComponent c : sideBars) {
                    panel.add(c);
                }
                panelsMap.put(pos, new WeakReference<JPanel>(panel));
                map3.put(pos, panel);
            }
            CACHE.put(target, panelsMap);
            resultMap[0] = map3;
        }
    }

    private static Map<SideBarPosition, List<JComponent>> createSideBarsMap(JTextComponent target) {
        String mimeType = NbEditorUtilities.getMimeType(target);
        Map<SideBarPosition, List<SideBarFactory>> factoriesMap = CustomizableSideBar.getFactoriesMap(mimeType);
        HashMap<SideBarPosition, List<JComponent>> sideBarsMap = new HashMap<SideBarPosition, List<JComponent>>(factoriesMap.size());
        boolean errorStripeOnly = Boolean.TRUE.equals(target.getClientProperty("errorStripeOnly"));
        for (SideBarPosition pos : factoriesMap.keySet()) {
            List<SideBarFactory> factoriesList = factoriesMap.get(pos);
            ArrayList<JComponent> sideBars = (ArrayList<JComponent>)sideBarsMap.get(pos);
            if (sideBars == null) {
                sideBars = new ArrayList<JComponent>();
                sideBarsMap.put(pos, sideBars);
            }
            for (SideBarFactory f : factoriesList) {
                JComponent sideBar = f.createSideBar(target);
                if (sideBar == null) {
                    LOG.fine("Ignoring null side bar created by the factory: " + f);
                    continue;
                }
                if (errorStripeOnly && !"errorStripe".equals(sideBar.getName())) {
                    LOG.fine("Error stripe sidebar only. Ignoring '" + sideBar.getName() + "' side bar created by the factory: " + f);
                    continue;
                }
                sideBars.add(sideBar);
            }
        }
        return sideBarsMap;
    }

    private static Map<SideBarPosition, List<SideBarFactory>> getFactoriesMap(String mimeType) {
        MimePath mimePath = MimePath.parse((String)mimeType);
        Lookup.Result lR = LR.get(mimePath);
        if (lR == null) {
            lR = MimeLookup.getLookup((MimePath)mimePath).lookupResult(SideBarFactoriesProvider.class);
            LookupListener listener = LL.get(lR);
            if (listener == null) {
                listener = new MyLookupListener(mimeType);
                LL.put((Lookup.Result<SideBarFactoriesProvider>)lR, listener);
            }
            lR.addLookupListener(listener);
            LR.put(mimePath, (Lookup.Result<SideBarFactoriesProvider>)lR);
        }
        Collection providers = lR.allInstances();
        assert (providers.size() == 1) : "There should always be only one SideBarFactoriesProvider";
        SideBarFactoriesProvider provider = (SideBarFactoriesProvider)providers.iterator().next();
        return provider.getFactories();
    }

    private static class MyLookupListener
    implements LookupListener,
    Runnable {
        private String mimeType;

        public MyLookupListener(String mimeType) {
            this.mimeType = mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            Map map = CACHE;
            synchronized (map) {
                ArrayList<JTextComponent> toRemove = new ArrayList<JTextComponent>();
                for (JTextComponent jtc : CACHE.keySet()) {
                    String mimeType = NbEditorUtilities.getMimeType(jtc);
                    if (!mimeType.equals(this.mimeType)) continue;
                    toRemove.add(jtc);
                }
                CACHE.keySet().removeAll(toRemove);
            }
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            CustomizableSideBar.fireChange(this.mimeType);
        }
    }

    public static final class SideBarPosition {
        public static final int WEST = 1;
        public static final int NORTH = 2;
        public static final int SOUTH = 3;
        public static final int EAST = 4;
        public static final String WEST_NAME = "West";
        public static final String NORTH_NAME = "North";
        public static final String SOUTH_NAME = "South";
        public static final String EAST_NAME = "East";
        private int position;
        private boolean scrollable;
        private static String[] borderLayoutConstants = new String[]{"", "West", "North", "South", "East"};
        private static int[] axisConstants = new int[]{-1, 0, 1, 1, 0};

        SideBarPosition(FileObject fo) {
            Object position = fo.getAttribute("position");
            if (position != null && position instanceof String) {
                String positionName = (String)position;
                if (WEST_NAME.equals(positionName)) {
                    this.position = 1;
                } else if (NORTH_NAME.equals(positionName)) {
                    this.position = 2;
                } else if (SOUTH_NAME.equals(positionName)) {
                    this.position = 3;
                } else if (EAST_NAME.equals(positionName)) {
                    this.position = 4;
                } else {
                    if (ErrorManager.getDefault().isLoggable(1)) {
                        ErrorManager.getDefault().log(1, "Unsupported position: " + positionName);
                    }
                    this.position = 1;
                }
            } else {
                this.position = 1;
            }
            Object scrollable = fo.getAttribute("scrollable");
            this.scrollable = scrollable != null && scrollable instanceof Boolean ? (Boolean)scrollable : true;
            if (this.scrollable && (this.position == 3 || this.position == 4) && ErrorManager.getDefault().isLoggable(1)) {
                ErrorManager.getDefault().log(1, "Unsupported combination: scrollable == true, position=" + this.getBorderLayoutPosition());
            }
        }

        public int hashCode() {
            return this.scrollable ? this.position : -this.position;
        }

        public boolean equals(Object o) {
            if (o instanceof SideBarPosition) {
                SideBarPosition p = (SideBarPosition)o;
                if (this.scrollable != p.scrollable) {
                    return false;
                }
                return this.position == p.position;
            }
            return false;
        }

        public int getPosition() {
            return this.position;
        }

        public String getBorderLayoutPosition() {
            return borderLayoutConstants[this.getPosition()];
        }

        private int getAxis() {
            return axisConstants[this.getPosition()];
        }

        public boolean isScrollable() {
            return this.scrollable;
        }

        public String toString() {
            return "[SideBarPosition: scrollable=" + this.scrollable + ", position=" + this.position + "]";
        }
    }
}

