/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.Repository;

public final class KitsTracker {
    private static final Logger LOG = Logger.getLogger(KitsTracker.class.getName());
    private static final Set ALREADY_LOGGED = Collections.synchronizedSet(new HashSet(10));
    private static KitsTracker instance = null;
    private final HashMap mimeType2kitClass = new HashMap();
    private final ArrayList eventSources = new ArrayList();
    private boolean needsReloading = true;
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileFolderCreated(FileEvent fe) {
            KitsTracker.this.invalidateCache();
        }

        public void fileDeleted(FileEvent fe) {
            if (fe.getFile().isFolder()) {
                KitsTracker.this.invalidateCache();
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (fe.getFile().isFolder()) {
                KitsTracker.this.invalidateCache();
            }
        }
    };

    public static synchronized KitsTracker getInstance() {
        if (instance == null) {
            instance = new KitsTracker();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMimeTypesForKitClass(Class kitClass) {
        HashMap hashMap = this.mimeType2kitClass;
        synchronized (hashMap) {
            if (this.needsReloading) {
                this.reload();
            }
            ArrayList<String> list = new ArrayList<String>();
            for (String mimeType : this.mimeType2kitClass.keySet()) {
                Class clazz = (Class)this.mimeType2kitClass.get(mimeType);
                if (kitClass != clazz) continue;
                list.add(mimeType);
            }
            return list;
        }
    }

    public String findMimeType(Class kitClass) {
        List mimeTypes = this.getMimeTypesForKitClass(kitClass);
        if (mimeTypes.size() == 0) {
            if (LOG.isLoggable(Level.WARNING)) {
                KitsTracker.logOnce(Level.WARNING, "No mime type uses editor kit implementation class: " + kitClass);
            }
            return null;
        }
        if (mimeTypes.size() == 1) {
            return (String)mimeTypes.get(0);
        }
        if (LOG.isLoggable(Level.WARNING)) {
            KitsTracker.logOnce(Level.WARNING, "Ambiguous mime types for editor kit implementation class: " + kitClass + "; mime types: " + mimeTypes);
        }
        return null;
    }

    private KitsTracker() {
    }

    private void reload() {
        for (FileObject fo : this.eventSources) {
            fo.removeFileChangeListener(this.fcl);
        }
        this.mimeType2kitClass.clear();
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Editors");
        if (fo != null) {
            FileObject[] types = fo.getChildren();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].isFolder()) continue;
                FileObject[] subTypes = types[i].getChildren();
                for (int j = 0; j < subTypes.length; ++j) {
                    if (!subTypes[j].isFolder()) continue;
                    String mimeType = types[i].getNameExt() + "/" + subTypes[j].getNameExt();
                    MimePath mimePath = MimePath.parse((String)mimeType);
                    EditorKit kit = (EditorKit)MimeLookup.getLookup((MimePath)mimePath).lookup(EditorKit.class);
                    if (kit != null) {
                        String genericMimeType;
                        if (!(kit.getContentType().equals(mimeType) || null != (genericMimeType = KitsTracker.getGenericPartOfCompoundMimeType(mimeType)) && genericMimeType.equals(kit.getContentType()))) {
                            LOG.warning("Inconsistent mime type declaration for the kit: " + kit + "; mimeType from the kit is '" + kit.getContentType() + ", but the kit is registered for '" + mimeType + "'");
                        }
                        this.mimeType2kitClass.put(mimeType, kit.getClass());
                        continue;
                    }
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("No kit for '" + mimeType + "'");
                }
                types[i].addFileChangeListener(this.fcl);
                this.eventSources.add(types[i]);
            }
            fo.addFileChangeListener(this.fcl);
            this.eventSources.add(fo);
        }
        this.needsReloading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCache() {
        HashMap hashMap = this.mimeType2kitClass;
        synchronized (hashMap) {
            this.needsReloading = true;
        }
    }

    private static String getGenericPartOfCompoundMimeType(String mimeType) {
        int plusIdx = mimeType.lastIndexOf(43);
        if (plusIdx != -1 && plusIdx < mimeType.length() - 1) {
            int slashIdx = mimeType.indexOf(47);
            String prefix = mimeType.substring(0, slashIdx + 1);
            String suffix = mimeType.substring(plusIdx + 1);
            if (suffix.equals("xml")) {
                prefix = "text/";
            }
            return prefix + suffix;
        }
        return null;
    }

    private static void logOnce(Level level, String msg) {
        if (!ALREADY_LOGGED.contains(msg)) {
            LOG.log(level, msg);
            ALREADY_LOGGED.add(msg);
        }
    }
}

