/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.impl.ActionsList;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class ToolbarActionsProvider
extends ActionsList
implements Class2LayerFolder,
InstanceProvider {
    private static final Logger LOG = Logger.getLogger(ToolbarActionsProvider.class.getName());
    private static final String TOOLBAR_ACTIONS_FOLDER_NAME = "Toolbars/Default";
    private static final String TEXT_BASE_PATH = "Editors/text/base/";

    public static List getToolbarItems(String mimeType) {
        MimePath mimePath = MimePath.parse((String)mimeType);
        ActionsList provider = mimeType.equals("text/base") ? (ActionsList)MimeLookup.getLookup((MimePath)mimePath).lookup(LegacyToolbarActionsProvider.class) : (ActionsList)MimeLookup.getLookup((MimePath)mimePath).lookup(ToolbarActionsProvider.class);
        return provider == null ? Collections.emptyList() : provider.getAllInstances();
    }

    public ToolbarActionsProvider() {
        super(null);
    }

    private ToolbarActionsProvider(List keys) {
        super(keys, true);
    }

    public Class getClazz() {
        return ToolbarActionsProvider.class;
    }

    public String getLayerFolderName() {
        return TOOLBAR_ACTIONS_FOLDER_NAME;
    }

    public InstanceProvider getInstanceProvider() {
        return new ToolbarActionsProvider();
    }

    public Object createInstance(List fileObjectList) {
        return new ToolbarActionsProvider(fileObjectList);
    }

    public static final class LegacyToolbarActionsProvider
    extends ActionsList
    implements Class2LayerFolder,
    InstanceProvider {
        public LegacyToolbarActionsProvider() {
            super(null);
        }

        private LegacyToolbarActionsProvider(List keys) {
            super(keys);
        }

        public Class getClazz() {
            return LegacyToolbarActionsProvider.class;
        }

        public String getLayerFolderName() {
            return ToolbarActionsProvider.TOOLBAR_ACTIONS_FOLDER_NAME;
        }

        public InstanceProvider getInstanceProvider() {
            return new LegacyToolbarActionsProvider();
        }

        public Object createInstance(List fileObjectList) {
            ArrayList<FileObject> textBaseFilesList = new ArrayList<FileObject>();
            for (Object o : fileObjectList) {
                FileObject fileObject = null;
                if (o instanceof DataObject) {
                    fileObject = ((DataObject)o).getPrimaryFile();
                } else {
                    if (!(o instanceof FileObject)) continue;
                    fileObject = (FileObject)o;
                }
                String fullPath = fileObject.getPath();
                int idx = fullPath.lastIndexOf(ToolbarActionsProvider.TOOLBAR_ACTIONS_FOLDER_NAME);
                assert (idx != -1) : "Expecting files with 'Toolbars/Default' in the path: " + fullPath;
                String path = fullPath.substring(0, idx);
                if (!ToolbarActionsProvider.TEXT_BASE_PATH.equals(path)) continue;
                textBaseFilesList.add(fileObject);
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.warning("The 'text/base' mime type is deprecated, please move your file to the root. Offending file: " + fullPath);
            }
            return new LegacyToolbarActionsProvider(textBaseFilesList);
        }
    }
}

