/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class NavigationHistoryBackAction
extends BaseAction
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(NavigationHistoryBackAction.class.getName());

    public NavigationHistoryBackAction() {
        super("jump-list-prev");
        this.putValue("IconResource", "org/netbeans/modules/editor/resources/navigate_back.png");
        this.update();
        NavigationHistory nav = NavigationHistory.getNavigations();
        nav.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)nav));
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        NavigationHistory.Waypoint wpt;
        NavigationHistory history = NavigationHistory.getNavigations();
        if (null == history.getCurrentWaypoint()) {
            try {
                history.markWaypoint(target, target.getCaret().getDot(), true, false);
            }
            catch (BadLocationException ble) {
                LOG.log(Level.WARNING, "Can't mark current position", ble);
            }
        }
        if ((wpt = history.navigateBack()) != null) {
            NavigationHistoryBackAction.show(wpt);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }

    private void update() {
        List waypoints = NavigationHistory.getNavigations().getPreviousWaypoints();
        if (!waypoints.isEmpty()) {
            NavigationHistory.Waypoint wpt = (NavigationHistory.Waypoint)waypoints.get(waypoints.size() - 1);
            String fileName = NavigationHistoryBackAction.getWaypointName(wpt);
            if (fileName != null) {
                this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryBackAction_Tooltip", (Object)fileName));
            } else {
                this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryBackAction_Tooltip_simple"));
            }
            this.setEnabled(true);
        } else {
            this.putValue("ShortDescription", NbBundle.getMessage(NavigationHistoryBackAction.class, (String)"NavigationHistoryBackAction_Tooltip_simple"));
            this.setEnabled(false);
        }
    }

    static void show(NavigationHistory.Waypoint wpt) {
        URL url = wpt.getUrl();
        final int offset = wpt.getOffset();
        if (url == null || offset < 0) {
            return;
        }
        FileObject f = URLMapper.findFileObject((URL)url);
        if (f != null) {
            DataObject d = null;
            try {
                d = DataObject.find((FileObject)f);
            }
            catch (DataObjectNotFoundException e) {
                LOG.log(Level.WARNING, "Can't get DataObject for " + f, e);
            }
            if (d != null) {
                EditorCookie editorCookie = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
                final LineCookie lineCookie = (LineCookie)d.getLookup().lookup(LineCookie.class);
                StyledDocument doc = null;
                if (editorCookie != null && lineCookie != null) {
                    try {
                        doc = editorCookie.openDocument();
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.WARNING, "Can't open document", ioe);
                    }
                }
                if (doc instanceof BaseDocument) {
                    final BaseDocument baseDoc = (BaseDocument)doc;
                    doc.render(new Runnable(){

                        public void run() {
                            Element lineRoot = baseDoc.getParagraphElement(0).getParentElement();
                            int lineIndex = lineRoot.getElementIndex(offset);
                            if (lineIndex != -1) {
                                Element lineElement = lineRoot.getElement(lineIndex);
                                int column = offset - lineElement.getStartOffset();
                                Line line = lineCookie.getLineSet().getCurrent(lineIndex);
                                if (line != null) {
                                    line.show(4, column);
                                }
                            }
                        }
                    });
                }
            }
        }
    }

    static String getWaypointName(NavigationHistory.Waypoint wpt) {
        URL url = wpt.getUrl();
        if (url != null) {
            String path = url.getPath();
            int idx = path.lastIndexOf(47);
            if (idx != -1) {
                return path.substring(idx + 1);
            }
            return path;
        }
        return null;
    }
}

