/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.highlighting;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlock;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

public final class GuardedBlocksHighlighting
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(GuardedBlocksHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.oldlibbridge.GuardedBlocksHighlighting";
    private final Document document;
    private final MimePath mimePath;
    private long version = 0L;
    private AttributeSet attribs = null;

    public GuardedBlocksHighlighting(Document document, String mimeType) {
        this.document = document;
        this.mimePath = MimePath.parse((String)mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        GuardedBlocksHighlighting guardedBlocksHighlighting = this;
        synchronized (guardedBlocksHighlighting) {
            if (this.document instanceof GuardedDocument) {
                MarkBlockChain guardedBlocks = ((GuardedDocument)this.document).getGuardedBlockChain();
                return new HSImpl(this.version, guardedBlocks, startOffset, endOffset);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    private final class HSImpl
    implements HighlightsSequence {
        private final long version;
        private final MarkBlockChain guardedBlocks;
        private final int startOffset;
        private final int endOffset;
        private boolean init = false;
        private MarkBlock block;

        public HSImpl(long version, MarkBlockChain guardedBlocks, int startOffset, int endOffset) {
            this.version = version;
            this.guardedBlocks = guardedBlocks;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean moveNext() {
            if (!this.init) {
                this.init = true;
                this.block = this.guardedBlocks.getChain();
                while (null != this.block && this.block.getEndOffset() <= this.startOffset) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Skipping block: " + this.block + ", blockStart = " + this.block.getStartOffset() + ", blockEnd = " + this.block.getEndOffset() + ", startOffset = " + this.startOffset + ", endOffset = " + this.endOffset);
                    }
                    this.block = this.block.getNext();
                }
            } else if (this.block != null) {
                this.block = this.block.getNext();
            }
            if (this.block != null && this.block.getStartOffset() > this.endOffset) {
                this.block = null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                if (this.block != null) {
                    LOG.fine("Next block: " + this.block + ", blockStart = " + this.block.getStartOffset() + ", blockEnd = " + this.block.getEndOffset() + ", startOffset = " + this.startOffset + ", endOffset = " + this.endOffset);
                } else {
                    LOG.fine("Next block: null");
                }
            }
            return this.block != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            GuardedBlocksHighlighting guardedBlocksHighlighting = GuardedBlocksHighlighting.this;
            synchronized (guardedBlocksHighlighting) {
                this.checkVersion();
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.block == null) {
                    throw new NoSuchElementException();
                }
                return Math.max(this.block.getStartOffset(), this.startOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            GuardedBlocksHighlighting guardedBlocksHighlighting = GuardedBlocksHighlighting.this;
            synchronized (guardedBlocksHighlighting) {
                this.checkVersion();
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.block == null) {
                    throw new NoSuchElementException();
                }
                return Math.min(this.block.getEndOffset(), this.endOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            GuardedBlocksHighlighting guardedBlocksHighlighting = GuardedBlocksHighlighting.this;
            synchronized (guardedBlocksHighlighting) {
                this.checkVersion();
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.block == null) {
                    throw new NoSuchElementException();
                }
                if (GuardedBlocksHighlighting.this.attribs == null) {
                    FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)GuardedBlocksHighlighting.this.mimePath).lookup(FontColorSettings.class);
                    if (fcs != null) {
                        GuardedBlocksHighlighting.this.attribs = fcs.getFontColors("guarded");
                    }
                    if (GuardedBlocksHighlighting.this.attribs == null) {
                        GuardedBlocksHighlighting.this.attribs = SimpleAttributeSet.EMPTY;
                    } else {
                        GuardedBlocksHighlighting.this.attribs = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{GuardedBlocksHighlighting.this.attribs, AttributesUtilities.createImmutable((Object[])new Object[]{HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE})});
                    }
                }
                return GuardedBlocksHighlighting.this.attribs;
            }
        }

        private void checkVersion() {
            if (this.version != GuardedBlocksHighlighting.this.version) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

