/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.editor.options.AbbrevInputPanel;
import org.netbeans.modules.editor.options.AbbrevsEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AbbrevsEditorPanel
extends JPanel {
    PairStringModel model;
    private AbbrevsEditor editor;
    private FontSizeTable abbrevsTable;
    private JScrollPane abbrevsPane;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;

    public AbbrevsEditorPanel(AbbrevsEditor editor) {
        this.editor = editor;
        this.model = new PairStringModel();
        this.initComponents();
        this.abbrevsTable = new FontSizeTable();
        this.abbrevsTable.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.abbrevsTable.setModel(this.model);
        this.abbrevsTable.setShowHorizontalLines(false);
        this.abbrevsTable.setShowVerticalLines(false);
        this.abbrevsTable.setSelectionMode(0);
        TableColumnModel col = this.abbrevsTable.getColumnModel();
        col.getColumn(0).setMaxWidth(3000);
        col.getColumn(0).setPreferredWidth(30);
        col.getColumn(1).setMaxWidth(7000);
        col.getColumn(1).setPreferredWidth(70);
        this.abbrevsPane.setViewportView(this.abbrevsTable);
        this.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP"));
        this.abbrevsTable.getAccessibleContext().setAccessibleName(this.getBundleString("ACSN_AEP_Table"));
        this.abbrevsTable.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP_Table"));
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP_Add"));
        this.editButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP_Edit"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getBundleString("ACSD_AEP_Remove"));
        this.enableButtons(false);
        this.abbrevsTable.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.getAncestorOfClass(Window.class, AbbrevsEditorPanel.this).setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        this.abbrevsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (AbbrevsEditorPanel.this.abbrevsTable.getRowCount() == 0) {
                    AbbrevsEditorPanel.this.enableButtons(false);
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                AbbrevsEditorPanel.this.enableButtons(!lsm.isSelectionEmpty());
            }
        });
    }

    private void enableButtons(boolean enable) {
        this.editButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
    }

    private String getBundleString(String s) {
        return NbBundle.getMessage(AbbrevsEditorPanel.class, (String)s);
    }

    public void setValue(Map m) {
        if (m != null) {
            this.model.setData(new TreeMap(m));
        } else {
            this.model.setData(new TreeMap());
        }
        if (this.model.getRowCount() > 0) {
            this.abbrevsTable.setRowSelectionInterval(0, 0);
        }
    }

    public Map getValue() {
        return this.model.getData();
    }

    private void notifyEditor() {
        if (this.editor != null) {
            this.editor.customEditorChange();
        }
    }

    private void initComponents() {
        this.abbrevsPane = new JScrollPane();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.abbrevsPane, gridBagConstraints);
        this.addButton.setMnemonic(this.getBundleString("AEP_Add_Mnemonic").charAt(0));
        this.addButton.setText(this.getBundleString("AEP_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbbrevsEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.editButton.setMnemonic(this.getBundleString("AEP_Edit_Mnemonic").charAt(0));
        this.editButton.setText(this.getBundleString("AEP_Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbbrevsEditorPanel.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setMnemonic(this.getBundleString("AEP_Remove_Mnemonic").charAt(0));
        this.removeButton.setText(this.getBundleString("AEP_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AbbrevsEditorPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String[] abbrev = this.getAbbrev(null);
        if (abbrev == null) {
            return;
        }
        int index = this.model.putPair(abbrev);
        this.abbrevsTable.setRowSelectionInterval(index, index);
        this.notifyEditor();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int index = this.abbrevsTable.getSelectedRow();
        if (index != -1) {
            String[] pair = this.model.getPair(index);
            if ((pair = this.getAbbrev(pair)) != null) {
                this.model.removePair(index);
                index = this.model.putPair(pair);
                this.abbrevsTable.setRowSelectionInterval(index, index);
                this.notifyEditor();
            }
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.abbrevsTable.getSelectedRow();
        if (index != -1) {
            this.model.removePair(index);
            if (index >= this.model.getRowCount()) {
                --index;
            }
            if (index >= 0) {
                this.abbrevsTable.setRowSelectionInterval(index, index);
            }
            this.notifyEditor();
        }
    }

    private String[] getAbbrev(String[] abbrev) {
        String[] retVal;
        AbbrevInputPanel input = new AbbrevInputPanel();
        HelpCtx.setHelpIDString((JComponent)input, HelpCtx.findHelp((Component)this) != null ? HelpCtx.findHelp((Component)this).getHelpID() : null);
        if (abbrev != null) {
            input.setAbbrev(abbrev);
        }
        DialogDescriptor dd = new DialogDescriptor((Object)input, this.getBundleString("AEP_EnterAbbrev"));
        Dialog dial = DialogDisplayer.getDefault().createDialog(dd);
        input.requestFocus();
        dial.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION && !"".equals((retVal = input.getAbbrev())[0])) {
            int existingKeyPosition = this.model.containsKey(retVal[0]);
            if (existingKeyPosition >= 0) {
                if (abbrev != null && abbrev[0].equals(retVal[0])) {
                    return retVal;
                }
                String[] existingPair = this.model.getPair(existingKeyPosition);
                NotifyDescriptor.Confirmation NDConfirm = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(AbbrevsEditorPanel.class, (String)"AEP_Overwrite", (Object[])new Object[]{retVal[0], existingPair[1], retVal[1]}), 0, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)NDConfirm);
                if (NDConfirm.getValue() != NotifyDescriptor.YES_OPTION) {
                    return null;
                }
            }
            return retVal;
        }
        return null;
    }

    private final class FontSizeTable
    extends JTable {
        private boolean needCalcRowHeight = true;

        public void updateUI() {
            super.updateUI();
            this.needCalcRowHeight = true;
        }

        public void paint(Graphics g) {
            if (this.needCalcRowHeight) {
                this.calcRowHeight(g);
            }
            super.paint(g);
        }

        private void calcRowHeight(Graphics g) {
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            int rowHeight = fm.getHeight();
            this.needCalcRowHeight = false;
            this.setRowHeight(rowHeight);
        }
    }

    private class PairStringModel
    extends AbstractTableModel {
        String[] columns;
        TreeMap data;
        String[] keys;

        public PairStringModel() {
            this.columns = new String[]{AbbrevsEditorPanel.this.getBundleString("AEP_AbbrevTitle"), AbbrevsEditorPanel.this.getBundleString("AEP_ExpandTitle")};
            this.data = new TreeMap();
            this.keys = new String[0];
        }

        public void setData(TreeMap data) {
            this.data = data;
            this.updateKeys();
        }

        private void updateKeys() {
            this.keys = this.data.keySet().toArray(new String[0]);
            this.fireTableDataChanged();
        }

        public TreeMap getData() {
            return this.data;
        }

        public int getRowCount() {
            return this.keys.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            return this.columns[column];
        }

        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return this.keys[row];
            }
            return this.data.get(this.keys[row]);
        }

        public int putPair(String[] pair) {
            this.data.put(pair[0], pair[1]);
            this.updateKeys();
            return Arrays.binarySearch(this.keys, pair[0]);
        }

        public void removePair(int row) {
            this.data.remove(this.getValueAt(row, 0));
            this.updateKeys();
        }

        public String[] getPair(int row) {
            String key = (String)this.getValueAt(row, 0);
            String[] retVal = new String[]{key, (String)this.data.get(key)};
            return retVal;
        }

        public int containsKey(String key) {
            return Arrays.binarySearch(this.keys, key);
        }
    }
}

