/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.AllOptions;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.MIMEOptionFolder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class AllOptionsFolder {
    public static final String FOLDER = "Editors";
    public static final String OPTION_FILE_NAME = "Settings.settings";
    private static AllOptionsFolder settingsFolder;
    private static boolean baseInitialized;
    private static MIMEOptionFolder mimeFolder;
    private static Map installedOptions;
    private static FileChangeListener moduleRegListener;

    private AllOptionsFolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIMEOptionFolder getMIMEFolder() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (mimeFolder != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mimeFolder;
            }
            FileObject f = Repository.getDefault().getDefaultFileSystem().findResource("Editors/text/base");
            if (f == null) {
                FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER);
                String fName = "text/base";
                if (fo != null) {
                    try {
                        StringTokenizer stok = new StringTokenizer(fName, "/");
                        while (stok.hasMoreElements()) {
                            String newFolder = stok.nextToken();
                            if (fo.getFileObject(newFolder) == null) {
                                fo = fo.createFolder(newFolder);
                                continue;
                            }
                            fo = fo.getFileObject(newFolder);
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                    f = Repository.getDefault().getDefaultFileSystem().findResource("Editors/text/base");
                }
            }
            if (f != null) {
                try {
                    DataObject d = DataObject.find((FileObject)f);
                    DataFolder df = (DataFolder)d.getCookie(DataFolder.class);
                    if (df != null) {
                        mimeFolder = new MIMEOptionFolder(df, this.getBase());
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return mimeFolder;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public List getInstalledOptions() {
        ArrayList retList = new ArrayList();
        String[] MIMES = new String[]{"text", "application"};
        for (int in = 0; in < MIMES.length; ++in) {
            DataFolder mainFolder;
            FileObject mainFolderFO = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + MIMES[in]);
            if (mainFolderFO == null || (mainFolder = DataFolder.findFolder((FileObject)mainFolderFO)) == null) continue;
            DataObject[] subFolders = mainFolder.getChildren();
            for (int i = 0; i < subFolders.length; ++i) {
                if (!(subFolders[i] instanceof DataFolder)) continue;
                DataFolder subFolder = (DataFolder)subFolders[i];
                FileObject optionInstance = Repository.getDefault().getDefaultFileSystem().findResource(subFolder.getPrimaryFile().getPath() + "/" + OPTION_FILE_NAME);
                if (optionInstance == null) continue;
                try {
                    BaseOptions bo;
                    InstanceCookie ic;
                    DataObject optionDO = DataObject.find((FileObject)optionInstance);
                    if (optionDO == null || (ic = (InstanceCookie)optionDO.getCookie(InstanceCookie.class)) == null || (bo = AllOptionsFolder.getDefault().getBO(ic)) == null) continue;
                    retList.add(((Object)((Object)bo)).getClass());
                    continue;
                }
                catch (DataObjectNotFoundException donf) {
                    donf.printStackTrace();
                }
            }
        }
        AllOptions allOptions = (AllOptions)AllOptions.findObject(AllOptions.class, (boolean)true);
        if (allOptions == null) {
            return retList;
        }
        SystemOption[] sos = allOptions.getOptions();
        if (sos == null) {
            return retList;
        }
        for (int i = 0; i < sos.length; ++i) {
            if (!(sos[i] instanceof BaseOptions)) continue;
            BaseOptions bo = (BaseOptions)sos[i];
            if (retList.contains(((Object)((Object)bo)).getClass())) {
                retList.remove(((Object)((Object)bo)).getClass());
            }
            if (BaseKit.getKit((Class)bo.getKitClass()).getContentType() != null) {
                retList.add(((Object)((Object)bo)).getClass());
                this.processInitializers(bo, false);
                continue;
            }
            final String kitClazz = bo.getKitClass().toString();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AllOptionsFolder.class, (String)"ERR_NoContentTypeDefined", (Object)kitClazz), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                }
            });
        }
        return retList;
    }

    public static void unregisterModuleRegListener() {
        FileObject moduleRegistry = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
        if (moduleRegistry != null && moduleRegListener != null) {
            moduleRegistry.removeFileChangeListener(moduleRegListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AllOptionsFolder getDefault() {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (settingsFolder == null) {
                settingsFolder = new AllOptionsFolder();
                if (moduleRegListener == null) {
                    moduleRegListener = new FileChangeAdapter(){

                        public void fileChanged(FileEvent fe) {
                            AllOptionsFolder.updateOptions();
                        }
                    };
                    FileObject moduleRegistry = Repository.getDefault().getDefaultFileSystem().findResource("Modules");
                    if (moduleRegistry != null) {
                        moduleRegistry.addFileChangeListener(moduleRegListener);
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return settingsFolder;
        }
    }

    public List getKeyBindingList() {
        return this.getBase().getKeyBindingList();
    }

    public void setKeyBindingList(List list) {
        this.getBase().setKeyBindingList(list);
    }

    public boolean isToolbarVisible() {
        return this.getBase().isToolbarVisible();
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        this.getBase().setToolbarVisible(toolbarVisible);
    }

    public boolean getLineNumberVisible() {
        return this.getBase().getLineNumberVisible();
    }

    public void setLineNumberVisible(boolean lineVisible) {
        this.getBase().setLineNumberVisible(lineVisible);
    }

    public boolean isTextAntialiasing() {
        return this.getBase().isTextAntialiasing();
    }

    public void setTextAntialiasing(boolean textAntialiasing) {
        this.getBase().setTextAntialiasing(textAntialiasing);
    }

    protected void loadDefaultKeyBindings() {
        this.getBase().getKeyBindingList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class uninstallOption() {
        List updatedInstalledOptions = AllOptionsFolder.getDefault().getInstalledOptions();
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            for (Object obj : installedOptions.keySet()) {
                if (!(obj instanceof Class) || updatedInstalledOptions.contains(obj)) continue;
                installedOptions.remove(obj);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (Class)obj;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    private static void updateOptions() {
        AllOptionsFolder.uninstallOption();
        ArrayList installedOpts = new ArrayList(installedOptions.values());
        for (Object obj : installedOpts) {
            BaseOptions bo;
            if (!(obj instanceof BaseOptions) || (bo = (BaseOptions)((Object)obj)) == null) continue;
            bo.initPopupMenuItems();
        }
    }

    public boolean baseInitialized() {
        return baseInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseOptions getBase() {
        BaseOptions ret = (BaseOptions)BaseOptions.findObject(BaseOptions.class, (boolean)true);
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            if (!baseInitialized) {
                Settings.addInitializer((Settings.Initializer)ret.getSettingsInitializer(), (int)3);
                baseInitialized = true;
                Settings.reset();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseOptions getBO(InstanceCookie ic) {
        this.initInstance(ic);
        BaseOptions ret = null;
        try {
            Class<Settings> clazz = Settings.class;
            synchronized (Settings.class) {
                ret = installedOptions.get(ic.instanceClass()) instanceof BaseOptions ? (BaseOptions)((Object)installedOptions.get(ic.instanceClass())) : null;
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInstance(InstanceCookie ic) {
        try {
            Class<Settings> clazz = Settings.class;
            synchronized (Settings.class) {
                if (installedOptions.containsKey(ic.instanceClass())) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                Object optionObj = ic.instanceCreate();
                if (!(optionObj instanceof BaseOptions)) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                installedOptions.put(ic.instanceClass(), (BaseOptions)((Object)optionObj));
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.processInitializers((BaseOptions)((Object)optionObj), false);
            }
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
    }

    public void loadMIMEOption(Class kitClass) {
        this.loadMIMEOption(kitClass, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadMIMEOption(Class kitClass, boolean processOldTypeOption) {
        String contentType = BaseKit.getKit((Class)kitClass).getContentType();
        if (contentType == null) {
            return;
        }
        FileObject optionFO = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + contentType + "/" + OPTION_FILE_NAME);
        if (optionFO == null) {
            BaseOptions oldBO;
            if (!processOldTypeOption || (oldBO = BaseOptions.getOptions(kitClass)) == null) return;
            boolean process = false;
            Class<Settings> clazz = Settings.class;
            synchronized (Settings.class) {
                if (!installedOptions.containsKey(kitClass)) {
                    installedOptions.put(kitClass, oldBO);
                    process = true;
                }
                // ** MonitorExit[var7_10] (shouldn't be in output)
                if (!process) return;
                this.processInitializers(oldBO, false);
                return;
            }
        }
        try {
            DataObject optionDO = DataObject.find((FileObject)optionFO);
            if (optionDO == null) {
                return;
            }
            InstanceCookie ic = (InstanceCookie)optionDO.getCookie(InstanceCookie.class);
            if (ic == null) {
                return;
            }
            this.initInstance(ic);
            return;
        }
        catch (DataObjectNotFoundException donf) {
            donf.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInitializers(BaseOptions bo, boolean remove) {
        Class<Settings> clazz = Settings.class;
        synchronized (Settings.class) {
            Settings.Initializer si = bo.getSettingsInitializer();
            Settings.removeInitializer((String)si.getName());
            if (!remove) {
                Settings.addInitializer((Settings.Initializer)si, (int)3);
            }
            bo.loadXMLSettings();
            bo.initPopupMenuItems();
            Settings.reset();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static {
        baseInitialized = false;
        installedOptions = new Hashtable();
    }
}

