/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.netbeans.modules.editor.options.AbbrevsEditor;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.ColoringArrayEditor;
import org.netbeans.modules.editor.options.KeyBindingsEditor;
import org.netbeans.modules.editor.options.MacrosEditor;
import org.netbeans.modules.editor.options.ScrollInsetsEditor;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public class BaseOptionsBeanInfo
extends SimpleBeanInfo {
    private String iconPrefix;
    private String bundlePrefix;
    private Image icon;
    private Image icon32;
    private HashMap names2PD;
    PropertyDescriptor[] descriptors;
    private static final String[] EXPERT_PROP_NAMES = new String[]{"caretBlinkRate", "caretTypeInsertMode", "caretTypeOverwriteMode", "caretColorInsertMode", "caretColorOverwriteMode", "highlightCaretRow", "highlightMatchingBracket", "lineHeightCorrection", "margin", "scrollJumpInsets", "scrollFindInsets", "statusBarCaretDelay", "statusBarVisible", "textLimitLineColor", "textLimitLineVisible", "textLimitWidth", "textAntialiasing"};

    public BaseOptionsBeanInfo() {
        this("/org/netbeans/modules/editor/resources/baseOptions");
    }

    public BaseOptionsBeanInfo(String iconPrefix) {
        this(iconPrefix, "");
    }

    public BaseOptionsBeanInfo(String iconPrefix, String bundlePrefix) {
        this.iconPrefix = iconPrefix;
        this.bundlePrefix = bundlePrefix;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            String[] propNames = this.getPropNames();
            PropertyDescriptor[] pds = new PropertyDescriptor[propNames.length];
            for (int i = 0; i < propNames.length; ++i) {
                pds[i] = this.createPropertyDescriptor(propNames[i]);
                pds[i].setDisplayName(this.getString("PROP_" + this.bundlePrefix + propNames[i]));
                pds[i].setShortDescription(this.getString("HINT_" + this.bundlePrefix + propNames[i]));
            }
            this.descriptors = pds;
            this.updatePropertyDescriptors();
        }
        return this.descriptors;
    }

    protected PropertyDescriptor createPropertyDescriptor(String propName) {
        PropertyDescriptor pd;
        block9: {
            try {
                pd = new PropertyDescriptor(propName, this.getBeanClass());
            }
            catch (IntrospectionException e) {
                try {
                    pd = new PropertyDescriptor(propName, null, null);
                }
                catch (IntrospectionException e2) {
                    throw new IllegalStateException("Invalid property name=" + propName);
                }
                String cap = BaseOptionsBeanInfo.capitalize(propName);
                Method m = this.findMethod("get" + cap);
                if (m != null) {
                    try {
                        pd.setReadMethod(m);
                    }
                    catch (IntrospectionException e2) {
                        // empty catch block
                    }
                }
                if ((m = this.findMethod("set" + cap)) == null) break block9;
                try {
                    pd.setWriteMethod(m);
                }
                catch (IntrospectionException e2) {
                    // empty catch block
                }
            }
        }
        return pd;
    }

    private Method findMethod(String name) {
        try {
            Method[] ma = this.getBeanClass().getDeclaredMethods();
            for (int i = 0; i < ma.length; ++i) {
                if (!name.equals(ma[i].getName())) continue;
                return ma[i];
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    protected void updatePropertyDescriptors() {
        String[] stringArray;
        this.setPropertyEditor("abbrevMap", AbbrevsEditor.class, false);
        this.setPropertyEditor("caretTypeInsertMode", CaretTypeEditor.class);
        this.setPropertyEditor("caretTypeOverwriteMode", CaretTypeEditor.class);
        this.setPropertyEditor("keyBindingList", KeyBindingsEditor.class, false);
        this.setPropertyEditor("coloringMap", ColoringArrayEditor.class, false);
        this.setPropertyEditor("scrollJumpInsets", ScrollInsetsEditor.class);
        this.setPropertyEditor("scrollFindInsets", ScrollInsetsEditor.class);
        this.setPropertyEditor("macroMap", MacrosEditor.class, false);
        this.setExpert(EXPERT_PROP_NAMES);
        boolean usesNewOptions = this.usesNewOptions();
        if (usesNewOptions) {
            String[] stringArray2 = new String[11];
            stringArray2[0] = "expandTabs";
            stringArray2[1] = "spacesPerTab";
            stringArray2[2] = "optionsVersion";
            stringArray2[3] = "caretItalicInsertMode";
            stringArray2[4] = "caretItalicOverwriteMode";
            stringArray2[5] = "coloringMap";
            stringArray2[6] = "fontSize";
            stringArray2[7] = "keyBindingList";
            stringArray2[8] = "textLimitLineColor";
            stringArray2[9] = "caretColorInsertMode";
            stringArray = stringArray2;
            stringArray2[10] = "caretColorOverwriteMode";
        } else {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "expandTabs";
            stringArray3[1] = "spacesPerTab";
            stringArray3[2] = "optionsVersion";
            stringArray3[3] = "caretItalicInsertMode";
            stringArray = stringArray3;
            stringArray3[4] = "caretItalicOverwriteMode";
        }
        String[] hidden = stringArray;
        this.setHidden(hidden);
    }

    protected boolean usesNewOptions() {
        boolean usesNewOptions = false;
        BaseOptions base = (BaseOptions)SharedClassObject.findObject((Class)this.getBeanClass());
        if (base != null) {
            usesNewOptions = base.usesNewOptionsDialog();
        }
        return usesNewOptions;
    }

    protected Class getBeanClass() {
        return BaseOptions.class;
    }

    protected String[] getPropNames() {
        return BaseOptions.BASE_PROP_NAMES;
    }

    protected synchronized PropertyDescriptor getPD(String propName) {
        if (this.names2PD == null) {
            this.names2PD = new HashMap(37);
            PropertyDescriptor[] pds = this.getPropertyDescriptors();
            for (int i = pds.length - 1; i >= 0; --i) {
                this.names2PD.put(pds[i].getName(), pds[i]);
            }
        }
        return (PropertyDescriptor)this.names2PD.get(propName);
    }

    protected void setPropertyEditor(String propName, Class propEditor, boolean canEditAsText) {
        PropertyDescriptor pd = this.getPD(propName);
        if (pd != null) {
            pd.setPropertyEditorClass(propEditor);
            pd.setValue("canEditAsText", canEditAsText ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    protected void setPropertyEditor(String propName, Class propEditor) {
        this.setPropertyEditor(propName, propEditor, true);
    }

    protected void setExpert(String[] propNames) {
        for (int i = 0; i < propNames.length; ++i) {
            PropertyDescriptor pd = this.getPD(propNames[i]);
            if (pd == null) continue;
            pd.setExpert(true);
        }
    }

    protected void setHidden(String[] propNames) {
        for (int i = 0; i < propNames.length; ++i) {
            PropertyDescriptor pd = this.getPD(propNames[i]);
            if (pd == null) continue;
            pd.setHidden(true);
        }
    }

    public Image getIcon(int type) {
        if (type == 1 || type == 3) {
            if (this.icon == null) {
                this.icon = this.loadImage(this.iconPrefix + ".gif");
            }
            return this.icon;
        }
        if (this.icon32 == null) {
            this.icon32 = this.loadImage(this.iconPrefix + "32.gif");
        }
        return this.icon32;
    }

    protected String getString(String key) {
        return NbBundle.getMessage(BaseOptionsBeanInfo.class, (String)key);
    }

    public static class CaretTypeEditor
    extends PropertyEditorSupport {
        private static String[] tags = new String[]{"line-caret", "thin-line-caret", "block-caret"};
        private static String[] locTags = new String[]{CaretTypeEditor.getString("LINE_CARET"), CaretTypeEditor.getString("THIN_LINE_CARET"), CaretTypeEditor.getString("BLOCK_CARET")};

        public String[] getTags() {
            return locTags;
        }

        public void setAsText(String txt) {
            for (int i = 0; i < locTags.length; ++i) {
                if (!locTags[i].equals(txt)) continue;
                this.setValue(tags[i]);
                break;
            }
        }

        public String getAsText() {
            String val = (String)this.getValue();
            for (int i = 0; i < tags.length; ++i) {
                if (!tags[i].equals(val)) continue;
                return locTags[i];
            }
            throw new IllegalStateException();
        }

        static String getString(String s) {
            return NbBundle.getMessage(BaseOptionsBeanInfo.class, (String)s);
        }
    }
}

