/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.NbEditorSettingsInitializer;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OptionSupport
extends SystemOption {
    static final long serialVersionUID = 2002899758839584077L;
    static final String OPTIONS_PREFIX = "OPTIONS_";
    private Class kitClass;
    private String typeName;
    private HashMap initializerValuesMap;
    private transient SettingsInitializer settingsInitializer;
    private static final HashMap kitClass2Type = new HashMap();

    public OptionSupport(Class kitClass, String typeName) {
        this.kitClass = kitClass;
        this.typeName = typeName;
        this.initializerValuesMap = new HashMap();
        kitClass2Type.put(kitClass, typeName);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Settings.Initializer si = OptionSupport.this.getSettingsInitializer();
                Settings.removeInitializer((String)si.getName());
                Settings.addInitializer((Settings.Initializer)si, (int)3);
                Settings.reset();
            }
        }, 10);
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static String getTypeName(Class kitClass) {
        return (String)kitClass2Type.get(kitClass);
    }

    public String displayName() {
        return this.getString(OPTIONS_PREFIX + this.typeName);
    }

    Settings.KitAndValue[] getSettingValueHierarchy(String settingName) {
        return Settings.getValueHierarchy((Class)this.kitClass, (String)settingName);
    }

    public Object getSettingValue(String settingName) {
        NbEditorSettingsInitializer.init();
        return Settings.getValue((Class)this.kitClass, (String)settingName);
    }

    protected final boolean getSettingBoolean(String settingName) {
        Boolean val = (Boolean)this.getSettingValue(settingName);
        return val != null ? val : false;
    }

    protected final int getSettingInteger(String settingName) {
        Integer val = (Integer)this.getSettingValue(settingName);
        return val != null ? val : 0;
    }

    public void setSettingValue(String settingName, Object newValue) {
        this.setSettingValue(settingName, newValue, settingName);
    }

    public void setSettingValue(String settingName, Object newValue, String propertyName) {
        this.initializerValuesMap.put(settingName, newValue);
        Object oldValue = this.getSettingValue(settingName);
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        Settings.setValue((Class)this.kitClass, (String)settingName, (Object)newValue);
    }

    public void doSetSettingValue(String settingName, Object newValue, String propertyName) {
        this.initializerValuesMap.put(settingName, newValue);
        Settings.setValue((Class)this.kitClass, (String)settingName, (Object)newValue);
    }

    protected void setSettingBoolean(String settingName, boolean newValue, String propertyName) {
        this.setSettingValue(settingName, newValue ? Boolean.TRUE : Boolean.FALSE, propertyName);
    }

    protected void setSettingInteger(String settingName, int newValue, String propertyName) {
        this.setSettingValue(settingName, new Integer(newValue));
    }

    protected String getString(String s) {
        return NbBundle.getMessage(OptionSupport.class, (String)s);
    }

    public static String[] mergeStringArrays(String[] a1, String[] a2) {
        return NbEditorUtilities.mergeStringArrays(a1, a2);
    }

    protected String getSettingsInitializerName() {
        return this.getTypeName() + "-options-initalizer";
    }

    protected void updateSettingsMap(Class kitClass, Map settingsMap) {
        if (kitClass == this.getKitClass()) {
            settingsMap.putAll(this.initializerValuesMap);
        }
    }

    Settings.Initializer getSettingsInitializer() {
        if (this.settingsInitializer == null) {
            this.settingsInitializer = new SettingsInitializer();
        }
        return this.settingsInitializer;
    }

    class SettingsInitializer
    implements Settings.Initializer {
        String name;
        private volatile boolean updating = false;

        SettingsInitializer() {
        }

        public String getName() {
            if (this.name == null) {
                this.name = OptionSupport.this.getSettingsInitializerName();
            }
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSettingsMap(Class kitClass, Map settingsMap) {
            if (!this.updating) {
                this.updating = true;
                try {
                    OptionSupport.this.updateSettingsMap(kitClass, settingsMap);
                }
                finally {
                    this.updating = false;
                }
            }
        }
    }
}

