/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;

final class RsrcLoader
extends Configuration
implements TemplateLoader {
    private FileObject fo;
    private ScriptContext map;
    private Bindings engineScope;

    RsrcLoader(FileObject fo, ScriptContext map) {
        this.fo = fo;
        this.map = map;
        this.engineScope = map.getBindings(100);
        this.setTemplateLoader(this);
    }

    private FileObject getFile(String name) {
        FileObject fo = this.getFolder() == null ? null : this.getFolder().getFileObject(name);
        return fo;
    }

    private FileObject getFolder() {
        try {
            return this.fo.getFileSystem().getRoot();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return Repository.getDefault().getDefaultFileSystem().getRoot();
        }
    }

    public Object findTemplateSource(String string) throws IOException {
        FileObject fo = this.getFile(string);
        return fo == null ? null : new Wrap(fo);
    }

    public long getLastModified(Object object) {
        return ((Wrap)object).fo.lastModified().getTime();
    }

    public Reader getReader(Object object, String encoding) throws IOException {
        Wrap w = (Wrap)object;
        if (w.reader == null) {
            w.reader = new InputStreamReader(w.fo.getInputStream(), encoding);
        }
        return w.reader;
    }

    public void closeTemplateSource(Object object) throws IOException {
        Wrap w = (Wrap)object;
        if (w.reader != null) {
            w.reader.close();
        }
    }

    public Object put(String string, Object object) {
        assert (false);
        return null;
    }

    public TemplateModel getSharedVariable(String string) {
        Object value = this.map.getAttribute(string);
        if (value == null) {
            value = this.engineScope.get(string);
        }
        if (value == null && this.fo != null) {
            value = this.fo.getAttribute(string);
        }
        try {
            return this.getObjectWrapper().wrap(value);
        }
        catch (TemplateModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Set getSharedVariableNames() {
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
        if (this.map != null) {
            keys.addAll(this.map.getBindings(100).keySet());
        }
        if (this.fo != null) {
            Enumeration en = this.fo.getAttributes();
            while (en.hasMoreElements()) {
                keys.add(en.nextElement());
            }
        }
        return keys;
    }

    private static final class Wrap {
        public FileObject fo;
        public Reader reader;

        public Wrap(FileObject fo) {
            this.fo = fo;
        }
    }
}

