/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChildrenArray
extends NodeAdapter {
    public Children children;
    private Node[] nodes;
    private Map<Children.Info, Collection<Node>> map;
    private Reference<ChildrenArray> ref;
    private static final Logger LOG_NODES_FOR = Logger.getLogger("org.openide.nodes.ChildrenArray.nodesFor");

    public Children getChildren() {
        return this.children;
    }

    protected void finalize() {
        this.children.finalizedChildrenArray(this.ref);
    }

    final void pointedBy(Reference<ChildrenArray> ref) {
        this.ref = ref;
    }

    public Node[] nodes() {
        if (this.children == null) {
            return null;
        }
        if (this.nodes == null) {
            this.nodes = this.children.justComputeNodes();
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].reassignTo(this.children, this);
            }
            this.children.registerChildrenArray(this, this.nodes.length > 0);
        }
        return this.nodes;
    }

    public void clear() {
        if (this.nodes != null) {
            this.nodes = null;
            this.children.registerChildrenArray(this, false);
        }
    }

    public void finalizeNodes() {
        Map<Children.Info, Collection<Node>> m = this.map;
        if (m != null) {
            m.remove(null);
        }
    }

    public boolean isInitialized() {
        return this.nodes != null;
    }

    private String logInfo(Children.Info info) {
        return info.toString() + '[' + Integer.toHexString(System.identityHashCode(info)) + ']';
    }

    public synchronized Collection<Node> nodesFor(Children.Info info) {
        boolean IS_LOG = LOG_NODES_FOR.isLoggable(Level.FINE);
        if (IS_LOG) {
            LOG_NODES_FOR.fine("nodesFor(" + this.logInfo(info) + ") on " + Thread.currentThread());
        }
        if (this.map == null) {
            this.map = new WeakHashMap<Children.Info, Collection<Node>>(7);
        }
        Collection<Node> nodes = this.map.get(info);
        if (IS_LOG) {
            LOG_NODES_FOR.fine("  map size=" + this.map.size() + ", nodes=" + nodes);
        }
        if (nodes == null) {
            nodes = info.entry.nodes();
            info.length = nodes.size();
            this.map.put(info, nodes);
            if (IS_LOG) {
                LOG_NODES_FOR.fine("  created nodes=" + nodes);
            }
        }
        if (IS_LOG) {
            LOG_NODES_FOR.fine("  leaving nodesFor(" + this.logInfo(info) + ") on " + Thread.currentThread());
        }
        return nodes;
    }

    public synchronized void useNodes(Children.Info info, Collection<Node> list) {
        if (this.map == null) {
            this.map = new WeakHashMap<Children.Info, Collection<Node>>(7);
        }
        info.length = list.size();
        this.map.put(info, list);
    }

    public String toString() {
        return super.toString() + "  " + this.getChildren();
    }
}

