/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.util.ArrayList;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineNotificationHandler;
import org.tigris.subversion.svnclientadapter.commandline.SvnCommandLine;

public class SvnCommandLine12
extends SvnCommandLine {
    SvnCommandLine12(String svnPath, CmdLineNotificationHandler notificationHandler) {
        super(svnPath, notificationHandler);
    }

    String info(String[] target) throws CmdLineException {
        if (target.length == 0) {
            return "";
        }
        this.setCommand(19, false);
        ArrayList<String> args = new ArrayList<String>();
        args.add("info");
        this.addConfigInfo(args);
        for (int i = 0; i < target.length; ++i) {
            args.add(target[i]);
        }
        return this.execString(args, false);
    }

    String statusByStdout(String[] path, boolean descend, boolean allEntries, boolean checkUpdates) throws CmdLineException {
        if (path.length == 0) {
            return "";
        }
        this.setCommand(12, false);
        ArrayList<String> args = new ArrayList<String>();
        args.add("status");
        args.add("-v");
        if (!allEntries) {
            args.add("-q");
        }
        if (!descend) {
            args.add("-N");
        }
        if (checkUpdates) {
            args.add("-u");
        }
        if (allEntries) {
            args.add("--no-ignore");
        }
        for (int i = 0; i < path.length; ++i) {
            args.add(path[i]);
        }
        this.addAuthInfo(args);
        this.addConfigInfo(args);
        return this.execString(args, false);
    }

    String annotateByStdout(String path, String revisionStart, String revisionEnd) throws CmdLineException {
        this.setCommand(25, false);
        ArrayList<String> args = new ArrayList<String>();
        args.add("annotate");
        args.add("-r");
        if (revisionStart != null && revisionStart.length() > 0) {
            args.add(SvnCommandLine12.validRev(revisionStart) + ":" + SvnCommandLine12.validRev(revisionEnd));
        } else {
            args.add(SvnCommandLine12.validRev(revisionEnd));
        }
        args.add(path);
        this.addAuthInfo(args);
        this.addConfigInfo(args);
        return this.execString(args, false);
    }
}

