/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javasvn;

import java.io.File;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javasvn.JavaSvnPromptUserPassword;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;

public class JavaSvnClientAdapter
extends AbstractJhlClientAdapter {
    private ISVNClientAdapter svnAdmin;

    public JavaSvnClientAdapter() {
        this.svnClient = SVNClientImpl.newInstance();
        this.notificationHandler = new JhlNotificationHandler();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
    }

    public void createRepository(File path, String repositoryType) throws SVNClientException {
        this.getSvnAdmin();
        if (this.svnAdmin == null) {
            throw new SVNClientException("Create repository method not implemented.");
        }
        this.svnAdmin.createRepository(path, repositoryType);
    }

    private void getSvnAdmin() {
        if (this.svnAdmin == null) {
            try {
                JhlClientAdapterFactory.setup();
            }
            catch (SVNClientException e) {
                // empty catch block
            }
            this.svnAdmin = SVNClientAdapterFactory.createSVNClient("javahl");
            if (this.svnAdmin == null) {
                try {
                    CmdLineClientAdapterFactory.setup();
                }
                catch (SVNClientException sVNClientException) {
                    // empty catch block
                }
                this.svnAdmin = SVNClientAdapterFactory.createSVNClient("commandline");
            }
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
        if (callback != null) {
            JavaSvnPromptUserPassword prompt = new JavaSvnPromptUserPassword(callback);
            this.setPromptUserPassword((PromptUserPassword)prompt);
            if (this.svnAdmin != null) {
                this.svnAdmin.addPasswordCallback(callback);
            }
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    public long[] commitAcrossWC(File[] paths, String message, boolean recurse, boolean keepLocks, boolean atomic) throws SVNClientException {
        try {
            if (message == null) {
                message = "";
            }
            this.notificationHandler.setCommand(3);
            String[] files = new String[paths.length];
            String commandLine = "commit -m \"" + message + "\"";
            if (!recurse) {
                commandLine = commandLine + " -N";
            }
            if (keepLocks) {
                commandLine = commandLine + " --no-unlock";
            }
            for (int i = 0; i < paths.length; ++i) {
                files[i] = JavaSvnClientAdapter.fileToSVNPath(paths[i], false);
                commandLine = commandLine + " " + files[i];
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            long[] newRev = ((SVNClientImpl)this.svnClient).commit(files, message, recurse, keepLocks, atomic);
            return newRev;
        }
        catch (ClientException e) {
            this.notificationHandler.logException((Exception)((Object)e));
            throw new SVNClientException(e);
        }
    }

    public boolean canCommitAcrossWC() {
        return true;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        ISVNStatus[] statuses = super.getStatus(path, descend, getAll, contactServer);
        if (statuses.length == 0) {
            if (getAll) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            ISVNStatus[] reCheckStatuses = super.getStatus(path, false, true, false);
            if (reCheckStatuses.length == 0) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            return new ISVNStatus[0];
        }
        return statuses;
    }
}

