/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HintsControllerImpl {
    private static List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    private HintsControllerImpl() {
    }

    public static Collection<FileObject> coveredFiles() {
        return AnnotationHolder.coveredFiles();
    }

    public static List<ErrorDescription> getErrors(FileObject file) {
        AnnotationHolder holder = AnnotationHolder.getInstance(file);
        if (holder == null) {
            return Collections.emptyList();
        }
        return holder.getErrors();
    }

    public static void setErrors(Document doc, String layer, Collection<? extends ErrorDescription> errors) {
        DataObject od = (DataObject)doc.getProperty("stream");
        if (od == null) {
            return;
        }
        try {
            HintsControllerImpl.setErrorsImpl(od.getPrimaryFile(), layer, errors);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public static void setErrors(FileObject file, String layer, Collection<? extends ErrorDescription> errors) {
        try {
            HintsControllerImpl.setErrorsImpl(file, layer, errors);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private static void setErrorsImpl(FileObject file, String layer, Collection<? extends ErrorDescription> errors) throws IOException {
        AnnotationHolder holder = AnnotationHolder.getInstance(file);
        if (holder != null) {
            holder.setErrorDescriptions(layer, errors);
        }
    }

    private static void computeLineSpan(Document doc, int[] offsets) throws BadLocationException {
        int column;
        String text = doc.getText(offsets[0], offsets[1] - offsets[0]);
        int length = text.length();
        for (column = 0; column < text.length() && Character.isWhitespace(text.charAt(column)); ++column) {
        }
        while (length > 0 && Character.isWhitespace(text.charAt(length - 1))) {
            --length;
        }
        offsets[1] = offsets[0] + length;
        offsets[0] = offsets[0] + column;
        if (offsets[1] < offsets[0]) {
            offsets[0] = offsets[1];
        }
    }

    static int[] computeLineSpan(Document doc, int lineNumber) throws BadLocationException {
        int lineEndOffset;
        int lineStartOffset = NbDocument.findLineOffset((StyledDocument)((StyledDocument)doc), (int)(lineNumber - 1));
        if (doc instanceof BaseDocument) {
            lineEndOffset = Utilities.getRowEnd((BaseDocument)((BaseDocument)doc), (int)lineStartOffset);
        } else {
            String lineText = doc.getText(lineStartOffset, doc.getLength() - lineStartOffset);
            lineText = lineText.indexOf(10) != -1 ? lineText.substring(0, lineText.indexOf(10)) : lineText;
            lineEndOffset = lineStartOffset + lineText.length();
        }
        int[] span = new int[]{lineStartOffset, lineEndOffset};
        HintsControllerImpl.computeLineSpan(doc, span);
        return span;
    }

    public static PositionBounds fullLine(Document doc, int lineNumber) {
        DataObject file = (DataObject)doc.getProperty("stream");
        if (file == null) {
            return null;
        }
        try {
            int[] span = HintsControllerImpl.computeLineSpan(doc, lineNumber);
            return HintsControllerImpl.linePart(file.getPrimaryFile(), span[0], span[1]);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    public static PositionBounds linePart(Document doc, final Position start, final Position end) {
        DataObject od = (DataObject)doc.getProperty("stream");
        if (od == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
        if (ec instanceof CloneableEditorSupport) {
            final CloneableEditorSupport ces = (CloneableEditorSupport)ec;
            final PositionRef[] refs = new PositionRef[2];
            doc.render(new Runnable(){

                public void run() {
                    refs[0] = ces.createPositionRef(start.getOffset(), Position.Bias.Forward);
                    refs[1] = ces.createPositionRef(end.getOffset(), Position.Bias.Backward);
                }
            });
            return new PositionBounds(refs[0], refs[1]);
        }
        if (ec instanceof EditorSupport) {
            final EditorSupport es = (EditorSupport)ec;
            final PositionRef[] refs = new PositionRef[2];
            doc.render(new Runnable(){

                public void run() {
                    refs[0] = es.createPositionRef(start.getOffset(), Position.Bias.Forward);
                    refs[1] = es.createPositionRef(end.getOffset(), Position.Bias.Backward);
                }
            });
            return new PositionBounds(refs[0], refs[1]);
        }
        return null;
    }

    public static PositionBounds linePart(FileObject file, int start, int end) {
        try {
            DataObject od = DataObject.find((FileObject)file);
            if (od == null) {
                return null;
            }
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            if (!(ec instanceof CloneableEditorSupport)) {
                return null;
            }
            CloneableEditorSupport ces = (CloneableEditorSupport)ec;
            return new PositionBounds(ces.createPositionRef(start, Position.Bias.Forward), ces.createPositionRef(end, Position.Bias.Backward));
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    public static boolean isInError(Set<FileObject> fos) {
        for (FileObject f : fos) {
            if (!HintsControllerImpl.isInError(f)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInError(FileObject fo) {
        return false;
    }

    public static synchronized void addChangeListener(ChangeListener l) {
        listeners.add(l);
    }

    public static synchronized void removeChangeListener(ChangeListener l) {
        listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireChanges() {
        Class<HintsControllerImpl> clazz = HintsControllerImpl.class;
        synchronized (HintsControllerImpl.class) {
            ArrayList<ChangeListener> ls = new ArrayList<ChangeListener>(listeners);
            // ** MonitorExit[var1] (shouldn't be in output)
            ChangeEvent e = new ChangeEvent(HintsControllerImpl.class);
            for (ChangeListener l : ls) {
                l.stateChanged(e);
            }
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompoundLazyFixList
    implements LazyFixList,
    PropertyChangeListener {
        private List<LazyFixList> delegates;
        private List<Fix> fixesCache;
        private Boolean computedCache;
        private Boolean probablyContainsFixesCache;
        private PropertyChangeSupport pcs;

        public CompoundLazyFixList(List<LazyFixList> delegates) {
            this.delegates = delegates;
            this.pcs = new PropertyChangeSupport(this);
            for (LazyFixList l : delegates) {
                l.addPropertyChangeListener(this);
            }
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        @Override
        public synchronized boolean probablyContainsFixes() {
            if (this.probablyContainsFixesCache == null) {
                boolean result = false;
                for (LazyFixList l : this.delegates) {
                    result |= l.probablyContainsFixes();
                }
                this.probablyContainsFixesCache = result;
            }
            return this.probablyContainsFixesCache;
        }

        @Override
        public synchronized List<Fix> getFixes() {
            if (this.fixesCache == null) {
                this.fixesCache = new ArrayList<Fix>();
                for (LazyFixList l : this.delegates) {
                    this.fixesCache.addAll(l.getFixes());
                }
            }
            return this.fixesCache;
        }

        @Override
        public synchronized boolean isComputed() {
            if (this.computedCache == null) {
                boolean result = true;
                for (LazyFixList l : this.delegates) {
                    result &= l.isComputed();
                }
                this.computedCache = result;
            }
            return this.computedCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("fixes".equals(evt.getPropertyName())) {
                CompoundLazyFixList compoundLazyFixList = this;
                synchronized (compoundLazyFixList) {
                    this.fixesCache = null;
                }
                this.pcs.firePropertyChange("fixes", null, null);
                return;
            }
            if ("computed".equals(evt.getPropertyName())) {
                CompoundLazyFixList compoundLazyFixList = this;
                synchronized (compoundLazyFixList) {
                    this.computedCache = null;
                }
                this.pcs.firePropertyChange("computed", null, null);
            }
        }
    }
}

