/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.editor.hints.AnnotationHolder;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Annotation;
import org.openide.util.WeakListeners;

public class ParseErrorAnnotation
extends Annotation
implements PropertyChangeListener {
    private final Severity severity;
    private final LazyFixList fixes;
    private final String description;
    private final int lineNumber;
    private final AnnotationHolder holder;

    public ParseErrorAnnotation(Severity severity, LazyFixList fixes, String description, int lineNumber, AnnotationHolder holder) {
        this.severity = severity;
        this.fixes = fixes;
        this.description = description;
        this.lineNumber = lineNumber;
        this.holder = holder;
        if (fixes.probablyContainsFixes() && !fixes.isComputed()) {
            fixes.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)fixes));
        }
    }

    public String getAnnotationType() {
        boolean hasFixes = this.fixes.isComputed() && !this.fixes.getFixes().isEmpty();
        switch (this.severity) {
            case ERROR: {
                if (hasFixes) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_err_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_err";
            }
            case WARNING: {
                if (hasFixes) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_warn_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_warn";
            }
            case VERIFIER: {
                if (hasFixes) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_verifier_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_verifier";
            }
            case HINT: {
                if (hasFixes) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_hint_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_hint";
            }
            case TODO: {
                if (hasFixes) {
                    return "org-netbeans-spi-editor-hints-parser_annotation_todo_fixable";
                }
                return "org-netbeans-spi-editor-hints-parser_annotation_todo";
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)this.severity));
    }

    public String getShortDescription() {
        return this.description;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.fixes.isComputed()) {
            try {
                this.holder.detachAnnotation(this);
                this.holder.attachAnnotation(this.lineNumber, this);
            }
            catch (BadLocationException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public LazyFixList getFixes() {
        return this.fixes;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    Severity getSeverity() {
        return this.severity;
    }
}

