/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.borrowed;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.modules.editor.hints.HintsUI;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.openide.awt.HtmlRenderer;
import org.openide.util.Utilities;

public class ListCompletionView
extends JList
implements ListCellRenderer {
    private final HtmlRenderer.Renderer defaultRenderer = HtmlRenderer.createRenderer();
    private Font font;
    private Icon icon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/editor/hints/resources/suggestion.gif"));

    public ListCompletionView() {
        this.setSelectionMode(0);
        this.font = this.getFont();
        if (this.font.getSize() < 15) {
            this.font = this.font.deriveFont(this.font.getSize2D() + 1.0f);
        }
        this.setFont(this.font);
        this.setCellRenderer(this);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString((String)"ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_CompletionView"));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = this.defaultRenderer.getListCellRendererComponent(list, (Object)(value instanceof Fix ? ((Fix)value).getText() : value.toString()), index, isSelected, cellHasFocus);
        this.defaultRenderer.setIcon(this.icon);
        this.defaultRenderer.setParentFocused(true);
        this.defaultRenderer.setRenderStyle(0);
        c.setBackground(list.getBackground());
        return c;
    }

    public void setResult(LazyFixList data) {
        if (data != null) {
            Model model = new Model(data);
            this.setModel(model);
            if (model.fixes != null && !model.fixes.isEmpty()) {
                this.setSelectedIndex(0);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void up() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(Math.max(this.getSelectedIndex() - 1, 0));
            this.ensureIndexIsVisible(this.getSelectedIndex());
            this.repaint();
        }
    }

    public void down() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            this.setSelectedIndex(Math.min(this.getSelectedIndex() + 1, lastInd));
            this.ensureIndexIsVisible(this.getSelectedIndex());
            this.validate();
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int pageSize = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int ind = Math.max(this.getSelectedIndex() - pageSize, 0);
            this.setSelectedIndex(ind);
            this.ensureIndexIsVisible(ind);
        }
    }

    public void pageDown() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            int pageSize = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int ind = Math.min(this.getSelectedIndex() + pageSize, lastInd);
            this.setSelectedIndex(ind);
            this.ensureIndexIsVisible(ind);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            this.setSelectedIndex(lastInd);
            this.ensureIndexIsVisible(lastInd);
        }
    }

    static class Model
    extends AbstractListModel
    implements PropertyChangeListener {
        private LazyFixList data;
        private List<Fix> fixes;
        private boolean computed;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(LazyFixList data) {
            this.data = data;
            data.addPropertyChangeListener(this);
            this.update();
        }

        private synchronized void update() {
            this.computed = this.data.isComputed();
            if (this.computed) {
                this.fixes = new ArrayList<Fix>(new LinkedHashSet<Fix>(this.data.getFixes()));
            } else {
                this.data.getFixes();
            }
        }

        public synchronized int getSize() {
            return this.computed ? this.fixes.size() : 1;
        }

        public synchronized Object getElementAt(int index) {
            if (!this.computed) {
                return "computing...";
            }
            return this.fixes.get(index);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HintsUI.getDefault().removePopups();
                    HintsUI.getDefault().showPopup();
                }
            });
        }
    }
}

