/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.options;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.editor.hints.options.AdvancedHintsPanel;
import org.netbeans.modules.editor.hints.options.ProvidersListAccessor;
import org.netbeans.spi.editor.hints.ProvidersList;
import org.netbeans.spi.editor.hints.Severity;

public class ModelImpl {
    private AdvancedHintsPanel panel;
    private Map<String, Boolean> key2Enabled;
    private Map<String, Map<String, Severity>> key2Error2Severity;
    private int eagerness;

    public ModelImpl(AdvancedHintsPanel panel) {
        this.panel = panel;
        this.key2Enabled = new HashMap<String, Boolean>();
        this.key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        this.eagerness = -1;
    }

    public synchronized boolean isProviderEnabled(String providerKey) {
        Boolean cache = this.key2Enabled.get(providerKey);
        if (cache == null) {
            return ProvidersList.isProviderEnabled(providerKey);
        }
        return cache;
    }

    public synchronized Severity getErrorSeverity(String providerKey, String errorKey) {
        Map<String, Severity> error2Severity = this.key2Error2Severity.get(providerKey);
        if (error2Severity == null) {
            return ProvidersList.getErrorSeverity(providerKey, errorKey);
        }
        Severity cache = error2Severity.get(errorKey);
        if (cache == null) {
            return ProvidersList.getErrorSeverity(providerKey, errorKey);
        }
        return cache;
    }

    public synchronized void setProviderEnabled(String providerKey, boolean enabled) {
        this.key2Enabled.put(providerKey, enabled);
        this.panel.firePropertyChange("changed", null, null);
    }

    public synchronized void setSeverity(String providerKey, String errorKey, Severity severity) {
        Map<String, Severity> error2Severity = this.key2Error2Severity.get(providerKey);
        if (error2Severity == null) {
            error2Severity = new HashMap<String, Severity>();
            this.key2Error2Severity.put(providerKey, error2Severity);
        }
        error2Severity.put(errorKey, severity);
        this.panel.firePropertyChange("changed", null, null);
    }

    public synchronized List getDescriptions() {
        return ProvidersListAccessor.INSTANCE.getDescriptions();
    }

    public void rollBack() {
        this.key2Enabled = new HashMap<String, Boolean>();
        this.key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        this.eagerness = -1;
    }

    public void commit() {
        String key;
        for (Map.Entry<String, Boolean> entry : this.key2Enabled.entrySet()) {
            key = entry.getKey();
            Boolean value = entry.getValue();
            ProvidersListAccessor.INSTANCE.setProviderEnabled(key, value);
        }
        for (Map.Entry<String, Object> entry : this.key2Error2Severity.entrySet()) {
            key = entry.getKey();
            Map error2Severity = (Map)entry.getValue();
            for (Map.Entry e : error2Severity.entrySet()) {
                String errorKey = (String)e.getKey();
                Severity severity = (Severity)((Object)e.getValue());
                ProvidersListAccessor.INSTANCE.setSeverity(key, errorKey, severity);
            }
        }
        this.key2Enabled = new HashMap<String, Boolean>();
        this.key2Error2Severity = new HashMap<String, Map<String, Severity>>();
        this.eagerness = -1;
    }

    public boolean isModified() {
        return !this.key2Enabled.isEmpty() || !this.key2Error2Severity.isEmpty() || this.eagerness != -1;
    }
}

