/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.hints.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.hints.HintsControllerImpl;
import org.netbeans.modules.editor.hints.options.SeverityComboRenderer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.ErrorManager;
import org.openide.awt.HtmlRenderer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProblemTopComponent
extends TopComponent {
    private static Object PTC_TAG = new Object();
    private static ProblemTopComponent instance;
    private static final String PREFERRED_ID = "ProblemTopComponent";
    private ProblemTableModel model;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private Lookup.Result<DataObject> resultDO = null;
    private Lookup.Result resultTag = null;
    private Lookup.Result<Project> resultProject = null;
    private ProjectListener listener = null;
    private Set<Project> activeProjects = null;
    private ChangeListenerImpl changeListener = null;

    private ProblemTopComponent() {
        super(Lookups.singleton((Object)PTC_TAG));
        this.initComponents();
        this.setName(NbBundle.getMessage(ProblemTopComponent.class, (String)"CTL_ProblemTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ProblemTopComponent.class, (String)"HINT_ProblemTopComponent"));
        this.jTable1.setDefaultRenderer(Integer.class, new SeverityComboRenderer());
        this.jTable1.setDefaultRenderer(ErrorDescription.class, new PositionCellRenderer());
        this.model = new ProblemTableModel();
        this.jTable1.setModel(this.model);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 376, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 276, Short.MAX_VALUE).addContainerGap()));
    }

    public static synchronized ProblemTopComponent getDefault() {
        if (instance == null) {
            instance = new ProblemTopComponent();
        }
        return instance;
    }

    public static synchronized ProblemTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return ProblemTopComponent.getDefault();
        }
        if (win instanceof ProblemTopComponent) {
            return (ProblemTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ProblemTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ProblemTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        this.resultDO = Utilities.actionsGlobalContext().lookupResult(DataObject.class);
        this.resultTag = Utilities.actionsGlobalContext().lookup(new Lookup.Template(null, null, PTC_TAG));
        this.resultProject = Utilities.actionsGlobalContext().lookupResult(Project.class);
        this.listener = new ProjectListener();
        this.resultDO.addLookupListener((LookupListener)this.listener);
        this.resultTag.addLookupListener((LookupListener)this.listener);
        this.changeListener = new ChangeListenerImpl();
        HintsControllerImpl.addChangeListener(this.changeListener);
        this.listener.resultChanged(null);
    }

    public void componentClosed() {
        HintsControllerImpl.removeChangeListener(this.changeListener);
        this.changeListener = null;
        this.resultDO.removeLookupListener((LookupListener)this.listener);
        this.resultTag.removeLookupListener((LookupListener)this.listener);
        this.resultProject.removeLookupListener((LookupListener)this.listener);
        this.listener = null;
        this.resultDO = null;
        this.resultTag = null;
        this.resultProject = null;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private synchronized void updateErrors() {
        if (this.activeProjects == null) {
            return;
        }
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        for (FileObject f : HintsControllerImpl.coveredFiles()) {
            if (!this.activeProjects.contains(FileOwnerQuery.getOwner((FileObject)f))) continue;
            errors.addAll(HintsControllerImpl.getErrors(f));
        }
        this.model.errors = errors;
        this.model.fireTableDataChanged();
    }

    private synchronized void setActiveProjects(Set<Project> activeProjects) {
        this.activeProjects = activeProjects;
        this.updateErrors();
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        public void stateChanged(ChangeEvent evt) {
            ProblemTopComponent.this.updateErrors();
        }
    }

    private static final class PositionCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegateTo = HtmlRenderer.createRenderer();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ErrorDescription desc = (ErrorDescription)value;
            try {
                String position = desc.getFile().getNameExt() + ":" + desc.getRange().getBegin().getLine();
                return this.delegateTo.getTableCellRendererComponent(table, position, isSelected, hasFocus, row, column);
            }
            catch (IOException e) {
                return this.delegateTo.getTableCellRendererComponent(table, e.getLocalizedMessage(), isSelected, hasFocus, row, column);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProblemTableModel
    extends AbstractTableModel {
        private List<ErrorDescription> errors = Collections.emptyList();

        private ProblemTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.errors.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Description";
                }
                case 1: {
                    return "Severity";
                }
                case 2: {
                    return "Position";
                }
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return ErrorDescription.class;
                }
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= this.errors.size()) {
                throw new IllegalArgumentException("Invalid row: " + row + ", max=" + this.errors.size());
            }
            ErrorDescription desc = this.errors.get(row);
            assert (desc != null);
            switch (column) {
                case 0: {
                    return desc.getDescription();
                }
                case 1: {
                    return desc.getSeverity();
                }
                case 2: {
                    return desc;
                }
            }
            throw new IllegalArgumentException("Invalid column: " + column);
        }
    }

    private class ProjectListener
    implements LookupListener {
        private ProjectListener() {
        }

        public void resultChanged(LookupEvent evt) {
            assert (ProblemTopComponent.this.resultDO != null && ProblemTopComponent.this.resultTag != null && ProblemTopComponent.this.resultProject != null);
            if (!ProblemTopComponent.this.resultTag.allInstances().isEmpty()) {
                return;
            }
            HashSet<Project> projects = new HashSet<Project>();
            for (DataObject file : ProblemTopComponent.this.resultDO.allInstances()) {
                projects.add(FileOwnerQuery.getOwner((FileObject)file.getPrimaryFile()));
            }
            projects.addAll(ProblemTopComponent.this.resultProject.allInstances());
            ProblemTopComponent.this.setActiveProjects(projects);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ProblemTopComponent.getDefault();
        }
    }
}

