/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.editor.hints.options.ProvidersListAccessor;
import org.netbeans.spi.editor.hints.ProviderDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProvidersList {
    private static final String PROVIDERS_LIST_FOLDER = "EditorHints/";
    private static final String CONFIG_FILE_NAME = "editorhintsconfig.xml";
    private static List<ProviderDescription> descriptions;
    private static Map<String, Boolean> key2Enabled;
    private static Map<String, ProviderDescription> key2Description;
    private static Map<String, Map<String, Severity>> key2Error2Severity;
    private static boolean initialized;

    private ProvidersList() {
    }

    static synchronized Collection<String> getInstalledProvidersList() {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        return key2Description.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        key2Description = new HashMap<String, ProviderDescription>();
        descriptions = new ArrayList<ProviderDescription>();
        FileObject listFolder = Repository.getDefault().getDefaultFileSystem().findResource(PROVIDERS_LIST_FOLDER);
        FolderLookup flookup = new FolderLookup(DataFolder.findContainer((FileObject)listFolder));
        Collection looked = flookup.getLookup().lookupAll(ProviderDescription.class);
        for (ProviderDescription desc : looked) {
            key2Description.put(desc.getKey(), desc);
            descriptions.add(desc);
        }
        FileObject configFile = Repository.getDefault().getDefaultFileSystem().findResource(CONFIG_FILE_NAME);
        if (configFile != null) {
            InputStream ins = null;
            try {
                ins = configFile.getInputStream();
                XMLDecoder decoder = new XMLDecoder(ins);
                key2Error2Severity = (Map)decoder.readObject();
                key2Enabled = (Map)decoder.readObject();
                decoder.close();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        } else {
            key2Error2Severity = new HashMap<String, Map<String, Severity>>();
            key2Enabled = new HashMap<String, Boolean>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save() {
        FileLock lock = null;
        OutputStream out = null;
        try {
            FileObject configFile = Repository.getDefault().getDefaultFileSystem().findResource(CONFIG_FILE_NAME);
            if (configFile == null) {
                FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
                configFile = FileUtil.createData((FileObject)root, (String)CONFIG_FILE_NAME);
            }
            lock = configFile.lock();
            out = configFile.getOutputStream(lock);
            XMLEncoder encoder = new XMLEncoder(out);
            encoder.writeObject(key2Error2Severity);
            encoder.writeObject(key2Enabled);
            encoder.close();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    public static boolean isProviderEnabled(String providerKey) {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!key2Description.containsKey(providerKey)) {
            throw new IllegalArgumentException("Unknown provider key: " + providerKey);
        }
        Boolean enabled = key2Enabled.get(providerKey);
        if (enabled == null) {
            ProviderDescription desc = ProvidersList.getProviderDescription(providerKey);
            return desc.getDefaultState();
        }
        return enabled;
    }

    public static synchronized Severity getErrorSeverity(String providerKey, String errorKey) {
        Severity severity;
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!key2Description.containsKey(providerKey)) {
            throw new IllegalArgumentException("Unknown provider key: " + providerKey);
        }
        Map<String, Severity> error2Severity = key2Error2Severity.get(providerKey);
        if (error2Severity == null) {
            error2Severity = new HashMap<String, Severity>();
            key2Error2Severity.put(providerKey, error2Severity);
        }
        if ((severity = error2Severity.get(errorKey)) == null) {
            ProviderDescription desc = ProvidersList.getProviderDescription(providerKey);
            if (desc.getSupportedErrorKeys().contains(errorKey)) {
                return desc.getErrorDefaultSeverity(errorKey);
            }
            throw new IllegalArgumentException("Unknown error key: " + errorKey + " for provider: " + providerKey);
        }
        return severity;
    }

    static synchronized void setProviderEnabled(String providerKey, boolean enabled) {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!key2Description.containsKey(providerKey)) {
            throw new IllegalArgumentException("Unknown provider key: " + providerKey);
        }
        key2Enabled.put(providerKey, enabled);
        ProvidersList.save();
    }

    static synchronized void setSeverity(String providerKey, String errorKey, Severity severity) {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!ProvidersList.getProviderDescription(providerKey).getSupportedErrorKeys().contains(errorKey)) {
            throw new IllegalArgumentException("Unknown error key: " + errorKey + " for provider: " + providerKey);
        }
        Map<String, Severity> error2Severity = key2Error2Severity.get(providerKey);
        if (error2Severity == null) {
            error2Severity = new HashMap<String, Severity>();
            key2Error2Severity.put(providerKey, error2Severity);
        }
        error2Severity.put(errorKey, severity);
        ProvidersList.save();
    }

    static synchronized ProviderDescription getProviderDescription(String providerKey) {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        if (!key2Description.containsKey(providerKey)) {
            throw new IllegalArgumentException("Unknown provider key: " + providerKey);
        }
        return key2Description.get(providerKey);
    }

    static synchronized List<ProviderDescription> getDescriptions() {
        if (!initialized) {
            ProvidersList.init();
            initialized = true;
        }
        return descriptions;
    }

    static {
        ProvidersListAccessor.INSTANCE = new ProvidersListAccessor(){

            @Override
            public Collection<String> getInstalledProvidersList() {
                return ProvidersList.getInstalledProvidersList();
            }

            @Override
            public void setProviderEnabled(String providerKey, boolean enabled) {
                ProvidersList.setProviderEnabled(providerKey, enabled);
            }

            @Override
            public void setSeverity(String providerKey, String errorKey, Severity severity) {
                ProvidersList.setSeverity(providerKey, errorKey, severity);
            }

            @Override
            public ProviderDescription getProviderDescription(String providerKey) {
                return ProvidersList.getProviderDescription(providerKey);
            }

            @Override
            public List<ProviderDescription> getDescriptions() {
                return ProvidersList.getDescriptions();
            }
        };
        descriptions = null;
        key2Enabled = null;
        key2Description = null;
        key2Error2Severity = null;
        initialized = false;
    }
}

