/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.javadoc.Doc;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.navigation.CaretListeningFactory;
import org.netbeans.modules.java.navigation.DeclarationTopComponent;
import org.netbeans.modules.java.navigation.JavadocTopComponent;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaretListeningTask
implements CancellableTask<CompilationInfo> {
    private CaretListeningFactory caretListeningFactory;
    private FileObject fileObject;
    private boolean canceled;
    private ElementHandle<Element> lastEh;

    CaretListeningTask(CaretListeningFactory whichElementJavaSourceTaskFactory, FileObject fileObject) {
        this.caretListeningFactory = whichElementJavaSourceTaskFactory;
        this.fileObject = fileObject;
    }

    public void run(CompilationInfo compilationInfo) {
        this.resume();
        boolean navigatorShouldUpdate = false;
        boolean javadocShouldUpdate = JavadocTopComponent.shouldUpdate();
        boolean declarationShouldUpdate = DeclarationTopComponent.shouldUpdate();
        if (this.isCancelled() || !navigatorShouldUpdate && !javadocShouldUpdate && !declarationShouldUpdate) {
            return;
        }
        TreePath tp = compilationInfo.getTreeUtilities().pathFor(CaretListeningFactory.getLastPosition((FileObject)this.fileObject));
        if (this.isCancelled()) {
            return;
        }
        Element element = compilationInfo.getTrees().getElement(tp);
        if (this.isCancelled() || element == null) {
            return;
        }
        if (navigatorShouldUpdate) {
            this.updateNavigatorSelection();
        }
        if (this.isCancelled()) {
            return;
        }
        if (this.lastEh != null && this.lastEh.signatureEquals(element)) {
            return;
        }
        switch (element.getKind()) {
            case PACKAGE: 
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case METHOD: 
            case CONSTRUCTOR: 
            case INSTANCE_INIT: 
            case STATIC_INIT: 
            case FIELD: 
            case ENUM_CONSTANT: {
                this.lastEh = ElementHandle.create((Element)element);
                this.setDeclaration("");
                this.setJavadoc("", "");
                break;
            }
            default: {
                this.setDeclaration("");
                this.setJavadoc("", "");
            }
        }
        if (javadocShouldUpdate) {
            this.computeAndSetJavadoc(compilationInfo, element);
        }
        if (this.isCancelled()) {
            return;
        }
        if (declarationShouldUpdate) {
            this.computeAndSetDeclaration(compilationInfo, element);
        }
    }

    private void setDeclaration(final String declaration) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DeclarationTopComponent declarationTopComponent = DeclarationTopComponent.findInstance();
                if (declarationTopComponent != null && declarationTopComponent.isOpened()) {
                    declarationTopComponent.setDeclaration(declaration);
                }
            }
        });
    }

    private void setJavadoc(final String header, final String javadoc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JavadocTopComponent javadocTopComponent = JavadocTopComponent.findInstance();
                if (javadocTopComponent != null && javadocTopComponent.isOpened()) {
                    javadocTopComponent.setJavadoc(header, javadoc);
                }
            }
        });
    }

    public final synchronized void cancel() {
        this.canceled = true;
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    private void computeAndSetJavadoc(CompilationInfo compilationInfo, Element element) {
        String javadoc;
        if (element.getKind() == ElementKind.PACKAGE) {
            javadoc = "";
        } else {
            Doc doc = compilationInfo.getElementUtilities().javaDocFor(element);
            String string = javadoc = doc == null ? "" : doc.getRawCommentText();
        }
        if (this.isCancelled()) {
            return;
        }
        this.setJavadoc(element.toString(), javadoc);
    }

    private void computeAndSetDeclaration(CompilationInfo compilationInfo, Element element) {
        if (element.getKind() == ElementKind.PACKAGE) {
            this.setDeclaration("package " + element.toString() + ";");
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (this.isCancelled()) {
            return;
        }
        if (tree != null) {
            ExecutableElement executableElement;
            AnnotationValue annotationValue;
            String declaration = tree.toString();
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                String constructorName = element.getEnclosingElement().getSimpleName().toString();
                declaration = declaration.replaceAll(Pattern.quote("<init>"), Matcher.quoteReplacement(constructorName));
            } else if (element.getKind() == ElementKind.METHOD && declaration != null && (annotationValue = (executableElement = (ExecutableElement)element).getDefaultValue()) != null) {
                int lastSemicolon = declaration.lastIndexOf(";");
                declaration = lastSemicolon == -1 ? declaration + " default " + String.valueOf(annotationValue) + ";" : declaration.substring(0, lastSemicolon) + " default " + String.valueOf(annotationValue) + declaration.substring(lastSemicolon);
            }
            this.setDeclaration(declaration);
            return;
        }
        tree = SourceUtils.treeFor((CompilationInfo)compilationInfo, (Element)element);
        if (this.isCancelled() || tree == null) {
            return;
        }
        String declaration = tree.toString();
        if (element.getKind() == ElementKind.CONSTRUCTOR) {
            String constructorName = element.getEnclosingElement().getSimpleName().toString();
            declaration = declaration.replaceAll(Pattern.quote("<init>"), Matcher.quoteReplacement(constructorName));
        }
        this.setDeclaration(declaration);
    }

    private void updateNavigatorSelection() {
    }
}

