/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.ElementScanningTask;
import org.netbeans.modules.java.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.java.navigation.actions.SortActionSupport;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.netbeans.modules.java.navigation.base.TapPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ClassMemberPanelUI
extends JPanel
implements ExplorerManager.Provider,
FiltersManager.FilterChangeListener {
    private ExplorerManager manager = new ExplorerManager();
    private MyBeanTreeView elementView;
    private TapPanel filtersPanel;
    private JLabel filtersLbl;
    private Lookup lookup = null;
    private ClassMemberFilters filters;
    private Action[] actions;
    private static final Rectangle ZERO = new Rectangle(0, 0, 1, 1);

    public ClassMemberPanelUI() {
        this.initComponents();
        this.elementView = this.createBeanTreeView();
        this.add((Component)((Object)this.elementView), "Center");
        this.filtersPanel = new TapPanel();
        this.filtersLbl = new JLabel(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"LBL_Filter"));
        this.filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
        this.filtersPanel.add(this.filtersLbl);
        this.filtersPanel.setOrientation(2);
        KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        String keyText = Utilities.keyToString((KeyStroke)toggleKey);
        this.filtersPanel.setToolTipText(NbBundle.getMessage(ClassMemberPanelUI.class, (String)"TIP_TapPanel", (Object)keyText));
        this.filters = new ClassMemberFilters(this);
        this.filters.getInstance().hookChangeListener(this);
        this.filtersPanel.add(this.filters.getComponent());
        this.actions = new Action[]{new SortActionSupport.SortByNameAction(this.filters), new SortActionSupport.SortBySourceAction(this.filters), null, new FilterSubmenuAction(this.filters.getInstance())};
        this.add((Component)this.filtersPanel, "South");
        this.manager.setRootContext(ElementNode.getWaitNode());
    }

    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.elementView.requestFocusInWindow();
        return result;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public ElementScanningTask getTask() {
        return new ElementScanningTask(this);
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ClassMemberPanelUI.this.elementView.setRootVisible(true);
                ClassMemberPanelUI.this.manager.setRootContext(ElementNode.getWaitNode());
            }
        });
    }

    public void refresh(final ElementNode.Description description) {
        final ElementNode rootNode = this.getRootNode();
        if (rootNode != null && rootNode.getDescritption().fileObject.equals(description.fileObject)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    rootNode.updateRecursively(description);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassMemberPanelUI.this.elementView.setRootVisible(false);
                    ClassMemberPanelUI.this.manager.setRootContext((Node)new ElementNode(description));
                    boolean scrollOnExpand = ClassMemberPanelUI.this.elementView.getScrollOnExpand();
                    ClassMemberPanelUI.this.elementView.setScrollOnExpand(false);
                    ClassMemberPanelUI.this.elementView.expandAll();
                    ClassMemberPanelUI.this.elementView.setScrollOnExpand(scrollOnExpand);
                }
            });
        }
    }

    public void sort() {
        this.getRootNode().refreshRecursively();
    }

    public ClassMemberFilters getFilters() {
        return this.filters;
    }

    public void expandNode(Node n) {
        this.elementView.expandNode(n);
    }

    public Action[] getActions() {
        return this.actions;
    }

    public FileObject getFileObject() {
        return this.getRootNode().getDescritption().fileObject;
    }

    public void filterStateChanged(ChangeEvent e) {
        ElementNode root = this.getRootNode();
        if (root != null) {
            root.refreshRecursively();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private ElementNode getRootNode() {
        Node n = this.manager.getRootContext();
        if (n instanceof ElementNode) {
            return (ElementNode)n;
        }
        return null;
    }

    private MyBeanTreeView createBeanTreeView() {
        MyBeanTreeView btv = new MyBeanTreeView();
        return btv;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private static class MyBeanTreeView
    extends BeanTreeView {
        private MyBeanTreeView() {
        }

        public boolean getScrollOnExpand() {
            return this.tree.getScrollsOnExpand();
        }

        public void setScrollOnExpand(boolean scroll) {
            this.tree.setScrollsOnExpand(scroll);
        }
    }
}

