/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.lang.model.element.Element;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaHierarchyModel;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyIcons;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.JavaTreeCellRenderer;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JavaHierarchyPanel
extends JPanel {
    private FileObject fileObject;
    private JavaHierarchyModel javaHierarchyModel;
    private HyperlinkListener hyperlinkListener;
    private boolean showingSubDialog = false;
    public JCheckBox caseSensitiveFilterCheckBox;
    public JButton closeButton;
    public JButton expandAllButton;
    public JLabel filterLabel;
    public JTextField filterTextField;
    public JLabel filtersLabel;
    public JEditorPane javaDocPane;
    public JScrollPane javaDocScrollPane;
    public ButtonGroup javaHierarchyModeButtonGroup;
    public JTree javaHierarchyTree;
    public JScrollPane javaHierarchyTreeScrollPane;
    public JToggleButton showFQNToggleButton;
    public JToggleButton showInnerToggleButton;
    public JToggleButton showSubTypeHierarchyToggleButton;
    public JToggleButton showSuperTypeHierarchyToggleButton;
    public JEditorPane signatureEditorPane;
    public JSplitPane splitPane;

    public JavaHierarchyPanel(FileObject fileObject, Element[] elements, CompilationInfo compilationInfo) {
        this.fileObject = fileObject;
        this.initComponents();
        ToolTipManager.sharedInstance().registerComponent(this.javaHierarchyTree);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.caseSensitiveFilterCheckBox.setSelected(JavaMembersAndHierarchyOptions.isCaseSensitive());
        this.showSuperTypeHierarchyToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy());
        this.showSubTypeHierarchyToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy());
        this.showFQNToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowFQN());
        this.showInnerToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowInner());
        this.javaHierarchyTree.getSelectionModel().setSelectionMode(1);
        this.javaHierarchyTree.setRootVisible(false);
        this.javaHierarchyTree.setShowsRootHandles(true);
        this.javaHierarchyTree.setCellRenderer(new JavaTreeCellRenderer());
        this.javaHierarchyModel = new JavaHierarchyModel(fileObject, elements, compilationInfo);
        this.javaHierarchyTree.setModel(this.javaHierarchyModel);
        this.javaDocPane.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.javaDocPane.setContentType("text/html");
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }

            public void insertUpdate(DocumentEvent e) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }

            public void removeUpdate(DocumentEvent e) {
                JavaHierarchyPanel.this.selectMatchingRow();
            }
        });
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, true), 0);
        this.signatureEditorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaHierarchyPanel.this.javaHierarchyTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.caseSensitiveFilterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JavaHierarchyPanel.this.filterTextField.getText().trim().length() > 0) {
                    JavaHierarchyPanel.this.selectMatchingRow();
                }
            }
        });
        this.javaHierarchyTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                Object node;
                Point point = me.getPoint();
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getPathForLocation(point.x, point.y);
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    if (me.getClickCount() == 1) {
                        if (me.isControlDown()) {
                            JavaElement javaToolsJavaElement = (JavaElement)node;
                            JavaHierarchyPanel.this.applyFilter();
                        }
                    } else if (me.getClickCount() == 2) {
                        JavaHierarchyPanel.this.gotoElement((JavaElement)node);
                    }
                }
            }
        });
        this.javaHierarchyTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                JavaHierarchyPanel.this.showSignature();
                JavaHierarchyPanel.this.showJavaDoc();
            }
        });
        this.javaHierarchyTree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.javaHierarchyTree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getLeadSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaHierarchyPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                URL url;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = e.getURL()) != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            }
        };
        this.javaDocPane.addHyperlinkListener(this.hyperlinkListener);
        this.showSuperTypeHierarchyToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JavaMembersAndHierarchyOptions.isShowSuperTypeHierarchy()) {
                    JavaHierarchyPanel.this.applyFilter();
                }
            }
        });
        this.showSubTypeHierarchyToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy()) {
                    JavaHierarchyPanel.this.applyFilter();
                }
            }
        });
        this.showFQNToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.applyFilter();
            }
        });
        this.showInnerToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.applyFilter();
            }
        });
        this.expandAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.expandAll();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaHierarchyPanel.this.close();
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.applyFilter();
    }

    public void removeNotify() {
        JavaMembersAndHierarchyOptions.setShowSuperTypeHierarchy(true);
        this.javaDocPane.removeHyperlinkListener(this.hyperlinkListener);
        this.javaDocScrollPane.setViewportView(null);
        super.removeNotify();
    }

    private void applyFilter() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JRootPane rootPane = SwingUtilities.getRootPane(JavaHierarchyPanel.this);
                if (rootPane != null) {
                    rootPane.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JavaMembersAndHierarchyOptions.setCaseSensitive(JavaHierarchyPanel.this.caseSensitiveFilterCheckBox.isSelected());
                    JavaMembersAndHierarchyOptions.setShowSuperTypeHierarchy(JavaHierarchyPanel.this.showSuperTypeHierarchyToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowSubTypeHierarchy(JavaHierarchyPanel.this.showSubTypeHierarchyToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowFQN(JavaHierarchyPanel.this.showFQNToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowInner(JavaHierarchyPanel.this.showInnerToggleButton.isSelected());
                    JavaHierarchyPanel.this.javaHierarchyModel.update();
                    for (int row = 0; row < JavaHierarchyPanel.this.javaHierarchyTree.getRowCount(); ++row) {
                        TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getPathForRow(row);
                        if (JavaMembersAndHierarchyOptions.isShowSubTypeHierarchy()) {
                            if (treePath.getPathCount() >= JavaMembersAndHierarchyOptions.getSubTypeHierarchyDepth()) continue;
                            JavaHierarchyPanel.this.javaHierarchyTree.expandRow(row);
                            continue;
                        }
                        JavaHierarchyPanel.this.javaHierarchyTree.expandRow(row);
                    }
                }
                finally {
                    JRootPane rootPane = SwingUtilities.getRootPane(JavaHierarchyPanel.this);
                    if (rootPane != null) {
                        rootPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    private void expandAll() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JRootPane rootPane = SwingUtilities.getRootPane(JavaHierarchyPanel.this);
                if (rootPane != null) {
                    rootPane.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    for (int row = 0; row < JavaHierarchyPanel.this.javaHierarchyTree.getRowCount(); ++row) {
                        TreePath treePath = JavaHierarchyPanel.this.javaHierarchyTree.getPathForRow(row);
                        JavaHierarchyPanel.this.javaHierarchyTree.expandRow(row);
                    }
                    JavaHierarchyPanel.this.selectMatchingRow();
                }
                finally {
                    JRootPane rootPane = SwingUtilities.getRootPane(JavaHierarchyPanel.this);
                    if (rootPane != null) {
                        rootPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    private void selectMatchingRow() {
        this.javaHierarchyModel.setPattern(this.filterTextField.getText());
        for (int row = 0; row < this.javaHierarchyTree.getRowCount(); ++row) {
            Object o = this.javaHierarchyTree.getPathForRow(row).getLastPathComponent();
            if (!(o instanceof JavaElement) || !this.javaHierarchyModel.patternMatch((JavaElement)o)) continue;
            this.javaHierarchyTree.setSelectionRow(row);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoElement(JavaElement javaToolsJavaElement) {
        try {
            javaToolsJavaElement.gotoElement();
        }
        finally {
            this.close();
        }
    }

    private void showSignature() {
        Object node;
        this.signatureEditorPane.setText("");
        this.signatureEditorPane.setToolTipText(null);
        TreePath treePath = this.javaHierarchyTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.signatureEditorPane.setText(((JavaElement)node).getTooltip());
            this.signatureEditorPane.setCaretPosition(0);
            this.signatureEditorPane.setToolTipText(((JavaElement)node).getTooltip());
        }
    }

    private void showJavaDoc() {
        Object node;
        TreePath treePath = this.javaHierarchyTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
            Utils.showJavaDoc((JavaElement)node, this.javaDocPane);
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    private void initComponents() {
        this.javaHierarchyModeButtonGroup = new ButtonGroup();
        this.filterLabel = new JLabel();
        this.filterTextField = new JTextField();
        this.caseSensitiveFilterCheckBox = new JCheckBox();
        this.splitPane = new JSplitPane();
        this.javaHierarchyTreeScrollPane = new JScrollPane();
        this.javaHierarchyTree = new JTree();
        this.javaDocScrollPane = new JScrollPane();
        this.javaDocPane = new JEditorPane();
        this.signatureEditorPane = new JEditorPane();
        this.filtersLabel = new JLabel();
        this.showSuperTypeHierarchyToggleButton = new JToggleButton();
        this.showSubTypeHierarchyToggleButton = new JToggleButton();
        this.showFQNToggleButton = new JToggleButton();
        this.showInnerToggleButton = new JToggleButton();
        this.expandAllButton = new JButton();
        this.closeButton = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.filterLabel.setLabelFor(this.filterTextField);
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getBundle(JavaHierarchyPanel.class).getString("LABEL_filterLabel"));
        this.filterTextField.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_filterTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveFilterCheckBox, (String)NbBundle.getBundle(JavaHierarchyPanel.class).getString("LABEL_caseSensitiveFilterCheckBox"));
        this.caseSensitiveFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.caseSensitiveFilterCheckBox.setFocusable(false);
        this.caseSensitiveFilterCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.splitPane.setDividerLocation(350);
        this.splitPane.setOneTouchExpandable(true);
        this.javaHierarchyTreeScrollPane.setBorder(null);
        this.javaHierarchyTreeScrollPane.setViewportView(this.javaHierarchyTree);
        this.splitPane.setLeftComponent(this.javaHierarchyTreeScrollPane);
        this.javaDocPane.setEditable(false);
        this.javaDocScrollPane.setViewportView(this.javaDocPane);
        this.splitPane.setRightComponent(this.javaDocScrollPane);
        this.signatureEditorPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.signatureEditorPane.setContentType("text/x-java");
        this.signatureEditorPane.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage(JavaHierarchyPanel.class, (String)"LABEL_filtersLabel"));
        this.javaHierarchyModeButtonGroup.add(this.showSuperTypeHierarchyToggleButton);
        this.showSuperTypeHierarchyToggleButton.setIcon(JavaMembersAndHierarchyIcons.SUPER_TYPE_HIERARCHY_ICON);
        this.showSuperTypeHierarchyToggleButton.setSelected(true);
        this.showSuperTypeHierarchyToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showSuperTypeHierarchyToggleButton"));
        this.showSuperTypeHierarchyToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.javaHierarchyModeButtonGroup.add(this.showSubTypeHierarchyToggleButton);
        this.showSubTypeHierarchyToggleButton.setIcon(JavaMembersAndHierarchyIcons.SUB_TYPE_HIERARCHY_ICON);
        this.showSubTypeHierarchyToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showSubTypeHierarchyToggleButton"));
        this.showSubTypeHierarchyToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showFQNToggleButton.setIcon(JavaMembersAndHierarchyIcons.FQN_ICON);
        this.showFQNToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showFQNToggleButton"));
        this.showFQNToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showInnerToggleButton.setIcon(JavaMembersAndHierarchyIcons.INNER_CLASS_ICON);
        this.showInnerToggleButton.setSelected(true);
        this.showInnerToggleButton.setToolTipText(NbBundle.getBundle(JavaHierarchyPanel.class).getString("TOOLTIP_showInnerToggleButton"));
        this.showInnerToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.expandAllButton.setIcon(JavaMembersAndHierarchyIcons.EXPAND_ALL_ICON);
        this.expandAllButton.setToolTipText(NbBundle.getMessage(JavaHierarchyPanel.class, (String)"TOOLTIP_expandAll"));
        this.expandAllButton.setMargin(new Insets(2, 2, 2, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(JavaHierarchyPanel.class, (String)"LABEL_Close"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.splitPane, -1, 674, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.filterLabel).addPreferredGap(0).add((Component)this.filterTextField, -1, 547, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.caseSensitiveFilterCheckBox)).add((Component)this.signatureEditorPane, -1, 674, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.filtersLabel).addPreferredGap(0).add((Component)this.showSuperTypeHierarchyToggleButton).addPreferredGap(0).add((Component)this.showSubTypeHierarchyToggleButton).addPreferredGap(0).add((Component)this.showFQNToggleButton).addPreferredGap(0).add((Component)this.showInnerToggleButton).addPreferredGap(0).add((Component)this.expandAllButton).addPreferredGap(0, 504, Short.MAX_VALUE).add((Component)this.closeButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.filterLabel).add((Component)this.caseSensitiveFilterCheckBox).add((Component)this.filterTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.splitPane, -1, 333, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.signatureEditorPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.filtersLabel).add((Component)this.showSuperTypeHierarchyToggleButton).add((Component)this.showSubTypeHierarchyToggleButton).add((Component)this.showFQNToggleButton).add((Component)this.showInnerToggleButton).add((Component)this.expandAllButton).add((Component)this.closeButton)).addContainerGap()));
    }
}

