/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.navigation.JavaElement;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyIcons;
import org.netbeans.modules.java.navigation.JavaMembersAndHierarchyOptions;
import org.netbeans.modules.java.navigation.JavaMembersModel;
import org.netbeans.modules.java.navigation.JavaTreeCellRenderer;
import org.netbeans.modules.java.navigation.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JavaMembersPanel
extends JPanel {
    private FileObject fileObject;
    private JavaMembersModel javaMembersModel;
    private HyperlinkListener hyperlinkListener;
    private boolean showingSubDialog = false;
    public JCheckBox caseSensitiveFilterCheckBox;
    public JButton closeButton;
    public JLabel filterLabel;
    public JTextField filterTextField;
    public JLabel filtersLabel;
    public JEditorPane javaDocPane;
    public JScrollPane javaDocScrollPane;
    public JTree javaMembersTree;
    public JScrollPane javaMembersTreeScrollPane;
    public JToggleButton showConstructorsToggleButton;
    public JToggleButton showEnumConstantsToggleButton;
    public JToggleButton showFQNToggleButton;
    public JToggleButton showFieldsToggleButton;
    public JToggleButton showInheritedToggleButton;
    public JToggleButton showInnerToggleButton;
    public JToggleButton showMethodsToggleButton;
    public JToggleButton showPackageToggleButton;
    public JToggleButton showPrivateToggleButton;
    public JToggleButton showProtectedToggleButton;
    public JToggleButton showStaticToggleButton;
    public JEditorPane signatureEditorPane;
    public JSplitPane splitPane;

    public JavaMembersPanel(FileObject fileObject, Element[] elements, CompilationInfo compilationInfo) {
        this.fileObject = fileObject;
        this.initComponents();
        ToolTipManager.sharedInstance().registerComponent(this.javaMembersTree);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        this.caseSensitiveFilterCheckBox.setSelected(JavaMembersAndHierarchyOptions.isCaseSensitive());
        this.showInheritedToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowInherited());
        this.showFQNToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowFQN());
        this.showInnerToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowInner());
        this.showConstructorsToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowConstructors());
        this.showMethodsToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowMethods());
        this.showFieldsToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowFields());
        this.showEnumConstantsToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowEnumConstants());
        this.showProtectedToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowProtected());
        this.showPackageToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowPackage());
        this.showPrivateToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowPrivate());
        this.showStaticToggleButton.setSelected(JavaMembersAndHierarchyOptions.isShowStatic());
        this.javaMembersTree.getSelectionModel().setSelectionMode(1);
        this.javaMembersTree.setRootVisible(false);
        this.javaMembersTree.setShowsRootHandles(true);
        this.javaMembersTree.setCellRenderer(new JavaTreeCellRenderer());
        this.javaMembersModel = new JavaMembersModel(fileObject, elements, compilationInfo);
        this.javaMembersTree.setModel(this.javaMembersModel);
        this.javaDocPane.setEditorKitForContentType("text/html", new HTMLEditorKit());
        this.javaDocPane.setContentType("text/html");
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                JavaMembersPanel.this.applyFilter();
            }

            public void insertUpdate(DocumentEvent e) {
                JavaMembersPanel.this.applyFilter();
            }

            public void removeUpdate(DocumentEvent e) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, true), 0);
        this.signatureEditorPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.firstRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(36, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.previousRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(38, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.nextRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(40, 0, true), 0);
        this.signatureEditorPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Utils.lastRow(JavaMembersPanel.this.javaMembersTree);
            }
        }, KeyStroke.getKeyStroke(35, 0, true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaElement javaToolsJavaElement = (JavaElement)node;
                    JavaMembersPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.filterTextField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaMembersPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.caseSensitiveFilterCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JavaMembersPanel.this.filterTextField.getText().trim().length() > 0) {
                    JavaMembersPanel.this.applyFilter();
                }
            }
        });
        this.javaMembersTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                Object node;
                Point point = me.getPoint();
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getPathForLocation(point.x, point.y);
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    if (me.getClickCount() == 1) {
                        if (me.isControlDown()) {
                            JavaMembersPanel.this.filterTextField.setText("");
                            JavaElement javaToolsJavaElement = (JavaElement)node;
                            JavaMembersPanel.this.applyFilter();
                        }
                    } else if (me.getClickCount() == 2) {
                        JavaMembersPanel.this.gotoElement((JavaElement)node);
                    }
                }
            }
        });
        this.javaMembersTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                JavaMembersPanel.this.showSignature();
                JavaMembersPanel.this.showJavaDoc();
            }
        });
        this.javaMembersTree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getLeadSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaMembersPanel.this.gotoElement((JavaElement)node);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 0);
        this.javaMembersTree.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object node;
                TreePath treePath = JavaMembersPanel.this.javaMembersTree.getLeadSelectionPath();
                if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
                    JavaMembersPanel.this.filterTextField.setText("");
                    JavaMembersPanel.this.applyFilter();
                }
            }
        }, KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true), 0);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                URL url;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = e.getURL()) != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            }
        };
        this.javaDocPane.addHyperlinkListener(this.hyperlinkListener);
        this.showInheritedToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showFQNToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showInnerToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showConstructorsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showMethodsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showFieldsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showEnumConstantsToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showProtectedToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showPackageToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showPrivateToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.showStaticToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.applyFilter();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JavaMembersPanel.this.close();
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.applyFilter();
    }

    public void removeNotify() {
        this.javaDocPane.removeHyperlinkListener(this.hyperlinkListener);
        this.javaDocScrollPane.setViewportView(null);
        super.removeNotify();
    }

    private void applyFilter() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JRootPane rootPane = SwingUtilities.getRootPane(JavaMembersPanel.this);
                if (rootPane != null) {
                    rootPane.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int row;
                    JavaMembersPanel.this.javaMembersModel.setPattern(JavaMembersPanel.this.filterTextField.getText());
                    JavaMembersAndHierarchyOptions.setCaseSensitive(JavaMembersPanel.this.caseSensitiveFilterCheckBox.isSelected());
                    JavaMembersAndHierarchyOptions.setShowInherited(JavaMembersPanel.this.showInheritedToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowFQN(JavaMembersPanel.this.showFQNToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowInner(JavaMembersPanel.this.showInnerToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowConstructors(JavaMembersPanel.this.showConstructorsToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowMethods(JavaMembersPanel.this.showMethodsToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowFields(JavaMembersPanel.this.showFieldsToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowEnumConstants(JavaMembersPanel.this.showEnumConstantsToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowProtected(JavaMembersPanel.this.showProtectedToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowPackage(JavaMembersPanel.this.showPackageToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowPrivate(JavaMembersPanel.this.showPrivateToggleButton.isSelected());
                    JavaMembersAndHierarchyOptions.setShowStatic(JavaMembersPanel.this.showStaticToggleButton.isSelected());
                    JavaMembersPanel.this.javaMembersModel.update();
                    for (row = 0; row < JavaMembersPanel.this.javaMembersTree.getRowCount(); ++row) {
                        TreePath treePath = JavaMembersPanel.this.javaMembersTree.getPathForRow(row);
                        JavaMembersPanel.this.javaMembersTree.expandRow(row);
                    }
                    for (row = 0; row < JavaMembersPanel.this.javaMembersTree.getRowCount(); ++row) {
                        Object o = JavaMembersPanel.this.javaMembersTree.getPathForRow(row).getLastPathComponent();
                        if (!(o instanceof JavaElement) || !JavaMembersPanel.this.javaMembersModel.patternMatch((JavaElement)o)) continue;
                        JavaMembersPanel.this.javaMembersTree.setSelectionRow(row);
                        break;
                    }
                }
                finally {
                    JRootPane rootPane = SwingUtilities.getRootPane(JavaMembersPanel.this);
                    if (rootPane != null) {
                        rootPane.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gotoElement(JavaElement javaElement) {
        try {
            javaElement.gotoElement();
        }
        finally {
            this.close();
        }
    }

    private void showSignature() {
        Object node;
        this.signatureEditorPane.setText("");
        this.signatureEditorPane.setToolTipText(null);
        TreePath treePath = this.javaMembersTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
            this.signatureEditorPane.setText(((JavaElement)node).getTooltip());
            this.signatureEditorPane.setCaretPosition(0);
            this.signatureEditorPane.setToolTipText(((JavaElement)node).getTooltip());
        }
    }

    private void showJavaDoc() {
        Object node;
        TreePath treePath = this.javaMembersTree.getSelectionPath();
        if (treePath != null && (node = treePath.getLastPathComponent()) instanceof JavaElement) {
            Utils.showJavaDoc((JavaElement)node, this.javaDocPane);
        }
    }

    private void close() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.setVisible(false);
        }
    }

    private void gotoClass(TypeElement javaClass) {
    }

    private void initComponents() {
        this.filterLabel = new JLabel();
        this.filterTextField = new JTextField();
        this.caseSensitiveFilterCheckBox = new JCheckBox();
        this.splitPane = new JSplitPane();
        this.javaMembersTreeScrollPane = new JScrollPane();
        this.javaMembersTree = new JTree();
        this.javaDocScrollPane = new JScrollPane();
        this.javaDocPane = new JEditorPane();
        this.signatureEditorPane = new JEditorPane();
        this.filtersLabel = new JLabel();
        this.showInheritedToggleButton = new JToggleButton();
        this.showFQNToggleButton = new JToggleButton();
        this.showInnerToggleButton = new JToggleButton();
        this.showConstructorsToggleButton = new JToggleButton();
        this.showMethodsToggleButton = new JToggleButton();
        this.showFieldsToggleButton = new JToggleButton();
        this.showEnumConstantsToggleButton = new JToggleButton();
        this.showProtectedToggleButton = new JToggleButton();
        this.showPackageToggleButton = new JToggleButton();
        this.showPrivateToggleButton = new JToggleButton();
        this.showStaticToggleButton = new JToggleButton();
        this.closeButton = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.filterLabel.setLabelFor(this.filterTextField);
        Mnemonics.setLocalizedText((JLabel)this.filterLabel, (String)NbBundle.getBundle(JavaMembersPanel.class).getString("LABEL_filterLabel"));
        this.filterTextField.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_filterTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.caseSensitiveFilterCheckBox, (String)NbBundle.getBundle(JavaMembersPanel.class).getString("LABEL_caseSensitiveFilterCheckBox"));
        this.caseSensitiveFilterCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.caseSensitiveFilterCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.splitPane.setDividerLocation(350);
        this.splitPane.setOneTouchExpandable(true);
        this.javaMembersTreeScrollPane.setBorder(null);
        this.javaMembersTreeScrollPane.setViewportView(this.javaMembersTree);
        this.splitPane.setLeftComponent(this.javaMembersTreeScrollPane);
        this.javaDocPane.setEditable(false);
        this.javaDocScrollPane.setViewportView(this.javaDocPane);
        this.splitPane.setRightComponent(this.javaDocScrollPane);
        this.signatureEditorPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Nb.ScrollPane.Border.color")));
        this.signatureEditorPane.setContentType("text/x-java");
        this.signatureEditorPane.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage(JavaMembersPanel.class, (String)"LABEL_filtersLabel"));
        this.showInheritedToggleButton.setIcon(JavaMembersAndHierarchyIcons.INHERITED_ICON);
        this.showInheritedToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showInheritedToggleButton"));
        this.showInheritedToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showFQNToggleButton.setIcon(JavaMembersAndHierarchyIcons.FQN_ICON);
        this.showFQNToggleButton.setSelected(true);
        this.showFQNToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showFQNToggleButton"));
        this.showFQNToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showInnerToggleButton.setIcon(JavaMembersAndHierarchyIcons.INNER_CLASS_ICON);
        this.showInnerToggleButton.setSelected(true);
        this.showInnerToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showInnerToggleButton"));
        this.showInnerToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showConstructorsToggleButton.setIcon(JavaMembersAndHierarchyIcons.CONSTRUCTOR_ICON);
        this.showConstructorsToggleButton.setSelected(true);
        this.showConstructorsToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showConstructorsToggleButton"));
        this.showConstructorsToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showMethodsToggleButton.setIcon(JavaMembersAndHierarchyIcons.METHOD_ICON);
        this.showMethodsToggleButton.setSelected(true);
        this.showMethodsToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showMethodsToggleButton"));
        this.showMethodsToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showFieldsToggleButton.setIcon(JavaMembersAndHierarchyIcons.FIELD_ICON);
        this.showFieldsToggleButton.setSelected(true);
        this.showFieldsToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showFieldsToggleButton"));
        this.showFieldsToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showEnumConstantsToggleButton.setIcon(JavaMembersAndHierarchyIcons.ENUM_CONSTANTS_ICON);
        this.showEnumConstantsToggleButton.setSelected(true);
        this.showEnumConstantsToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showEnumConstantsToggleButton"));
        this.showEnumConstantsToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showProtectedToggleButton.setIcon(JavaMembersAndHierarchyIcons.PROTECTED_ICON);
        this.showProtectedToggleButton.setSelected(true);
        this.showProtectedToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showProtectedToggleButton"));
        this.showProtectedToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showPackageToggleButton.setIcon(JavaMembersAndHierarchyIcons.PACKAGE_ICON);
        this.showPackageToggleButton.setSelected(true);
        this.showPackageToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showPackageToggleButton"));
        this.showPackageToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showPrivateToggleButton.setIcon(JavaMembersAndHierarchyIcons.PRIVATE_ICON);
        this.showPrivateToggleButton.setSelected(true);
        this.showPrivateToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showPrivateToggleButton"));
        this.showPrivateToggleButton.setMargin(new Insets(2, 2, 2, 2));
        this.showStaticToggleButton.setIcon(JavaMembersAndHierarchyIcons.STATIC_ICON);
        this.showStaticToggleButton.setSelected(true);
        this.showStaticToggleButton.setToolTipText(NbBundle.getBundle(JavaMembersPanel.class).getString("TOOLTIP_showStaticToggleButton"));
        this.showStaticToggleButton.setMargin(new Insets(2, 2, 2, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.closeButton, (String)NbBundle.getMessage(JavaMembersPanel.class, (String)"LABEL_Close"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.splitPane, -1, 674, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.filterLabel).addPreferredGap(0).add((Component)this.filterTextField, -1, 547, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.caseSensitiveFilterCheckBox)).add((Component)this.signatureEditorPane, -1, 674, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.filtersLabel).addPreferredGap(0).add((Component)this.showInheritedToggleButton).addPreferredGap(0).add((Component)this.showFQNToggleButton).addPreferredGap(0).add((Component)this.showInnerToggleButton).addPreferredGap(0).add((Component)this.showConstructorsToggleButton).addPreferredGap(0).add((Component)this.showMethodsToggleButton).addPreferredGap(0).add((Component)this.showFieldsToggleButton).addPreferredGap(0).add((Component)this.showEnumConstantsToggleButton).addPreferredGap(0).add((Component)this.showProtectedToggleButton).addPreferredGap(0).add((Component)this.showPackageToggleButton).addPreferredGap(0).add((Component)this.showPrivateToggleButton).addPreferredGap(0).add((Component)this.showStaticToggleButton).addPreferredGap(0, 408, Short.MAX_VALUE).add((Component)this.closeButton))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.filterLabel).add((Component)this.caseSensitiveFilterCheckBox).add((Component)this.filterTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.splitPane, -1, 333, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.signatureEditorPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.filtersLabel).add((Component)this.showInheritedToggleButton).add((Component)this.showFQNToggleButton).add((Component)this.showInnerToggleButton).add((Component)this.showConstructorsToggleButton).add((Component)this.showMethodsToggleButton).add((Component)this.showFieldsToggleButton).add((Component)this.showEnumConstantsToggleButton).add((Component)this.showProtectedToggleButton).add((Component)this.showPackageToggleButton).add((Component)this.showPrivateToggleButton).add((Component)this.showStaticToggleButton).add((Component)this.closeButton)).addContainerGap()));
    }
}

