/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UpdateTableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledTableModel
extends UnitCategoryTableModel {
    private OperationContainer<OperationSupport> enableContainer = Containers.forEnable();
    private OperationContainer<OperationSupport> disableContainer = Containers.forDisable();
    private OperationContainer<OperationSupport> uninstallContainer = Containers.forUninstall();
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.InstalledTableModel");

    public InstalledTableModel(List<UnitCategory> categories) {
        super(categories);
    }

    @Override
    public void setValueAt(Object anValue, int row, int col) {
        super.setValueAt(anValue, row, col);
        if (!this.isCategoryAtRow(row)) {
            if (col == 1) {
                return;
            }
            assert (col == 0) : "First column.";
            if (anValue == null) {
                return;
            }
            Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
            assert (anValue instanceof Boolean) : anValue + " must be instanceof Boolean.";
            boolean beforeMarked = u.isMarked();
            u.setMarked(!beforeMarked);
            if (u.isMarked() != beforeMarked) {
                this.fireButtonsChange();
            } else {
                String message = NbBundle.getMessage(UpdateTableModel.class, (String)"NotificationAlreadyPreparedToIntsall", (Object)u.getDisplayName());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
            }
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object res = null;
        if (this.isCategoryAtRow(row)) {
            res = col == 0 ? this.getCategoryAtRow(row) : null;
        } else {
            Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
            switch (col) {
                case 0: {
                    res = u.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: {
                    res = u.getDisplayName();
                    break;
                }
                case 2: {
                    res = u.getInstalledVersion();
                    break;
                }
                case 3: {
                    res = u.getBackupVersion();
                    break;
                }
                case 4: {
                    res = u.getMyRating();
                }
            }
        }
        return res;
    }

    @Override
    public Class getColumnClass(int c) {
        Class res = null;
        switch (c) {
            case 0: {
                res = Boolean.class;
                break;
            }
            case 1: {
                res = String.class;
                break;
            }
            case 2: {
                res = String.class;
                break;
            }
            case 3: {
                res = String.class;
                break;
            }
            case 4: {
                res = Integer.class;
            }
        }
        return res;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.getBundle("InstalledTableModel_Columns_Uninstall");
            }
            case 1: {
                return this.getBundle("InstalledTableModel_Columns_Name");
            }
            case 2: {
                return this.getBundle("InstalledTableModel_Columns_Installed");
            }
            case 3: {
                return this.getBundle("InstalledTableModel_Columns_Previous");
            }
            case 4: {
                return this.getBundle("InstalledTableModel_Columns_MyRating");
            }
        }
        assert (false);
        return super.getColumnName(column);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.isCategoryAtRow(row)) {
            if (col == 1) {
                Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
                return u.isUninstallAllowed();
            }
            if (col == 0) {
                Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
                return u.isUninstallAllowed();
            }
        }
        return super.isCellEditable(row, col);
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.INSTALLED;
    }

    @Override
    public boolean isSortAllowed(Object columnIdentifier) {
        boolean isUninstall = this.getColumnName(0).equals(columnIdentifier);
        boolean isPrevious = this.getColumnName(3).equals(columnIdentifier);
        boolean isRating = this.getColumnName(4).equals(columnIdentifier);
        return !isUninstall && !isPrevious && !isRating;
    }

    @Override
    protected Comparator<Unit> getComparator(final Object columnIdentifier, final boolean sortAscending) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                Unit unit2;
                Unit unit1 = sortAscending ? o1 : o2;
                Unit unit = unit2 = sortAscending ? o2 : o1;
                if (InstalledTableModel.this.getColumnName(0).equals(columnIdentifier)) {
                    assert (false) : columnIdentifier.toString();
                } else {
                    if (InstalledTableModel.this.getColumnName(1).equals(columnIdentifier)) {
                        return Unit.compareDisplayNames(unit1, unit2);
                    }
                    if (InstalledTableModel.this.getColumnName(2).equals(columnIdentifier)) {
                        return Unit.Installed.compareInstalledVersions(unit1, unit2);
                    }
                    if (InstalledTableModel.this.getColumnName(3).equals(columnIdentifier) ? !$assertionsDisabled : InstalledTableModel.this.getColumnName(4).equals(columnIdentifier) && !$assertionsDisabled) {
                        throw new AssertionError((Object)columnIdentifier.toString());
                    }
                }
                return 0;
            }
        };
    }

    @Override
    public OperationContainer getContainer() {
        return this.uninstallContainer;
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }
}

