/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDownloadSupport {
    private static final FileFilter NBM_FILE_FILTER = new NbmFileFilter();
    private Set<File> selectedFiles = null;
    private static String LOCAL_DOWNLOAD_DIRECTORY_KEY = "local-download-directory";

    public File[] selectNbmFiles() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(NBM_FILE_FILTER);
        chooser.setFileFilter(NBM_FILE_FILTER);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileHidingEnabled(false);
        chooser.setDialogTitle(LocalDownloadSupport.getBundle("CTL_FileChooser_Title"));
        String filePath = this.getPreferences().get(LOCAL_DOWNLOAD_DIRECTORY_KEY, null);
        File dir = null;
        if (filePath != null && !(dir = new File(filePath)).exists()) {
            dir = LocalDownloadSupport.getDefaultDir();
        }
        if (dir != null) {
            chooser.setCurrentDirectory(dir);
        }
        Window focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (chooser.showOpenDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == 0) {
            File[] newFiles = chooser.getSelectedFiles();
            this.getSelectedFiles().addAll(Arrays.asList(newFiles));
        }
        this.getPreferences().put(LOCAL_DOWNLOAD_DIRECTORY_KEY, chooser.getCurrentDirectory().getAbsolutePath());
        return this.getSelectedFiles().toArray(new File[0]);
    }

    public List<UpdateUnit> getUpdateUnits() {
        File[] nbms = this.selectNbmFiles();
        List retval = null;
        retval = nbms != null ? UpdateUnitProviderFactory.getDefault().create("local-downloaded", nbms).getUpdateUnits() : Collections.emptyList();
        return retval;
    }

    private static File getDefaultDir() {
        return new File(System.getProperty("netbeans.user"));
    }

    public static String getBundle(String key) {
        return NbBundle.getMessage(LocalDownloadSupport.class, (String)key);
    }

    private Set<File> getSelectedFiles() {
        if (this.selectedFiles == null) {
            this.selectedFiles = new HashSet<File>();
        }
        return this.selectedFiles;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(LocalDownloadSupport.class);
    }

    private static class NbmFileFilter
    extends FileFilter {
        private NbmFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".nbm");
        }

        public String getDescription() {
            return LocalDownloadSupport.getBundle("CTL_FileFilterDescription");
        }
    }
}

