/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.autoupdate.ui.PluginColumn;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LocalPluginColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener {
    private JLabel editName;
    private JLabel rendererName;
    private JButton editButton;
    private JButton rendererButton;
    private JPanel editPanel;
    private JPanel rendererPanel;
    private JTable table;
    private UnitCategoryTableModel model;
    private int activeRow = -1;
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.LocalPluginColumn");

    public LocalPluginColumn(JTable table, int column, UnitCategoryTableModel model) {
        this.model = model;
        this.table = table;
        this.editButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)this.getBundle("LocalPluginColumn_editRemoveButton_Name", new Object[0]));
        this.rendererButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.rendererButton, (String)this.getBundle("LocalPluginColumn_editRemoveButton_Name", new Object[0]));
        this.editButton.addActionListener(this);
        this.editName = new JLabel();
        this.rendererName = new JLabel();
        this.editName.setOpaque(true);
        this.rendererName.setOpaque(true);
        this.editPanel = new JPanel(new BorderLayout());
        this.editPanel.add((Component)this.editName, "North");
        this.editPanel.add((Component)this.editButton, "West");
        this.editPanel.setOpaque(true);
        this.rendererPanel = new JPanel(new BorderLayout());
        this.rendererPanel.add((Component)this.rendererName, "North");
        this.rendererPanel.add((Component)this.editButton, "West");
        this.rendererPanel.setOpaque(true);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(column).setCellRenderer(this);
        columnModel.getColumn(column).setCellEditor(this);
    }

    public Object getCellEditorValue() {
        return this.editPanel;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent res = null;
        assert (!this.model.isCategoryAtRow(row)) : "Don't applay to category on row " + row;
        Unit u = this.model.getUnitAtRow(row);
        this.rendererName.setText(u.getDisplayName());
        if (isSelected) {
            Mnemonics.setLocalizedText((AbstractButton)this.rendererButton, (String)this.getBundle("LocalPluginColumn_editRemoveButton_Name", new Object[0]));
            this.rendererPanel.add((Component)this.rendererName, "North");
            this.rendererPanel.add((Component)this.rendererButton, "West");
            res = this.rendererPanel;
        } else {
            res = this.rendererName;
        }
        if (isSelected || hasFocus) {
            Color c = UIManager.getColor("Table.selectionBackground");
            this.rendererName.setBackground(c);
            ((Component)res).setBackground(c);
        } else {
            Color c = UIManager.getColor("Table.background");
            this.rendererName.setBackground(c);
            ((Component)res).setBackground(c);
        }
        return res;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JPanel res = null;
        assert (!this.model.isCategoryAtRow(row)) : "Don't applay to category on row " + row;
        Unit u = this.model.getUnitAtRow(row);
        this.editName.setText(u.getDisplayName());
        this.editPanel.add((Component)new JLabel(u.getDisplayName()), "North");
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)this.getBundle("LocalPluginColumn_editRemoveButton_Name", new Object[0]));
        this.editButton.setDefaultCapable(true);
        this.editPanel.add((Component)this.editName, "North");
        this.editPanel.add((Component)this.editButton, "West");
        res = this.editPanel;
        this.activeRow = row;
        Color c = UIManager.getColor("Table.selectionBackground");
        this.editName.setBackground(c);
        this.editButton.setBackground(c);
        ((Component)res).setBackground(c);
        return res;
    }

    private String getBundle(String key, Object ... arguments) {
        return NbBundle.getMessage(PluginColumn.class, (String)key, (Object[])arguments);
    }

    public void actionPerformed(ActionEvent evt) {
        assert (this.activeRow != -1);
        Unit unit = this.model.getUnitAtRow(this.activeRow);
        this.fireEditingStopped();
    }
}

