/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.Comparator;
import java.util.List;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocallyDownloadedTableModel
extends UnitCategoryTableModel {
    private OperationContainer<InstallSupport> availableNbmsContainer = Containers.forAvailableNbms();
    private OperationContainer<InstallSupport> updateNbmsContainer = Containers.forUpdateNbms();

    public LocallyDownloadedTableModel(List<UnitCategory> categories) {
        super(categories);
    }

    @Override
    public void setValueAt(Object anValue, int row, int col) {
        super.setValueAt(anValue, row, col);
        if (!this.isCategoryAtRow(row)) {
            if (anValue == null) {
                return;
            }
            if (!(anValue instanceof Boolean)) {
                return;
            }
            Unit u = this.getUnitAtRow(row);
            assert (anValue instanceof Boolean) : anValue + " must be instanceof Boolean.";
            boolean beforeMarked = u.isMarked();
            u.setMarked(!beforeMarked);
            if (u.isMarked() != beforeMarked) {
                this.fireButtonsChange();
            }
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object res = null;
        if (this.isCategoryAtRow(row)) {
            res = col == 0 ? this.getCategoryAtRow(row) : null;
        } else {
            Unit u = this.getUnitAtRow(row);
            boolean isAvailable = u instanceof Unit.Available;
            switch (col) {
                case 0: {
                    res = u.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 1: {
                    res = u.getDisplayName();
                    break;
                }
                case 2: {
                    if (isAvailable) {
                        res = ((Unit.Available)u).getAvailableVersion();
                        break;
                    }
                    res = ((Unit.Update)u).getAvailableVersion();
                    break;
                }
                case 3: {
                    if (isAvailable) {
                        res = ((Unit.Available)u).getSize();
                        break;
                    }
                    res = ((Unit.Update)u).getSize();
                    break;
                }
                case 4: {
                    res = isAvailable ? ((Unit.Available)u).getMyRating() : Integer.valueOf(0);
                }
            }
        }
        return res;
    }

    @Override
    public Class getColumnClass(int c) {
        Class res = null;
        switch (c) {
            case 0: {
                res = Boolean.class;
                break;
            }
            case 1: {
                res = String.class;
                break;
            }
            case 2: {
                res = String.class;
                break;
            }
            case 3: {
                res = String.class;
                break;
            }
            case 4: {
                res = Integer.class;
            }
        }
        return res;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Install");
            }
            case 1: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Name");
            }
            case 2: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Version");
            }
            case 3: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Size");
            }
            case 4: {
                return this.getBundle("LocallyDownloadedTableModel_Columns_Rating");
            }
        }
        assert (false);
        return super.getColumnName(column);
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.LOCAL;
    }

    @Override
    public boolean isSortAllowed(Object columnIdentifier) {
        boolean isInstall = this.getColumnName(0).equals(columnIdentifier);
        boolean isRating = this.getColumnName(4).equals(columnIdentifier);
        return !isInstall && !isRating;
    }

    @Override
    protected Comparator<Unit> getComparator(final Object columnIdentifier, final boolean sortAscending) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                Unit unit2;
                Unit unit1 = sortAscending ? o1 : o2;
                Unit unit = unit2 = sortAscending ? o2 : o1;
                if (LocallyDownloadedTableModel.this.getColumnName(0).equals(columnIdentifier)) {
                    assert (false) : columnIdentifier.toString();
                } else {
                    if (LocallyDownloadedTableModel.this.getColumnName(1).equals(columnIdentifier)) {
                        return Unit.compareDisplayNames(unit1, unit2);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(2).equals(columnIdentifier)) {
                        return Unit.compareDisplayVersions(unit1, unit2);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(3).equals(columnIdentifier)) {
                        return Unit.compareCompleteSizes(unit1, unit2);
                    }
                    if (LocallyDownloadedTableModel.this.getColumnName(4).equals(columnIdentifier)) assert (false) : columnIdentifier.toString();
                }
                return 0;
            }
        };
    }

    @Override
    public OperationContainer getContainer() {
        int available = Containers.forAvailableNbms().listAll().size();
        int updates = Containers.forUpdateNbms().listAll().size();
        return updates > available ? Containers.forUpdateNbms() : Containers.forAvailableNbms();
    }

    private String getBundle(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public class DisplayName {
        public DisplayName(String name) {
        }
    }
}

