/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UpdateTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
TreeExpansionListener {
    private JLabel editName;
    private JLabel rendererName;
    private JTree editTree;
    private JTree rendererTree;
    private JPanel editPanel;
    private JPanel rendererPanel;
    private JTable table;
    private UnitCategoryTableModel model;
    private boolean isUpdate;
    private int expandedRow = -1;
    private static final Icon openedIcon = UIManager.getIcon("Tree.expandedIcon");
    private static final Icon closedIcon = UIManager.getIcon("Tree.collapsedIcon");

    public PluginColumn(JTable table, int column, UnitCategoryTableModel model) {
        this.model = model;
        this.table = table;
        this.isUpdate = model instanceof UpdateTableModel;
        this.editTree = new JTree();
        this.editTree.setToggleClickCount(1);
        this.editTree.setSelectionRow(0);
        this.initTree(this.editTree);
        this.editTree.addTreeExpansionListener(this);
        this.rendererTree = new JTree();
        this.initTree(this.rendererTree);
        this.editName = new JLabel();
        this.rendererName = new JLabel();
        this.editName.setOpaque(true);
        this.rendererName.setOpaque(true);
        this.editPanel = new JPanel(new BorderLayout());
        this.editPanel.add((Component)this.editName, "North");
        this.editPanel.add((Component)this.editTree, "Center");
        this.editPanel.setBackground(UIManager.getColor("Table.selectionBackground"));
        this.editPanel.setForeground(UIManager.getColor("Table.selectionForeground"));
        this.editPanel.setOpaque(true);
        this.rendererPanel = new JPanel(new BorderLayout());
        this.rendererPanel.add((Component)this.rendererName, "North");
        this.rendererPanel.add((Component)this.rendererTree, "Center");
        this.rendererTree.setBackground(UIManager.getColor("Table.selectionBackground"));
        this.rendererTree.setForeground(UIManager.getColor("Table.selectionForeground"));
        this.rendererPanel.setOpaque(true);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(column).setCellRenderer(this);
        columnModel.getColumn(column).setCellEditor(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editPanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color fg;
        Color bg;
        Unit u;
        JComponent res = null;
        assert (!this.model.isCategoryAtRow(row)) : "Don't apply to category on row " + row;
        if (!isSelected) {
            u = this.model.getUnitAtRow(row);
            this.rendererName.setText(u.getDisplayName());
            res = this.rendererName;
        } else {
            assert (row >= 0);
            u = this.model.getUnitAtRow(row);
            this.rendererName.setText(u.getDisplayName());
            OperationContainer container = this.isUpdate ? OperationContainer.createForDirectUpdate() : OperationContainer.createForDirectInstall();
            List<UpdateElement> reqs = Utilities.getRequiredElements(u.updateUnit, u.getRelevantElement(), (OperationContainer<OperationSupport>)container);
            if (reqs == null || reqs.isEmpty()) {
                res = this.rendererName;
            } else {
                this.rendererTree.setModel(this.getDependedPluginsModel(reqs));
                if (row != this.expandedRow) {
                    this.rendererTree.collapseRow(0);
                }
                this.rendererPanel.add((Component)this.rendererName, "North");
                res = !isSelected && !hasFocus ? this.rendererName : this.rendererPanel;
            }
        }
        if (isSelected || hasFocus) {
            bg = UIManager.getColor("Table.selectionBackground");
            this.rendererName.setBackground(bg);
            this.rendererTree.setBackground(bg);
            ((Component)res).setBackground(bg);
            fg = UIManager.getColor("Table.selectionForeground");
            this.rendererName.setForeground(fg);
            this.rendererTree.setForeground(fg);
            ((Component)res).setForeground(fg);
        } else {
            bg = UIManager.getColor("Table.background");
            this.rendererName.setBackground(bg);
            this.rendererTree.setBackground(bg);
            ((Component)res).setBackground(bg);
            fg = UIManager.getColor("Table.foreground");
            this.rendererName.setForeground(fg);
            this.rendererTree.setForeground(fg);
            ((Component)res).setForeground(fg);
        }
        return res;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComponent res = null;
        assert (!this.model.isCategoryAtRow(row)) : "Don't applay to category on row " + row;
        Unit u = this.model.getUnitAtRow(row);
        this.editName.setText(u.getDisplayName());
        this.editPanel.add((Component)new JLabel(u.getDisplayName()), "North");
        List<UpdateElement> reqs = Utilities.getRequiredElements(u.updateUnit, u.getRelevantElement(), (OperationContainer<OperationSupport>)(this.isUpdate ? OperationContainer.createForDirectUpdate() : OperationContainer.createForDirectInstall()));
        if (reqs == null || reqs.isEmpty()) {
            res = this.editName;
        } else {
            this.editTree.setModel(this.getDependedPluginsModel(reqs));
            this.editPanel.add((Component)this.editName, "North");
            res = this.editPanel;
            if (row != this.expandedRow) {
                this.editTree.collapseRow(0);
            }
        }
        Color bg = UIManager.getColor("Table.selectionBackground");
        this.editName.setBackground(bg);
        this.editTree.setBackground(bg);
        ((Component)res).setBackground(bg);
        Color fg = UIManager.getColor("Table.selectionForeground");
        this.editName.setForeground(fg);
        this.editTree.setForeground(fg);
        return res;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent evt) {
        this.expandedRow = this.table.getSelectedRow();
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        if (this.model.isCategoryAtRow(row)) {
            return;
        }
        int h = this.getTableCellRendererComponent((JTable)this.table, (Object)Integer.valueOf((int)0), (boolean)true, (boolean)true, (int)row, (int)0).getPreferredSize().height;
        this.table.setRowHeight(row, h);
        this.fireEditingStopped();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent evt) {
        this.expandedRow = -1;
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        if (this.model.isCategoryAtRow(row)) {
            return;
        }
        int h = this.getTableCellRendererComponent((JTable)this.table, (Object)Integer.valueOf((int)0), (boolean)true, (boolean)true, (int)row, (int)0).getPreferredSize().height;
        this.table.setRowHeight(row, h);
    }

    private TreeModel getDependedPluginsModel(List<UpdateElement> reqs) {
        return new DefaultTreeModel(this.getRoot(reqs));
    }

    private TreeNode getRoot(List<UpdateElement> reqs) {
        assert (reqs != null && !reqs.isEmpty()) : "List of UpdateElement is not null and non-empty";
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.getBundle("PluginColumn_TreeRootName", reqs.size(), reqs.size()));
        for (UpdateElement el : reqs) {
            root.add(new DefaultMutableTreeNode(el));
        }
        return root;
    }

    private void initTree(JTree tree) {
        tree.setBackground(UIManager.getColor("Table.selectionBackground"));
        tree.setForeground(UIManager.getColor("Table.selectionForeground"));
        final TreeCellRenderer df = tree.getCellRenderer();
        tree.setCellRenderer(new TreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = df.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode) {
                    value = ((DefaultMutableTreeNode)value).getUserObject();
                }
                if (value instanceof String) {
                    JLabel l = new JLabel((String)value);
                    if (!Utilities.isGtk()) {
                        if (tree.isExpanded(0)) {
                            l.setIcon(openedIcon);
                        } else {
                            l.setIcon(closedIcon);
                        }
                    }
                    l.setBackground(UIManager.getColor("Table.selectionBackground"));
                    l.setForeground(UIManager.getColor("Table.selectionForeground"));
                    l.setOpaque(true);
                    c = l;
                } else if (value instanceof UpdateElement) {
                    UpdateElement el = (UpdateElement)value;
                    JLabel l = new JLabel("     " + el.getDisplayName());
                    l.setBackground(UIManager.getColor("Table.selectionBackground"));
                    l.setForeground(UIManager.getColor("Table.selectionForeground"));
                    l.setOpaque(true);
                    c = l;
                }
                return c;
            }
        });
    }

    private String getBundle(String key, Object ... arguments) {
        return NbBundle.getMessage(PluginColumn.class, (String)key, (Object[])arguments);
    }
}

