/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.SettingsTableModel;
import org.netbeans.modules.autoupdate.ui.UpdateUnitProviderPanel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SettingsTab
extends JPanel {
    private final DetailsPanel details;
    private Listener listener;
    private static final RequestProcessor RP = new RequestProcessor();
    private final RequestProcessor.Task searchTask = RP.create(new Runnable(){

        public void run() {
            String filter = SettingsTab.this.tfSearch.getText().trim();
            if (filter != null) {
                SettingsTab.this.getSettingsTableModel().setFilter(filter);
            }
        }
    });
    private JButton bEdit;
    private JButton bNew;
    private JButton bProxy;
    private JButton bRemove;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JLabel lHeader;
    private JLabel lSearch;
    private JTextField tfSearch;

    public SettingsTab(PluginManagerUI manager) {
        this.initComponents();
        this.getSettingsTableModel().setPluginManager(manager);
        TableColumn activeColumn = this.jTable1.getColumnModel().getColumn(0);
        activeColumn.setMaxWidth(this.jTable1.getTableHeader().getHeaderRect((int)0).width);
        this.details = new DetailsPanel();
        this.jScrollPane2.setViewportView(this.details);
        this.addListener();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_displayName");
    }

    private void addListener() {
        if (this.listener == null) {
            this.listener = new Listener();
            this.tfSearch.getDocument().addDocumentListener(this.listener);
            this.jTable1.getSelectionModel().addListSelectionListener(this.listener);
            this.jTable1.addFocusListener(this.listener);
            this.getSettingsTableModel().addTableModelListener(this.listener);
        }
    }

    private void removeListener() {
        if (this.listener != null) {
            this.tfSearch.getDocument().removeDocumentListener(this.listener);
            this.jTable1.getSelectionModel().removeListSelectionListener(this.listener);
            this.jTable1.removeFocusListener(this.listener);
            this.getSettingsTableModel().removeTableModelListener(this.listener);
            this.listener = null;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.getSettingsTableModel().refreshModel();
        this.addListener();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListener();
    }

    private void initComponents() {
        this.lHeader = new JLabel();
        this.lSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.bEdit = new JButton();
        this.bNew = new JButton();
        this.bRemove = new JButton();
        this.bProxy = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.lHeader.setLabelFor(this.jTable1);
        Mnemonics.setLocalizedText((JLabel)this.lHeader, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lHeader.text"));
        this.lSearch.setLabelFor(this.tfSearch);
        Mnemonics.setLocalizedText((JLabel)this.lSearch, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lSearch.text"));
        this.jTable1.setModel(new SettingsTableModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bEdit.text"));
        this.bEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsTab.this.bEditActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bNew, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bNew.text"));
        this.bNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsTab.this.bNewActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bRemove.text"));
        this.bRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsTab.this.bRemoveActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bProxy, (String)NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bProxy.text"));
        this.bProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsTab.this.bProxyActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 639, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lHeader).addPreferredGap(0, 49, Short.MAX_VALUE).add((Component)this.lSearch).add(4, 4, 4).add((Component)this.tfSearch, -2, 114, -2)).add((Component)this.jScrollPane1, -1, 529, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.bEdit, -1, -1, Short.MAX_VALUE).add((Component)this.bNew, -1, -1, Short.MAX_VALUE).add((Component)this.bRemove, -1, -1, Short.MAX_VALUE))).add(2, (Component)this.bProxy)).addContainerGap()));
        layout.linkSize(new Component[]{this.bEdit, this.bNew, this.bProxy, this.bRemove}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.tfSearch, -2, -1, -2).add((Component)this.lHeader).add((Component)this.lSearch)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bEdit).addPreferredGap(0).add((Component)this.bNew).addPreferredGap(0).add((Component)this.bRemove)).add((Component)this.jScrollPane1, -1, 222, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.bProxy).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 105, Short.MAX_VALUE).addContainerGap()));
        this.lHeader.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lHeader.adesc"));
        this.lSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.lSearch.adesc"));
        this.bEdit.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bEdit.adesc"));
        this.bNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bNew.adesc"));
        this.bRemove.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bRemove.adesc"));
        this.bProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.bProxy.adesc"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab.adesc"));
    }

    private void bEditActionPerformed(ActionEvent evt) {
        final int rowIndex = this.jTable1.getSelectedRow();
        if (rowIndex != -1) {
            final UpdateUnitProvider provider = this.getSettingsTableModel().getUpdateUnitProvider(rowIndex);
            if (provider == null) {
                return;
            }
            final UpdateUnitProviderPanel panel = new UpdateUnitProviderPanel(provider.isEnabled(), provider.getDisplayName(), provider.getProviderURL().toExternalForm(), true);
            DialogDescriptor descriptor = SettingsTab.getCustomizerDescriptor(panel);
            panel.getOKButton().addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    SettingsTab.this.setData(provider, panel);
                    SettingsTab.this.getSettingsTableModel().refreshModel();
                    SettingsTab.this.jTable1.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                }
            });
            DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
        }
    }

    private void bNewActionPerformed(ActionEvent evt) {
        final UpdateUnitProviderPanel panel = new UpdateUnitProviderPanel(true, NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_NewProviderName"), NbBundle.getMessage(SettingsTab.class, (String)"SettingsTab_NewProviderURL"), false);
        DialogDescriptor descriptor = SettingsTab.getCustomizerDescriptor(panel);
        panel.getOKButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    SettingsTab.this.getSettingsTableModel().add(panel.getProviderName(), panel.getProviderName(), new URL(panel.getProviderURL()), panel.isActive());
                    SettingsTab.this.getSettingsTableModel().refreshModel();
                    SettingsTableModel model = SettingsTab.this.getSettingsTableModel();
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        String providerName = model.getValueAt(i, 1).toString();
                        if (panel.getProviderName() == null || !panel.getProviderName().equals(providerName)) continue;
                        SettingsTab.this.jTable1.getSelectionModel().setSelectionInterval(i, i);
                    }
                }
                catch (MalformedURLException mex) {
                    Exceptions.printStackTrace((Throwable)mex);
                }
            }
        });
        DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
    }

    private void bProxyActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("General");
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int[] rowIndexes;
        SettingsTableModel model = this.getSettingsTableModel();
        for (int rowIndex : rowIndexes = this.jTable1.getSelectedRows()) {
            if (rowIndex == -1) continue;
            model.remove(rowIndex);
        }
        model.refreshModel();
        if (rowIndexes.length > 0) {
            if (model.getRowCount() > rowIndexes[0]) {
                this.jTable1.getSelectionModel().setSelectionInterval(rowIndexes[0], rowIndexes[0]);
            } else {
                this.jTable1.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
    }

    private void setData(final UpdateUnitProvider provider, UpdateUnitProviderPanel panel) {
        provider.setDisplayName(panel.getProviderName());
        boolean forceRead = false;
        boolean refreshModel = false;
        try {
            URL oldUrl = provider.getProviderURL();
            URL newUrl = new URL(panel.getProviderURL());
            if (!oldUrl.equals(newUrl)) {
                provider.setProviderURL(newUrl);
                refreshModel = true;
                forceRead = true;
            }
        }
        catch (MalformedURLException mex) {
            Exceptions.printStackTrace((Throwable)mex);
        }
        boolean oldValue = provider.isEnabled();
        if (oldValue != panel.isActive()) {
            refreshModel = true;
        }
        if (refreshModel) {
            provider.setEnable(panel.isActive());
            if (oldValue && !forceRead) {
                this.getSettingsTableModel().getPluginManager().updateUnitsChanged();
            } else {
                final boolean force = forceRead;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        Utilities.presentRefreshProvider(provider, SettingsTab.this.getSettingsTableModel().getPluginManager(), force);
                        SettingsTab.this.getSettingsTableModel().getPluginManager().updateUnitsChanged();
                    }
                });
            }
        }
    }

    private static DialogDescriptor getCustomizerDescriptor(UpdateUnitProviderPanel panel) {
        JButton bOK = panel.getOKButton();
        Object[] options = new Object[]{bOK, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, panel.getDisplayName(), true, options, DialogDescriptor.OK_OPTION, 0, null, null);
        return descriptor;
    }

    public SettingsTableModel getSettingsTableModel() {
        return (SettingsTableModel)this.jTable1.getModel();
    }

    public static String getBundle(String key) {
        return NbBundle.getMessage(LocalDownloadSupport.class, (String)key);
    }

    private class Listener
    implements ListSelectionListener,
    FocusListener,
    TableModelListener,
    DocumentListener {
        private Listener() {
        }

        public void valueChanged(ListSelectionEvent arg0) {
            this.modelOrSelectionChanged();
        }

        public void focusGained(FocusEvent arg0) {
            this.enableDisableRemove();
        }

        public void focusLost(FocusEvent arg0) {
            this.enableDisableRemove();
        }

        private void enableDisableRemove() {
            int rowIndex = SettingsTab.this.jTable1.getSelectedRow();
            SettingsTableModel model = SettingsTab.this.getSettingsTableModel();
            UpdateUnitProvider uup = rowIndex >= 0 ? model.getUpdateUnitProvider(rowIndex) : null;
            boolean enable = rowIndex != -1 && uup != null;
            SettingsTab.this.bRemove.setEnabled(enable);
            SettingsTab.this.bEdit.setEnabled(SettingsTab.this.jTable1.getSelectedRows().length == 1);
        }

        public void tableChanged(TableModelEvent arg0) {
            this.modelOrSelectionChanged();
        }

        private void modelOrSelectionChanged() {
            int rowIndex = SettingsTab.this.jTable1.getSelectedRow();
            if (rowIndex != -1) {
                UpdateUnitProvider uup = ((SettingsTableModel)SettingsTab.this.jTable1.getModel()).getUpdateUnitProvider(rowIndex);
                if (uup != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("<h2>" + uup.getDisplayName() + "</h2>");
                    URL u = uup.getProviderURL();
                    if (u != null) {
                        sb.append("<b>" + SettingsTab.getBundle("SettingsTab_UpdateUnitProvider_Description") + "</b><br>");
                        sb.append("<b>" + SettingsTab.getBundle("SettingsTab_UpdateUnitProvider_URL") + " </b><a href=\"" + u.toExternalForm() + "\">" + u.toExternalForm() + "<br>");
                    }
                    SettingsTab.this.details.getDetails().setText(sb.toString());
                }
            } else {
                ListSelectionModel lsm = SettingsTab.this.jTable1.getSelectionModel();
                lsm.setSelectionInterval(0, 0);
            }
            this.enableDisableRemove();
        }

        public void insertUpdate(DocumentEvent arg0) {
            this.updateFilter();
        }

        public void removeUpdate(DocumentEvent arg0) {
            this.updateFilter();
        }

        public void changedUpdate(DocumentEvent arg0) {
            this.updateFilter();
        }

        private void updateFilter() {
            SettingsTab.this.searchTask.schedule(350);
        }
    }
}

