/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAME_KEYS = new String[]{"SettingsTable_ActiveColumn", "SettingsTable_NameColumn"};
    private static final Class[] COLUMN_TYPES = new Class[]{Boolean.class, String.class};
    private List<UpdateUnitProvider> updateProviders;
    private Set<String> originalProviders;
    private String filter;
    private PluginManagerUI pluginManager = null;
    private final Logger logger = Logger.getLogger("org.netbeans.modules.autoupdate.ui.SettingsTableModel");

    public SettingsTableModel() {
        this.refreshModel();
    }

    void setPluginManager(PluginManagerUI manager) {
        this.pluginManager = manager;
    }

    PluginManagerUI getPluginManager() {
        return this.pluginManager;
    }

    void setFilter(final String filter) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<SettingsTableModel> clazz = SettingsTableModel.class;
                synchronized (SettingsTableModel.class) {
                    SettingsTableModel.this.filter = filter.toLowerCase();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    SettingsTableModel.this.refreshModel();
                    return;
                }
            }
        });
    }

    void refreshModel() {
        Set<String> oldValue = this.originalProviders;
        this.originalProviders = new HashSet<String>();
        final ArrayList<UpdateUnitProvider> forRefresh = new ArrayList<UpdateUnitProvider>();
        List providers = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false);
        for (UpdateUnitProvider p : providers) {
            if (oldValue != null && !oldValue.contains(p.getName()) && p.isEnabled()) {
                forRefresh.add(p);
            }
            this.originalProviders.add(p.getName());
        }
        if (!forRefresh.isEmpty()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Utilities.presentRefreshProviders(forRefresh, SettingsTableModel.this.getPluginManager(), true);
                    SettingsTableModel.this.getPluginManager().updateUnitsChanged();
                }
            });
        }
        this.updateProviders = new ArrayList<UpdateUnitProvider>(providers);
        if (this.filter != null && this.filter.length() > 0) {
            Iterator<UpdateUnitProvider> it = this.updateProviders.iterator();
            while (it.hasNext()) {
                UpdateUnitProvider updateUnitProvider = it.next();
                if (updateUnitProvider.getDisplayName().toLowerCase().indexOf(this.filter) != -1) continue;
                it.remove();
            }
        }
        SettingsTableModel.sortAlphabetically(this.updateProviders);
        this.fireTableDataChanged();
    }

    public void remove(int rowIndex) {
        UpdateUnitProvider unitProvider = this.getUpdateUnitProvider(rowIndex);
        if (unitProvider != null) {
            UpdateUnitProviderFactory.getDefault().remove(unitProvider);
        }
        this.getPluginManager().updateUnitsChanged();
    }

    public void add(String name, String displayName, URL url, boolean state) {
        final UpdateUnitProvider uup = UpdateUnitProviderFactory.getDefault().create(name, displayName, url);
        uup.setEnable(state);
        if (state) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Utilities.presentRefreshProvider(uup, SettingsTableModel.this.getPluginManager(), true);
                    SettingsTableModel.this.getPluginManager().updateUnitsChanged();
                }
            });
        }
    }

    public UpdateUnitProvider getUpdateUnitProvider(int rowIndex) {
        return rowIndex >= 0 && rowIndex < this.updateProviders.size() ? this.updateProviders.get(rowIndex) : null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.updateProviders.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAME_KEYS.length;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        final UpdateUnitProvider unitProvider = this.getUpdateUnitProvider(rowIndex);
        switch (columnIndex) {
            case 0: {
                boolean oldValue = unitProvider.isEnabled();
                boolean newValue = (Boolean)aValue;
                if (oldValue == newValue) break;
                unitProvider.setEnable(newValue);
                if (oldValue) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            SettingsTableModel.this.getPluginManager().updateUnitsChanged();
                        }
                    });
                    break;
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        Utilities.presentRefreshProvider(unitProvider, SettingsTableModel.this.getPluginManager(), false);
                        SettingsTableModel.this.getPluginManager().updateUnitsChanged();
                    }
                });
                break;
            }
            case 1: {
                unitProvider.setDisplayName((String)aValue);
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object retval = null;
        UpdateUnitProvider unitProvider = this.updateProviders.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                retval = unitProvider.isEnabled();
                break;
            }
            case 1: {
                retval = unitProvider.getDisplayName();
            }
        }
        return retval;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_TYPES[columnIndex];
    }

    @Override
    public String getColumnName(int columnIndex) {
        return NbBundle.getMessage(SettingsTableModel.class, (String)COLUMN_NAME_KEYS[columnIndex]);
    }

    private static void sortAlphabetically(List<UpdateUnitProvider> res) {
        Collections.sort(res, new Comparator<UpdateUnitProvider>(){

            @Override
            public int compare(UpdateUnitProvider arg0, UpdateUnitProvider arg1) {
                return arg0.getDisplayName().compareTo(arg1.getDisplayName());
            }
        });
    }
}

