/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.openide.util.Utilities;

public class SortColumnHeaderRenderer
implements TableCellRenderer {
    private UnitCategoryTableModel model;
    private TableCellRenderer textRenderer;
    private Object sortColumn = null;
    private ImageIcon sortDescIcon = null;
    private static ImageIcon sortAscIcon = null;
    private boolean sortAscending = false;

    public SortColumnHeaderRenderer(UnitCategoryTableModel model, TableCellRenderer textRenderer) {
        this.model = model;
        this.textRenderer = textRenderer;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component text = this.textRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (text instanceof JLabel) {
            JLabel label = (JLabel)text;
            if (table.getColumnModel().getColumn(column).getIdentifier().equals(this.sortColumn)) {
                label.setIcon(this.sortAscending ? this.getSortAscIcon() : this.getSortDescIcon());
                label.setHorizontalTextPosition(2);
            } else {
                label.setIcon(null);
            }
        }
        return text;
    }

    public void columnSelected(Object column) {
        if (!column.equals(this.sortColumn)) {
            this.sortColumn = column;
            this.sortAscending = true;
        } else {
            boolean bl = this.sortAscending = !this.sortAscending;
            if (this.sortAscending) {
                this.sortColumn = null;
                this.model.sort(null, this.sortAscending);
                return;
            }
        }
        this.model.sort(column, this.sortAscending);
    }

    private ImageIcon getSortAscIcon() {
        if (sortAscIcon == null) {
            sortAscIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/columnsSortedDesc.gif"));
        }
        return sortAscIcon;
    }

    private ImageIcon getSortDescIcon() {
        if (this.sortDescIcon == null) {
            this.sortDescIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/autoupdate/ui/resources/columnsSortedAsc.gif"));
        }
        return this.sortDescIcon;
    }
}

