/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.text.Collator;
import java.util.Set;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.ModuleProvider;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;

public abstract class Unit {
    UpdateUnit updateUnit = null;

    protected abstract UpdateElement getRelevantElement();

    public abstract boolean isMarked();

    public abstract void setMarked(boolean var1);

    public abstract int getCompleteSize();

    public String getDisplayName() {
        return this.getRelevantElement().getDisplayName();
    }

    public final boolean isVisible(String filter) {
        return filter.length() == 0 || this.getDisplayName().toLowerCase().contains(filter);
    }

    public String getDescription() {
        return this.getRelevantElement().getDescription();
    }

    public String getAuthor() {
        return this.getRelevantElement().getAuthor();
    }

    public String getHomepage() {
        return this.getRelevantElement().getHomepage();
    }

    public String getSource() {
        return this.getRelevantElement().getSource();
    }

    public String getDisplayVersion() {
        return this.getRelevantElement().getSpecificationVersion().toString();
    }

    public static int compareDisplayNames(Unit unit1, Unit unit2) {
        return Collator.getInstance().compare(unit1.getDisplayName(), unit2.getDisplayName());
    }

    public static int compareDisplayVersions(Unit unit1, Unit unit2) {
        return new SpecificationVersion(unit1.getDisplayVersion()).compareTo((Object)new SpecificationVersion(unit2.getDisplayVersion()));
    }

    public static int compareCompleteSizes(Unit unit1, Unit unit2) {
        return Integer.valueOf(unit1.getCompleteSize()).compareTo(unit2.getCompleteSize());
    }

    public static class Available
    extends Unit {
        private UpdateElement updateEl = null;
        private boolean isNbms;
        private int size = -1;

        public Available(UpdateUnit unit, boolean isNbms) {
            this.isNbms = isNbms;
            this.updateUnit = unit;
            this.updateEl = (UpdateElement)unit.getAvailableUpdates().get(0);
            assert (this.updateEl != null) : "Updateable UpdateUnit " + unit + " has UpdateElement for update.";
        }

        public boolean isMarked() {
            OperationContainer<InstallSupport> container = this.isNbms ? Containers.forAvailableNbms() : Containers.forAvailable();
            return container.contains(this.updateEl);
        }

        public void setMarked(boolean marked) {
            OperationContainer<InstallSupport> container;
            assert (marked != this.isMarked());
            OperationContainer<InstallSupport> operationContainer = container = this.isNbms ? Containers.forAvailableNbms() : Containers.forAvailable();
            if (marked) {
                container.add(this.updateUnit, this.updateEl);
            } else {
                container.remove(this.updateEl);
            }
        }

        public static int compareAvailableVersion(Unit u1, Unit u2) {
            if (u1 instanceof Available && u2 instanceof Available) {
                Available unit1 = (Available)u1;
                Available unit2 = (Available)u2;
                return new SpecificationVersion(unit1.getAvailableVersion()).compareTo((Object)new SpecificationVersion(unit2.getAvailableVersion()));
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        public String getAvailableVersion() {
            return this.updateEl.getSpecificationVersion().toString();
        }

        public Integer getMyRating() {
            return null;
        }

        public String getSize() {
            return Utilities.getDownloadSizeAsString(this.updateEl.getDownloadSize());
        }

        public UpdateElement getRelevantElement() {
            return this.updateEl;
        }

        public int getCompleteSize() {
            if (this.size == -1) {
                this.size = 0;
                OperationContainer c = OperationContainer.createForDirectInstall();
                OperationContainer.OperationInfo i = c.add(this.getRelevantElement());
                Set elems = i.getRequiredElements();
                for (UpdateElement el : elems) {
                    this.size += el.getDownloadSize();
                }
                this.size += this.getRelevantElement().getDownloadSize();
                c.removeAll();
            }
            return this.size;
        }
    }

    public static class DummyUnit
    extends Unit {
        private UpdateElement element;

        public DummyUnit(UpdateElement el) {
            this.element = el;
        }

        protected UpdateElement getRelevantElement() {
            return this.element;
        }

        public boolean isMarked() {
            return false;
        }

        public void setMarked(boolean marked) {
        }

        public int getCompleteSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Installed
    extends Unit {
        private UpdateElement installEl = null;
        private UpdateElement backupEl = null;
        private boolean isUninstallAllowed;

        public static boolean isOperationAllowed(UpdateUnit uUnit, UpdateElement element, OperationContainer<OperationSupport> container) {
            ModuleInfo mInfo = ModuleProvider.getInstalledModules().get(element.getCodeName());
            return mInfo != null && container.canBeAdded(uUnit, element);
        }

        public boolean isModuleEnabled() {
            ModuleInfo mInfo = ModuleProvider.getInstalledModules().get(this.installEl.getCodeName());
            return mInfo != null ? mInfo.isEnabled() : false;
        }

        public Installed(UpdateUnit unit) {
            this.updateUnit = unit;
            this.installEl = unit.getInstalled();
            assert (this.installEl != null) : "Installed UpdateUnit " + unit + " has Installed UpdateElement.";
            this.backupEl = unit.getBackup();
            this.isUninstallAllowed = Installed.isOperationAllowed(this.updateUnit, this.installEl, Containers.forUninstall());
        }

        @Override
        public boolean isMarked() {
            return Containers.forUninstall().contains(this.installEl);
        }

        @Override
        public void setMarked(boolean marked) {
            assert (marked != this.isMarked());
            if (marked) {
                Containers.forUninstall().add(this.updateUnit, this.installEl);
            } else {
                Containers.forUninstall().remove(this.installEl);
            }
        }

        public static int compareInstalledVersions(Unit u1, Unit u2) {
            if (u1 instanceof Installed && u2 instanceof Installed) {
                Installed unit1 = (Installed)u1;
                Installed unit2 = (Installed)u2;
                return new SpecificationVersion(unit1.getInstalledVersion()).compareTo((Object)new SpecificationVersion(unit2.getInstalledVersion()));
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        public boolean isUninstallAllowed() {
            return this.isUninstallAllowed;
        }

        public String getInstalledVersion() {
            assert (this.installEl.getSpecificationVersion() != null) : this.installEl + " has specification version.";
            return this.installEl.getSpecificationVersion().toString();
        }

        public String getBackupVersion() {
            return this.backupEl == null ? "-" : this.backupEl.getSpecificationVersion().toString();
        }

        public Integer getMyRating() {
            return null;
        }

        @Override
        public UpdateElement getRelevantElement() {
            return this.installEl;
        }

        @Override
        public int getCompleteSize() {
            return -1;
        }
    }

    public static class Update
    extends Unit {
        private UpdateElement installEl = null;
        private UpdateElement updateEl = null;
        private boolean isNbms;
        private int size = -1;

        public Update(UpdateUnit unit, boolean isNbms) {
            this.isNbms = isNbms;
            this.updateUnit = unit;
            this.installEl = unit.getInstalled();
            assert (this.installEl != null) : "Updateable UpdateUnit " + unit + " has Installed UpdateElement.";
            this.updateEl = (UpdateElement)unit.getAvailableUpdates().get(unit.getAvailableUpdates().size() - 1);
            assert (this.updateEl != null) : "Updateable UpdateUnit " + unit + " has UpdateElement for update.";
        }

        public boolean isMarked() {
            OperationContainer<InstallSupport> container = this.isNbms ? Containers.forUpdateNbms() : Containers.forUpdate();
            return container.contains(this.updateEl);
        }

        public void setMarked(boolean marked) {
            OperationContainer<InstallSupport> container;
            assert (marked != this.isMarked());
            OperationContainer<InstallSupport> operationContainer = container = this.isNbms ? Containers.forUpdateNbms() : Containers.forUpdate();
            if (marked) {
                container.add(this.updateUnit, this.updateEl);
            } else {
                container.remove(this.updateEl);
            }
        }

        public static int compareInstalledVersions(Unit u1, Unit u2) {
            if (u1 instanceof Update && u2 instanceof Update) {
                Update unit1 = (Update)u1;
                Update unit2 = (Update)u2;
                return new SpecificationVersion(unit1.getInstalledVersion()).compareTo((Object)new SpecificationVersion(unit2.getInstalledVersion()));
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        public static int compareAvailableVersions(Unit u1, Unit u2) {
            if (u1 instanceof Update && u2 instanceof Update) {
                Update unit1 = (Update)u1;
                Update unit2 = (Update)u2;
                return new SpecificationVersion(unit1.getAvailableVersion()).compareTo((Object)new SpecificationVersion(unit2.getAvailableVersion()));
            }
            return Unit.compareDisplayVersions(u1, u2);
        }

        public String getInstalledVersion() {
            return this.installEl.getSpecificationVersion().toString();
        }

        public String getAvailableVersion() {
            return this.updateEl.getSpecificationVersion().toString();
        }

        public String getSize() {
            return Utilities.getDownloadSizeAsString(this.updateEl.getDownloadSize());
        }

        public UpdateElement getRelevantElement() {
            return this.updateEl;
        }

        public int getCompleteSize() {
            if (this.size == -1) {
                this.size = 0;
                OperationContainer c = OperationContainer.createForDirectUpdate();
                OperationContainer.OperationInfo i = c.add(this.getRelevantElement());
                Set elems = i.getRequiredElements();
                for (UpdateElement el : elems) {
                    this.size += el.getDownloadSize();
                }
                this.size += this.getRelevantElement().getDownloadSize();
                c.removeAll();
            }
            return this.size;
        }
    }
}

