/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.netbeans.modules.autoupdate.ui.UpdateUnitListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnitCategoryTableModel
extends AbstractTableModel {
    List<UnitCategory> data = Collections.emptyList();
    private List<Unit> unitData = Collections.emptyList();
    private List<UpdateUnitListener> listeners = new ArrayList<UpdateUnitListener>();
    private String filter = "";
    private Comparator<Unit> unitCmp;
    private Comparator<UnitCategory> categoryCmp;
    private boolean showCategories = true;

    public UnitCategoryTableModel(List<UnitCategory> categories) {
        this.setData(categories);
    }

    @Override
    public abstract Object getValueAt(int var1, int var2);

    public abstract Class getColumnClass(int var1);

    public abstract Type getType();

    public abstract boolean isSortAllowed(Object var1);

    public abstract OperationContainer getContainer();

    protected abstract Comparator<Unit> getComparator(Object var1, boolean var2);

    protected Comparator<Unit> getDefaultComparator() {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                return Unit.compareDisplayNames(o1, o2);
            }
        };
    }

    public final void sort(Object columnIdentifier, boolean sortAscending) {
        if (columnIdentifier == null) {
            this.setUnitComparator(this.getDefaultComparator(), true);
        } else {
            this.setUnitComparator(this.getComparator(columnIdentifier, sortAscending), false);
        }
        this.fireTableDataChanged();
    }

    public final void setData(List<UnitCategory> data, boolean showCategories, Comparator<UnitCategory> categoryCmp, Comparator<Unit> unitCmp) {
        this.categoryCmp = categoryCmp;
        this.unitCmp = unitCmp;
        this.showCategories = showCategories;
        this.data = data;
        this.unitData = Collections.emptyList();
        if (showCategories) {
            if (categoryCmp != null) {
                Collections.sort(this.data, categoryCmp);
            }
            if (unitCmp != null) {
                for (UnitCategory unitCategory : data) {
                    Collections.sort(unitCategory.units, unitCmp);
                }
            }
        } else {
            this.unitData = new ArrayList<Unit>();
            for (UnitCategory unitCategory : data) {
                this.unitData.addAll(unitCategory.getUnits());
            }
            if (unitCmp != null) {
                Collections.sort(this.unitData, unitCmp);
            }
        }
        this.fireTableDataChanged();
    }

    public void setUnitComparator(Comparator<Unit> comparator, boolean showCategories) {
        this.setData(this.data, showCategories, this.categoryCmp, comparator);
    }

    public void setUnitComparator(Comparator<Unit> comparator) {
        this.setUnitComparator(comparator, this.showCategories);
    }

    public void setCategoryComparator(Comparator<UnitCategory> comparator, boolean showCategories) {
        this.setData(this.data, showCategories, comparator, this.unitCmp);
    }

    public void setShowCategoriesEnabled(boolean showCategories) {
        this.setData(this.data, showCategories, this.categoryCmp, this.unitCmp);
    }

    public final void setData(List<UnitCategory> data) {
        this.setData(data, this.showCategories, this.categoryCmp, this.unitCmp);
    }

    public void setFilter(final String filter) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Class<UnitCategoryTableModel> clazz = UnitCategoryTableModel.class;
                synchronized (UnitCategoryTableModel.class) {
                    UnitCategoryTableModel.this.filter = filter.toLowerCase();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    UnitCategoryTableModel.this.fireUpdataUnitChange();
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilter() {
        Class<UnitCategoryTableModel> clazz = UnitCategoryTableModel.class;
        synchronized (UnitCategoryTableModel.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.filter == null ? "" : this.filter;
        }
    }

    public void expandAll() {
        if (this.showCategories) {
            List<UnitCategory> data = this.getCategories();
            for (UnitCategory unitCategory : data) {
                unitCategory.setExpanded(true);
            }
        }
    }

    public void collapseAll() {
        if (this.showCategories) {
            List<UnitCategory> data = this.getCategories();
            for (UnitCategory unitCategory : data) {
                unitCategory.setExpanded(false);
            }
        }
    }

    public void addUpdateUnitListener(UpdateUnitListener l) {
        this.listeners.add(l);
    }

    public void removeUpdateUnitListener(UpdateUnitListener l) {
        this.listeners.remove(l);
    }

    void fireUpdataUnitChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (UpdateUnitListener l : this.listeners) {
            l.updateUnitsChanged();
        }
    }

    void fireButtonsChange() {
        assert (this.listeners != null) : "UpdateUnitListener found.";
        for (UpdateUnitListener l : this.listeners) {
            l.buttonsChanged();
        }
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    private List<UnitCategory> getCategories() {
        assert (this.showCategories);
        return new ArrayList<UnitCategory>(this.data);
    }

    private List<Unit> getVisibleUnits() {
        assert (!this.showCategories);
        String filter = this.getFilter();
        ArrayList<Unit> retval = new ArrayList<Unit>();
        for (Unit unit : this.unitData) {
            if (!unit.isVisible(filter)) continue;
            retval.add(unit);
        }
        return retval;
    }

    private List<UnitCategory> getVisibleCategories() {
        assert (this.showCategories);
        String filter = this.getFilter();
        ArrayList<UnitCategory> retval = new ArrayList<UnitCategory>();
        for (UnitCategory unitCategory : this.data) {
            if (!unitCategory.isVisible(filter)) continue;
            retval.add(unitCategory);
        }
        return retval;
    }

    @Override
    public int getRowCount() {
        if (this.showCategories) {
            List<UnitCategory> data = this.getVisibleCategories();
            int size = data.size();
            String filter = this.getFilter();
            for (UnitCategory c : data) {
                if (!c.isExpanded() || !c.isVisible(filter)) continue;
                size += this.getUnits(c).size();
            }
            return size;
        }
        return this.getVisibleUnits().size();
    }

    public int getRawItemCount() {
        int size = 0;
        if (this.showCategories) {
            for (UnitCategory c : this.getCategories()) {
                size += c.getUnits().size();
            }
        } else {
            size = this.unitData.size();
        }
        return size;
    }

    public int getItemCount() {
        int size = 0;
        if (this.showCategories) {
            List<UnitCategory> data = this.getVisibleCategories();
            for (UnitCategory c : data) {
                size += this.getUnits(c).size();
            }
        } else {
            size = this.getVisibleUnits().size();
        }
        return size;
    }

    private List<Unit> getUnits(UnitCategory category) {
        assert (this.showCategories);
        String filter = this.getFilter();
        return filter.length() == 0 ? category.getUnits() : category.getVisibleUnits(filter, !Type.INSTALLED.equals((Object)this.getType()));
    }

    public Collection<Unit> getMarkedUnits() {
        ArrayList<Unit> units = new ArrayList<Unit>();
        if (this.showCategories) {
            for (UnitCategory c : this.data) {
                for (Unit u : c.getUnits()) {
                    if (!u.isMarked()) continue;
                    units.add(u);
                }
            }
        } else {
            for (Unit u : this.unitData) {
                if (!u.isMarked()) continue;
                units.add(u);
            }
        }
        return units;
    }

    private int getCategorySize(UnitCategory c) {
        assert (this.showCategories);
        int retval = 0;
        String filter = this.getFilter();
        retval = c.isVisible(filter) ? (c.isExpanded() ? this.getUnits(c).size() + 1 : 1) : 0;
        return retval;
    }

    protected UnitCategory getCategoryAtRow(int row) {
        if (this.showCategories) {
            int categoryRow = 0;
            List<UnitCategory> data = this.getVisibleCategories();
            for (UnitCategory c : data) {
                int size = this.getCategorySize(c);
                if (row >= categoryRow && row < categoryRow + size) {
                    return c;
                }
                categoryRow += size;
            }
            assert (false) : "No UpdateCategory on row " + row;
        }
        return null;
    }

    public Unit getUnitAtRow(int row) {
        if (this.showCategories) {
            int unitRow = 0;
            List<UnitCategory> data = this.getVisibleCategories();
            for (UnitCategory c : data) {
                int size = this.getCategorySize(c);
                if (row > unitRow && row <= unitRow + size) {
                    if (!c.isExpanded()) assert (false) : "No Unit at row " + row + ", but Category " + c;
                    int idx = row - unitRow - 1;
                    return idx < this.getUnits(c).size() ? this.getUnits(c).get(idx) : null;
                }
                unitRow += size;
            }
            return null;
        }
        return this.getVisibleUnits().size() <= row ? null : this.getVisibleUnits().get(row);
    }

    public void toggleCategoryExpanded(int row) {
        assert (this.showCategories);
        this.getCategoryAtRow(row).toggleExpanded();
        this.fireTableDataChanged();
    }

    public boolean isCategoryAtRow(int row) {
        return this.showCategories ? this.isCategoryAtRow(row, this.data) : false;
    }

    private boolean isCategoryAtRow(int row, List<UnitCategory> data) {
        int accumulatedRow = 0;
        if (this.showCategories) {
            for (UnitCategory c : data) {
                int size = this.getCategorySize(c);
                if (row >= accumulatedRow && row < accumulatedRow + size) {
                    return row == accumulatedRow;
                }
                accumulatedRow += size;
            }
        }
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.isCategoryAtRow(row)) {
            return false;
        }
        return col == 0 || col == 1;
    }

    public int getDownloadSize() {
        int res = 0;
        OperationContainer container = this.getContainer();
        assert (container != null) : "OperationContainer found when asking for download size.";
        List infos = container.listAll();
        HashSet<UpdateElement> elements = new HashSet<UpdateElement>();
        for (OperationContainer.OperationInfo info : infos) {
            elements.add(info.getUpdateElement());
            elements.addAll(info.getRequiredElements());
        }
        for (UpdateElement el : elements) {
            res += el.getDownloadSize();
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INSTALLED,
        UPDATE,
        AVAILABLE,
        LOCAL;

    }
}

